/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SalesSummaryDAO
extends _RootDAO {
    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object obj) {
        return super.save(obj);
    }

    @Override
    public void saveOrUpdate(Object obj) {
        super.saveOrUpdate(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> findSalesAnalysis(Date start, Date end, UserType userType, Terminal terminal) {
        Session session = null;
        try {
            ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> list = new ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData>();
            session = this.getSession();
            Criteria criteria = session.createCriteria(Shift.class);
            List shifts = criteria.list();
            criteria = session.createCriteria(MenuCategory.class);
            List categories = criteria.list();
            MenuCategory othersCategory = new MenuCategory();
            othersCategory.setName(Messages.getString("SalesSummaryDAO.3"));
            categories.add(othersCategory);
            for (Shift shift : shifts) {
                for (MenuCategory category : categories) {
                    List datas;
                    criteria = session.createCriteria(TicketItem.class, "item");
                    criteria.createCriteria("ticket", "t");
                    ProjectionList projectionList = Projections.projectionList();
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TAX_AMOUNT));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                    criteria.setProjection((Projection)projectionList);
                    this.doHandleMenuCategorySearch(criteria, category);
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SHIFT_ID), (Object)shift.getId()));
                    criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)start));
                    criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)end));
                    if (userType != null) {
                        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_TYPE_ID), (Object)userType.getId()));
                    }
                    if (terminal != null) {
                        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
                    }
                    if ((datas = criteria.list()).size() <= 0) continue;
                    Object[] objects = (Object[])datas.get(0);
                    ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                    data.setShiftName(shift.getName());
                    data.setCategoryName(category.getName());
                    if (objects.length > 0 && objects[0] != null) {
                        data.setCount(((Number)objects[0]).intValue());
                    }
                    if (objects.length > 1 && objects[1] != null) {
                        data.setGross(((Number)objects[1]).doubleValue());
                    }
                    if (objects.length > 2 && objects[2] != null) {
                        data.setDiscount(((Number)objects[2]).doubleValue());
                    }
                    if (objects.length > 3 && objects[3] != null) {
                        data.setTaxAmount(((Number)objects[3]).doubleValue());
                    }
                    if (objects.length > 4 && objects[4] != null) {
                        data.setNetSales(((Number)objects[4]).doubleValue());
                    }
                    list.add(data);
                }
            }
            for (MenuCategory category : categories) {
                List datas;
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria("ticket", "t");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TAX_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                this.doHandleMenuCategorySearch(criteria, category);
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)start));
                criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)end));
                if (userType != null) {
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_TYPE_ID), (Object)userType.getId()));
                }
                if (terminal != null) {
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
                }
                if ((datas = criteria.list()).size() <= 0) continue;
                Object[] objects = (Object[])datas.get(0);
                ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                data.setShiftName("ALL DAY");
                data.setCategoryName(category.getName());
                if (objects.length > 0 && objects[0] != null) {
                    data.setCount(((Number)objects[0]).intValue());
                }
                if (objects.length > 1 && objects[1] != null) {
                    data.setGross(((Number)objects[1]).doubleValue());
                }
                if (objects.length > 2 && objects[2] != null) {
                    data.setDiscount(((Number)objects[2]).doubleValue());
                }
                if (objects.length > 3 && objects[3] != null) {
                    data.setTaxAmount(((Number)objects[3]).doubleValue());
                }
                if (objects.length > 4 && objects[4] != null) {
                    data.setNetSales(((Number)objects[4]).doubleValue());
                }
                list.add(data);
            }
            ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> arrayList = list;
            return arrayList;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void doHandleMenuCategorySearch(Criteria criteria, MenuCategory category) {
        if (category.getId() == null) {
            if (category.getName() != null && category.getName().equals(Messages.getString("SalesSummaryDAO.3"))) {
                criteria.add(Restrictions.isNull((String)("item." + TicketItem.PROP_CATEGORY_ID)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_NAME), (Object)category.getName()));
            }
        } else {
            criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_ID), (Object)category.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesStatistics findKeyStatistics(Date start, Date end, UserType userType, Terminal terminal, List<OrderType> orderTypes, boolean showSummarize) {
        Session session = null;
        List<String> orderTypeIds = POSUtil.getStringIds(orderTypes, OrderType.class);
        try {
            Object objects;
            SalesStatistics salesSummary = new SalesStatistics();
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)ShopTable.PROP_CAPACITY));
            criteria.setProjection((Projection)projectionList);
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list.size() > 0) {
                objects = (Object[])list.get(0);
                salesSummary.setTableCount(((Number)objects[0]).intValue());
                if (((Object[])objects).length > 1 && objects[1] != null) {
                    salesSummary.setCapacity(((Number)objects[1]).intValue());
                }
            }
            criteria = session.createCriteria(Ticket.class, "ticket");
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount(), "rowCount");
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT), "grossSales");
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT), "discount");
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT), "tax");
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS), "guestCount");
            criteria.setProjection((Projection)projectionList);
            this.createCommonCriteria(start, end, orderTypeIds, Boolean.FALSE, criteria);
            list = criteria.list();
            if (list.size() > 0) {
                objects = (Object[])list.get(0);
                salesSummary.setCheckCount(((Number)objects[0]).intValue());
                if (((Object[])objects).length > 1 && objects[1] != null) {
                    salesSummary.setGrossSales(((Number)objects[1]).doubleValue());
                }
                if (((Object[])objects).length > 2 && objects[2] != null) {
                    salesSummary.setDiscount(((Number)objects[2]).doubleValue());
                }
                if (((Object[])objects).length > 3 && objects[3] != null) {
                    salesSummary.setTax(((Number)objects[3]).doubleValue());
                }
                if (((Object[])objects).length > 4 && objects[4] != null) {
                    salesSummary.setGuestCount(((Number)objects[4]).intValue());
                }
            }
            criteria = session.createCriteria(Ticket.class, "ticket");
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            this.createCommonCriteria(start, end, orderTypeIds, false, criteria);
            list = criteria.list();
            if (list.size() > 0) {
                objects = (Object[])list.get(0);
                salesSummary.setOpenChecks(((Number)objects[0]).intValue());
                if (((Object[])objects).length > 1 && objects[1] != null) {
                    salesSummary.setOpenAmount(((Number)objects[1]).doubleValue());
                }
            }
            criteria = session.createCriteria(Ticket.class, "ticket");
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)Ticket.PROP_VOID_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            this.createCommonCriteria(start, end, orderTypeIds, Boolean.TRUE, criteria);
            list = criteria.list();
            if (list.size() > 0) {
                objects = (Object[])list.get(0);
                salesSummary.setVoidChecks(((Number)objects[0]).intValue());
                if (((Object[])objects).length > 1 && objects[1] != null) {
                    salesSummary.setVoidAmount(((Number)objects[1]).doubleValue());
                }
            }
            criteria = session.createCriteria(Ticket.class, "ticket");
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            criteria.setProjection((Projection)projectionList);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            this.createCommonCriteria(start, end, orderTypeIds, false, criteria);
            list = criteria.list();
            if (list.size() > 0) {
                objects = list.get(0);
                double intValue = ((Number)objects).doubleValue();
                salesSummary.setClosedChecks(intValue);
            }
            List<AttendenceHistory> clockedInHistory = AttendenceHistoryDAO.getInstance().findClockedInUsers(start, end, userType);
            double laborHours = 0.0;
            double laborCost = 0.0;
            int labor = 0;
            for (AttendenceHistory attendenceHistory : clockedInHistory) {
                double laborHourInMillisecond = 0.0;
                laborHourInMillisecond = attendenceHistory.isClockedOut() == false || attendenceHistory.getClockOutTime() == null ? (double)Math.abs(end.getTime() - attendenceHistory.getClockInTime().getTime()) : (double)Math.abs(attendenceHistory.getClockOutTime().getTime() - attendenceHistory.getClockInTime().getTime());
                double hour = laborHourInMillisecond * (2.77777778 * Math.pow(10.0, -7.0));
                laborHours += hour;
                User user = attendenceHistory.getUser();
                double costPerHour = 0.0;
                if (user != null) {
                    ++labor;
                    costPerHour = user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
                }
                laborCost += hour * costPerHour;
            }
            salesSummary.setLaborHour(laborHours);
            salesSummary.setLaborCost(laborCost);
            salesSummary.setLaborCount(labor);
            criteria = session.createCriteria(Shift.class);
            List shifts = criteria.list();
            if (orderTypes.isEmpty()) {
                orderTypes = Application.getInstance().getOrderTypes();
            }
            if (showSummarize) {
                for (OrderType orderType : orderTypes) {
                    this.findRecordByOrderType(start, end, session, salesSummary, null, orderType);
                }
            } else {
                for (OrderType object : shifts) {
                    Shift shift = (Shift)((Object)object);
                    for (OrderType orderType : orderTypes) {
                        this.findRecordByOrderType(start, end, session, salesSummary, shift, orderType);
                    }
                }
            }
            salesSummary.calculateOthers();
            SalesStatistics salesStatistics = salesSummary;
            return salesStatistics;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void createCommonCriteria(Date start, Date end, List<String> orderTypeIds, Boolean isVoid, Criteria criteria) {
        this.createCommonCriteria(start, end, orderTypeIds, isVoid, null, criteria);
    }

    private void createCommonCriteria(Date start, Date end, List<String> orderTypeIds, Boolean isVoid, Boolean isReturn, Criteria criteria) {
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)start));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)end));
        if (!orderTypeIds.isEmpty()) {
            criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
        }
        if (isVoid != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)isVoid));
        }
        if (isReturn != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)isReturn));
        }
    }

    private void findRecordByOrderType(Date start, Date end, Session session, SalesStatistics salesSummary, Shift shift, OrderType orderType) {
        Criteria criteria = session.createCriteria(Ticket.class, "ticket");
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add(Projections.rowCount());
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        if (shift != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)shift.getId()));
        }
        this.createCommonCriteria(start, end, orderType == null ? null : Arrays.asList(orderType.getId()), false, criteria);
        List list = criteria.list();
        if (list.size() > 0) {
            SalesStatistics.ShiftwiseSalesTableData data = new SalesStatistics.ShiftwiseSalesTableData();
            data.setOrderType(orderType.toString());
            Object[] objects = (Object[])list.get(0);
            data.setShiftName(shift == null ? POSConstants.ALL : shift.getName());
            data.setCheckCount(((Number)objects[0]).intValue());
            if (objects.length > 1 && objects[1] != null) {
                data.setGuestCount(((Number)objects[1]).intValue());
            }
            if (objects.length > 2 && objects[2] != null) {
                data.setGrossSales(((Number)objects[2]).doubleValue());
            }
            if (objects.length > 3 && objects[3] != null) {
                data.setDiscount(((Number)objects[3]).doubleValue());
            }
            data.calculateOthers();
            data.setPercentage(data.getNetSales() * 100.0 / salesSummary.getGrossSales());
            salesSummary.addSalesTableData(data);
        }
    }
}

