/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.BaseShiftDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ShiftDAO
extends BaseShiftDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        Shift shift;
        if (obj instanceof Shift) {
            List<PriceRule> priceRules;
            shift = (Shift)obj;
            if (shift instanceof MenuShift) {
                List<MenuCategory> categories = MenuCategoryDAO.getInstance().findByMenuShiftId(shift.getId(), session);
                if (categories != null && !categories.isEmpty()) {
                    String details = "";
                    details = Messages.getString("MenuItemDAO.222");
                    int count = 1;
                    for (MenuCategory category : categories) {
                        details = details + "\n" + count + ". " + category.getName();
                        ++count;
                    }
                    throw new PosException(Messages.getString("ShiftDAO.0"), details);
                }
            } else if (shift instanceof PriceShift && (priceRules = PriceRuleDAO.getInstance().findByPriceShiftId(shift.getId(), session, Boolean.TRUE)) != null && !priceRules.isEmpty()) {
                String details = "";
                details = Messages.getString("MenuItemDAO.333");
                int count = 1;
                for (PriceRule priceRule : priceRules) {
                    details = details + "\n" + count + ". " + priceRule.getName();
                    ++count;
                }
                throw new PosException(Messages.getString("ShiftDAO.1"), details);
            }
        } else {
            throw new PosException(Messages.getString("ShiftDAO.2"));
        }
        shift.setDeleted(Boolean.TRUE);
        super.update(shift, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Shift> findAllActive() {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)PriceShift.PROP_ENABLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)PriceShift.PROP_PRIORITY));
            List list = criteria.list();
            return list;
        }
    }

    public boolean exists(String shiftName) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)shiftName));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("ShiftDAO.14"), e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Shift getByName(String shiftName) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)shiftName));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Shift shift = (Shift)list.get(0);
                return shift;
            }
            Shift shift = null;
            return shift;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("ShiftDAO.15"), e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void refresh(Shift shift) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shift);
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("ShiftDAO.16"), e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Shift findByName(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)name));
            Shift shift = (Shift)criteria.uniqueResult();
            return shift;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveOrUpdateShifts(List<Shift> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Shift item : dataList) {
                Shift existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Shift> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Shift.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }
}

