/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.dao.BaseShopFloorTemplateDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ShopFloorTemplateDAO
extends BaseShopFloorTemplateDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ShopFloorTemplate> findByParent(ShopFloor selectedValue) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopFloorTemplate.PROP_FLOOR, (Object)selectedValue));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateTemplates(List<ShopFloorTemplate> templates) {
        if (templates == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopFloorTemplate template : templates) {
                session.saveOrUpdate((Object)template);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemplates(List<ShopFloorTemplate> templates) {
        if (templates == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopFloorTemplate template : templates) {
                session.delete((Object)template);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    public void setDefaultTemplate(ShopFloorTemplate template, ShopFloor shopFloor) {
        block14: {
            Transaction transaction = null;
            try (Session session = this.createNewSession();){
                transaction = session.beginTransaction();
                String hql = "UPDATE %s template SET template.%s = :default WHERE template.%s = :floor";
                hql = String.format(hql, ShopFloorTemplate.REF, ShopFloorTemplate.PROP_DEFAULT_FLOOR, ShopFloorTemplate.PROP_FLOOR);
                Query query = session.createQuery(hql);
                query.setParameter("default", (Object)Boolean.FALSE);
                query.setParameter("floor", (Object)shopFloor);
                query.executeUpdate();
                template.setDefaultFloor(true);
                session.update((Object)template);
                session.update((Object)shopFloor);
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction == null) break block14;
                transaction.commit();
            }
        }
    }

    public void saveOrUpdateShopFloorTemplates(List<ShopFloorTemplate> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (ShopFloorTemplate shopFloor : dataList) {
                ShopFloorTemplate existingShopFloorTemplate = this.get(shopFloor.getId());
                shopFloor.setUpdateLastUpdateTime(updateLastUpdateTime);
                shopFloor.setUpdateSyncTime(updateSyncTime);
                if (existingShopFloorTemplate == null) {
                    this.save(shopFloor, session);
                } else {
                    if (!BaseDataServiceDao.get().shouldSave(shopFloor.getLastUpdateTime(), existingShopFloorTemplate.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopFloor.getName() + " already updated");
                        continue;
                    }
                    shopFloor.setVersion(existingShopFloorTemplate.getVersion());
                }
                this.update(shopFloor, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }
}

