/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseShopTableStatusDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.util.CopyUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ShopTableStatusDAO
extends BaseShopTableStatusDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)obj;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        Serializable save = super.save(obj, s);
        this.publishOnMqtt(shopTableStatus);
        return save;
    }

    @Override
    protected void update(Object obj, Session s) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)obj;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        super.update(obj, s);
        this.publishOnMqtt(shopTableStatus);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)obj;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        super.saveOrUpdate(obj, s);
        this.publishOnMqtt(shopTableStatus);
    }

    private void publishOnMqtt(ShopTableStatus shopTableStatus) {
        if (!shopTableStatus.isShouldPublishMqtt()) {
            return;
        }
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
    }

    public void addTicketsToShopTableStatus(List<Integer> tableNumbers, List<Ticket> tickets, Session session) {
        if (tableNumbers == null || tableNumbers.isEmpty() || tickets == null) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            ShopTableStatus shopTableStatus = this.get(tableNumber);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(tableNumber);
            }
            shopTableStatus.setTableStatus(TableStatus.Serving);
            shopTableStatus.addToTableTickets(tickets);
            if (session == null) {
                this.saveOrUpdate(shopTableStatus);
                continue;
            }
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void removeTicketFromShopTableStatus(Ticket ticket, Session session) {
        if (ticket == null) {
            return;
        }
        List<Integer> tableNumbers = ticket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            ShopTableDAO shopTableDAO;
            ShopTable shopTable;
            ShopTableStatus shopTableStatus;
            ShopTableStatus shopTableStatus2 = shopTableStatus = session == null ? this.get(tableNumber) : this.get(tableNumber, session);
            if (shopTableStatus == null) {
                return;
            }
            List<ShopTableTicket> ticketNumbers = shopTableStatus.getTicketNumbers();
            if (ticketNumbers != null) {
                Iterator<ShopTableTicket> iterator = ticketNumbers.iterator();
                while (iterator.hasNext()) {
                    ShopTableTicket shopTableTicket = iterator.next();
                    if (!shopTableTicket.getTicketId().equals(ticket.getId())) continue;
                    iterator.remove();
                }
            }
            shopTableStatus.setTicketNumbers(ticketNumbers);
            if (ticketNumbers == null || ticketNumbers.isEmpty()) {
                shopTableStatus.setTicketNumbers(null);
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
            }
            if ((shopTable = (shopTableDAO = ShopTableDAO.getInstance()).get(tableNumber)) != null) {
                BookingInfoDAO bookingInfoDAO;
                BookingInfo bookingInfo;
                if (shopTable.getCurrentBookingId() != null && (bookingInfo = (bookingInfoDAO = BookingInfoDAO.getInstance()).get(shopTable.getCurrentBookingId())) != null) {
                    bookingInfo.setStatus("close");
                    bookingInfo.setClosed(true);
                    bookingInfoDAO.saveOrUpdate(bookingInfo);
                }
                shopTable.setCurrentBookingId(null);
                shopTable.setCustomerName(null);
                shopTable.removeProperty("shop.table_customer.id");
                shopTable.removeProperty("RES_NO");
                shopTableDAO.update(shopTable, session);
            }
            shopTableStatus.setShouldPublishMqtt(ticket.isShouldPublishMqtt());
            if (session == null) {
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus);
                continue;
            }
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
        }
    }

    public void saveShopTableStatus(ShopTableStatus sTableStatus, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (sTableStatus == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            ShopTableStatus existingShopTableStatus = this.get(sTableStatus.getId());
            if (existingShopTableStatus == null) {
                sTableStatus.setUpdateLastUpdateTime(updateLastUpdateTime);
                sTableStatus.setUpdateSyncTime(updateSyncTime);
                this.save(sTableStatus, session);
            }
            tx.commit();
        }
    }

    public ShopTableStatus updateVersionOfShopTableStatus(ShopTableStatus shopTableStatus) throws Exception {
        ShopTableStatus existingItem = ShopTableStatusDAO.getInstance().get(shopTableStatus.getId());
        if (existingItem != null) {
            long versionItemModifier = existingItem.getVersion();
            CopyUtil.deepCopy(shopTableStatus);
            shopTableStatus.setVersion(versionItemModifier);
        }
        return shopTableStatus;
    }

    public void saveOrUpdateShopTableStatus(List<ShopTableStatus> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTableStatus item : dataList) {
                item.setShouldPublishMqtt(false);
                ShopTableStatus existingItem = this.get(item.getId());
                if (existingItem != null) {
                    long version = existingItem.getVersion();
                    CopyUtil.deepCopy(item);
                    item.setVersion(version);
                    item.setUpdateLastUpdateTime(updateLastUpdateTime);
                    item.setUpdateSyncTime(updateSyncTime);
                    this.update(item, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findOpenTickets(ShopTableStatus status) {
        return this.findTickets(status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(ShopTableStatus status, Boolean includeClosedTickets) {
        if (status == null) {
            return null;
        }
        List<String> ticketIds = status.getListOfTicketNumbers();
        if (ticketIds == null || ticketIds.isEmpty()) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.in((String)Ticket.PROP_ID, ticketIds));
            if (!includeClosedTickets.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

