/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.BaseShopTableTypeDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class ShopTableTypeDAO
extends BaseShopTableTypeDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        ShopTableType bean = (ShopTableType)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("ShopTableTypeDAO.0"));
        }
        this.checkForeignRelation(bean);
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    private void checkForeignRelation(ShopTableType bean) throws PosException {
        String id = bean.getId();
        try (Session session = this.createNewSession();){
            List foreignItems = GenericDAO.getInstance().getForeignDataList(session, ShopTable.class, "types", ShopTableType.PROP_ID, id, ShopTable.PROP_ID);
            if (foreignItems != null && foreignItems.size() > 0) {
                String details = Messages.getString("ShopTableTypeDAO.2") + (foreignItems.size() > 1 ? Messages.getString("ShopTableTypeDAO.3") : ":");
                int count = 1;
                for (Integer tableNumber : foreignItems) {
                    details = details + "\n" + count + ". " + tableNumber;
                    ++count;
                }
                throw new PosException(Messages.getString("ShopTableTypeDAO.7"), details);
            }
        }
    }

    @Override
    public List<ShopTableType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateShopTableType(List<ShopTableType> shopTableTypeList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (shopTableTypeList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (ShopTableType item : shopTableTypeList) {
                ShopTableType existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)ShopTableType.PROP_ID);
    }
}

