/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.BaseStockCountDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StockCountItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StockCountDAO
extends BaseStockCountDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(StockCount stockCount, boolean updateStock) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(stockCount, updateStock, session);
            tx.commit();
        }
    }

    public void saveOrUpdate(StockCount stockCount, boolean updateStock, Session session) {
        if (stockCount.getId() == null) {
            stockCount.setCreatedDate(new Date());
        }
        stockCount.setLastModifiedDate(new Date());
        if (updateStock) {
            this.adjustInventoryItems(session, stockCount);
        }
        session.saveOrUpdate((Object)stockCount);
    }

    private void adjustInventoryItems(Session session, StockCount stockCount) {
        List<StockCountItem> orderItems = stockCount.getCountItems();
        if (orderItems == null) {
            return;
        }
        for (StockCountItem orderItem : orderItems) {
            if (orderItem.isAdjusted().booleanValue()) continue;
            orderItem.setAdjusted(Boolean.TRUE);
            Double stockDifference = orderItem.getActualUnit() - orderItem.getUnitOnHand();
            if (stockDifference == 0.0) continue;
            InventoryTransaction stockInTrans = new InventoryTransaction();
            MenuItem menuItem = MenuItemDAO.getInstance().get(orderItem.getItemId(), session);
            if (menuItem == null && (menuItem = MenuItemDAO.getInstance().getMenuItemBySKU(orderItem.getSku(), session, true)) != null) {
                orderItem.setItemId(menuItem.getId());
            }
            Hibernate.initialize(menuItem.getStockUnits());
            stockInTrans.setMenuItem(menuItem);
            stockInTrans.setQuantity(Math.abs(stockDifference));
            stockInTrans.setUnit(orderItem.getUnit());
            double baseUnitQuantity = menuItem.getBaseUnitQuantity(orderItem.getUnit());
            stockInTrans.setUnitCost(baseUnitQuantity * menuItem.getCost());
            stockInTrans.setTotal(baseUnitQuantity * stockInTrans.getQuantity() * menuItem.getCost());
            stockInTrans.setTransactionDate(stockCount.getPostDate() == null ? new Date() : stockCount.getPostDate());
            String reason = orderItem.getReason();
            if (StringUtils.isEmpty((CharSequence)reason)) {
                String strReason = stockDifference > 0.0 ? "ADJUST_IN" : "ADJUST_OUT";
                stockInTrans.setReason(strReason);
            } else {
                stockInTrans.setReason(reason);
            }
            if (stockDifference > 0.0) {
                stockInTrans.setType(InventoryTransactionType.IN.getType());
                stockInTrans.setToInventoryLocation(orderItem.getInventoryLocation());
            } else {
                stockInTrans.setType(InventoryTransactionType.OUT.getType());
                stockInTrans.setFromInventoryLocation(orderItem.getInventoryLocation());
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(stockInTrans, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextStockCountSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)StockCount.PROP_REF_NUMBER));
            Object maxNumber = criteria.uniqueResult();
            if (maxNumber == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)maxNumber) + 1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBy(String ref, Date from, Date to, Boolean showVerified) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((CharSequence)ref)) {
                criteria.add(Restrictions.ilike((String)StockCount.PROP_REF_NUMBER, (Object)ref));
            }
            if (from != null && to != null) {
                criteria.add((Criterion)Restrictions.ge((String)StockCount.PROP_CREATED_DATE, (Object)from));
                criteria.add((Criterion)Restrictions.le((String)StockCount.PROP_CREATED_DATE, (Object)to));
            }
            if (!showVerified.booleanValue()) {
                criteria.add(Restrictions.isNull((String)StockCount.PROP_VERIFIED_BY));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateStockCounts(List<StockCount> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (StockCount item : dataList) {
                List<StockCountItem> items = item.getCountItems();
                item.setCountItems(null);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                StockCountDAO dao = StockCountDAO.getInstance();
                StockCount existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    item.setVersion(version);
                } else {
                    this.save(item, session);
                }
                List<StockCountItem> existingItems = null;
                if (existingItem != null && existingItem.getCountItems() != null) {
                    existingItems = existingItem.getCountItems();
                }
                if (existingItems == null) {
                    existingItems = new ArrayList<StockCountItem>();
                }
                if (items != null && items.size() > 0) {
                    for (StockCountItem stockCountItem : items) {
                        stockCountItem.setStockCount(item);
                        int idx = existingItems.indexOf(stockCountItem);
                        StockCountItem existingStockCountItem = null;
                        if (idx != -1) {
                            existingStockCountItem = existingItems.get(idx);
                            if (existingStockCountItem == null) {
                                stockCountItem.setVersion(0L);
                                StockCountItemDAO.getInstance().save(stockCountItem, session);
                                continue;
                            }
                            stockCountItem.setVersion(existingStockCountItem.getVersion());
                            continue;
                        }
                        stockCountItem.setVersion(0L);
                        StockCountItemDAO.getInstance().save(stockCountItem, session);
                    }
                }
                item.setCountItems(items);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }
}

