/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.BaseTicketItemDAO;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.util.POSUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class TicketItemDAO
extends BaseTicketItemDAO {
    public boolean deleteTicketItemWithTicket(Integer itemID) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_MENU_ITEM_ID, (Object)itemID));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (TicketItem ticketItem : result) {
                ticketItem.setTicket(null);
                super.delete(ticketItem, session);
            }
            boolean bl = true;
            return bl;
        }
    }

    public Double getItemsCountWithinHour(Session session, Integer hourDuration) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date toDate = calendar.getTime();
            calendar.add(10, -(hourDuration == null ? 24 : hourDuration));
            Date fromDate = calendar.getTime();
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)fromDate, (Object)toDate));
            criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            AggregateProjection projection = Projections.sum((String)TicketItem.PROP_QUANTITY);
            projectionList.add((Projection)projection);
            criteria.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                return number.doubleValue();
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
        }
        return 0.0;
    }

    public List<TicketItem> findSoldItems(Date startDate, Date endDate, List<Integer> terminalIdList, List<String> groupIdList, List<String> orderTypeIdList, List<String> menuCategoryIdList, Boolean isInventoryItem, boolean sortByGroup) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias(TicketItem.PROP_TICKET, "t");
            criteria.add((Criterion)this.createVoidItemFilter());
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_INVENTORY_ITEM, (Object)isInventoryItem));
            criteria.add(Restrictions.between((String)("t." + Ticket.PROP_CREATE_DATE), (Object)startDate, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (menuCategoryIdList != null && !menuCategoryIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)TicketItem.PROP_CATEGORY_ID, menuCategoryIdList));
            }
            if (groupIdList != null && !groupIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)TicketItem.PROP_GROUP_ID, groupIdList));
            }
            if (terminalIdList != null && !terminalIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_TERMINAL_ID), terminalIdList));
            }
            if (orderTypeIdList != null && !orderTypeIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIdList));
            }
            criteria.addOrder(Order.asc((String)TicketItem.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    private LogicalExpression createVoidItemFilter() {
        SimpleExpression itemNotVoided = Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE);
        LogicalExpression returnedItem = Restrictions.and((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.TRUE), (Criterion)Restrictions.isNull((String)TicketItem.PROP_VOIDED_ITEM_ID));
        return Restrictions.or((Criterion)itemNotVoided, (Criterion)returnedItem);
    }

    @Deprecated
    public List<TicketItem> findTicketItemWithinDate(Date startDate, Date endDate, List<Terminal> terminals, List<String> groupIdList, List<String> orderTypeIdList, List<String> menuCategoryIdList, Boolean isInventoryItem) {
        List<Integer> terminalIdList = POSUtil.getIntegerIds(terminals, Terminal.class);
        return this.findSoldItems(startDate, endDate, terminalIdList, groupIdList, orderTypeIdList, menuCategoryIdList, isInventoryItem, true);
    }

    @Deprecated
    public List<TicketItemModifier> findTicketItemModifierWithinDate(Date startDate, Date endDate, List<String> orderTypeIdList, List<String> menuCategoryIdList, Boolean isInventoryItem) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(TicketItemModifier.class).createAlias(TicketItemModifier.PROP_TICKET_ITEM, "ticketItem").createAlias("ticketItem." + TicketItem.PROP_TICKET, "ticket");
            SimpleExpression itemNotVoided = Restrictions.eq((String)("ticketItem." + TicketItem.PROP_VOIDED), (Object)Boolean.FALSE);
            LogicalExpression returnedItem = Restrictions.and((Criterion)Restrictions.eq((String)("ticketItem." + TicketItem.PROP_VOIDED), (Object)Boolean.TRUE), (Criterion)Restrictions.isNull((String)("ticketItem." + TicketItem.PROP_VOIDED_ITEM_ID)));
            criteria.add((Criterion)Restrictions.or((Criterion)itemNotVoided, (Criterion)returnedItem));
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)startDate, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (isInventoryItem != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticketItem." + TicketItem.PROP_INVENTORY_ITEM), (Object)isInventoryItem));
            }
            if (!orderTypeIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIdList));
            }
            if (!menuCategoryIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticketItem." + TicketItem.PROP_CATEGORY_ID), menuCategoryIdList));
            }
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ID), TicketItemModifier.PROP_ID);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_ID), TicketItemModifier.PROP_ITEM_ID);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_NAME), TicketItemModifier.PROP_NAME);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_MODIFIER_TYPE), TicketItemModifier.PROP_MODIFIER_TYPE);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_UNIT_PRICE), TicketItemModifier.PROP_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_QUANTITY), TicketItemModifier.PROP_ITEM_QUANTITY);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_SERVICE_CHARGE), TicketItemModifier.PROP_SERVICE_CHARGE);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE), TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_DISCOUNT), TicketItemModifier.PROP_ADJUSTED_DISCOUNT);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_SUBTOTAL), TicketItemModifier.PROP_ADJUSTED_SUBTOTAL);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TOTAL), TicketItemModifier.PROP_ADJUSTED_TOTAL);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TAX), TicketItemModifier.PROP_ADJUSTED_TAX);
            pList.add((Projection)Projections.property((String)TicketItemModifier.PROP_TAX_INCLUDED), TicketItemModifier.PROP_TAX_INCLUDED);
            pList.add((Projection)Projections.property((String)("ticketItem." + TicketItem.PROP_QUANTITY)), "ticketItemQuantity");
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItemModifier.class));
            criteria.addOrder(Order.asc((String)TicketItemModifier.PROP_NAME));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<TicketItem> findTicketItemWithinDateForDashboard(Date startDate, Date endDate, Integer numberOfItems, Boolean sortAsc, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
        criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)startDate, (Object)endDate));
        criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), TicketItem.PROP_NAME);
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_QUANTITY), TicketItem.PROP_QUANTITY);
        criteria.setProjection((Projection)projectionList);
        criteria.setMaxResults(numberOfItems == null ? 20 : numberOfItems);
        criteria.setResultTransformer(Transformers.aliasToBean(TicketItem.class));
        if (sortAsc != null) {
            if (sortAsc.booleanValue()) {
                criteria.addOrder(Order.asc((String)TicketItem.PROP_QUANTITY));
            } else {
                criteria.addOrder(Order.desc((String)TicketItem.PROP_QUANTITY));
            }
        }
        return criteria.list();
    }

    @Deprecated
    public List<DeletedItem> findByDate(Date startDate, Date endDate, List<Integer> terminalIdList, List<String> orderTypeIdList) {
        try (Session session = this.createNewSession();){
            String as = " as ";
            String hql = "select vi." + VoidItem.PROP_MENU_ITEM_NAME + as + "name,vi." + VoidItem.PROP_QUANTITY + as + "quantity,vi." + VoidItem.PROP_VOID_DATE + as + "voidDate,vi." + VoidItem.PROP_TOTAL_PRICE + as + "total,t." + Ticket.PROP_ID + as + "ticketId,t." + Ticket.PROP_CREATE_DATE + as + "createDate,ot." + OrderType.PROP_NAME + as + "orderTypeName,ter." + Terminal.PROP_NAME + as + "terminalName,vi." + VoidItem.PROP_VOID_REASON + as + "voidReason,vi." + VoidItem.PROP_ITEM_WASTED + as + "itemWasted,concat (u." + User.PROP_FIRST_NAME + ",' ',u." + User.PROP_LAST_NAME + ")" + as + "voidUserName from VoidItem as vi left join Ticket as t on vi." + VoidItem.PROP_TICKET_ID + " = t." + Ticket.PROP_ID + " left join " + Terminal.REF + " as ter on t." + Ticket.PROP_TERMINAL_ID + " = ter." + Terminal.PROP_ID + " left join " + User.REF + " as u on vi." + VoidItem.PROP_VOID_BY_USER_ID + " = u." + User.PROP_ID + " left join " + OrderType.REF + " as ot on t." + Ticket.PROP_ORDER_TYPE_ID + " = ot." + OrderType.PROP_ID;
            hql = hql + " where vi." + VoidItem.PROP_VOID_DATE + " between :fromDate and :toDate";
            if (!terminalIdList.isEmpty()) {
                hql = hql + " and t." + Ticket.PROP_TERMINAL_ID + " in :terminalIds";
            }
            if (!orderTypeIdList.isEmpty()) {
                hql = hql + " and t." + Ticket.PROP_ORDER_TYPE_ID + " in :orderTypeIds";
            }
            Query query = session.createQuery(hql);
            query.setTimestamp("fromDate", startDate);
            query.setTimestamp("toDate", endDate);
            if (!terminalIdList.isEmpty()) {
                query.setParameterList("terminalIds", terminalIdList);
            }
            if (!orderTypeIdList.isEmpty()) {
                query.setParameterList("orderTypeIds", orderTypeIdList);
            }
            query.setResultTransformer(Transformers.aliasToBean(DeletedItem.class));
            List list = query.list();
            return list;
        }
    }

    public List<TicketItem> findItemsForVoidItemReport(Date startDate, Date endDate, List<Integer> terminalIdList, List<String> orderTypeIdList) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)true));
            criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_ITEM_RETURNED, (Object)false));
            criteria.add(Restrictions.between((String)TicketItem.PROP_VOID_DATE, (Object)startDate, (Object)endDate));
            if (!terminalIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_TERMINAL_ID), terminalIdList));
            }
            if (!orderTypeIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIdList));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<TicketItem> findItemsForReturnItemReport(Date startDate, Date endDate, List<Integer> terminalIdList, List<String> orderTypeIdList) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)true));
            criteria.add(Restrictions.between((String)TicketItem.PROP_VOID_DATE, (Object)startDate, (Object)endDate));
            if (!terminalIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_TERMINAL_ID), terminalIdList));
            }
            if (!orderTypeIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIdList));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }
}

