/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.BaseUserDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.UserNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class UserDAO
extends BaseUserDAO {
    public static final UserDAO instance = new UserDAO();

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        List<User> linkedUsers;
        User user = (User)obj;
        if (user == null) {
            throw new PosException(Messages.getString("UserDAO.1"));
        }
        user.setDeleted(true);
        if (user.isRoot().booleanValue() && (linkedUsers = user.getLinkedUser()) != null && !linkedUsers.isEmpty()) {
            for (User linkedUser : linkedUsers) {
                if (linkedUser.equals(user)) continue;
                this.delete(linkedUser, session);
            }
        }
        this.update(user, session);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String filterItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)filterItem)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getActiveUserCount() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public Map<PosTransaction, User> findTopSellers(Session session, Date fromDate, Date toDate, Integer maxResult) {
        HashMap<PosTransaction, User> userTransactionHashMap = new HashMap<PosTransaction, User>();
        TreeMap<PosTransaction, User> userTransactionTreeMap = new TreeMap<PosTransaction, User>(new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction transaction1, PosTransaction transaction2) {
                return transaction1.getAmount().compareTo(transaction2.getAmount());
            }
        });
        try {
            Criteria creditCriteria = session.createCriteria(PosTransaction.class);
            Criteria debitCriteria = session.createCriteria(PosTransaction.class);
            creditCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            debitCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            creditCriteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            creditCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            debitCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            ProjectionList projections = Projections.projectionList();
            projections.add((Projection)Projections.groupProperty((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projections.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            creditCriteria.setProjection((Projection)projections);
            debitCriteria.setProjection((Projection)projections);
            creditCriteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            debitCriteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            List creditTransactions = creditCriteria.list();
            List debitTransactions = debitCriteria.list();
            HashMap creditTransactionMap = new HashMap();
            HashMap debitTransactionMap = new HashMap();
            HashMap userMap = new HashMap();
            if (creditTransactions != null) {
                creditTransactions.forEach(transaction -> {
                    User user = this.get(transaction.getUserId(), session);
                    userMap.put(user.getId(), user);
                    creditTransactionMap.put(user, transaction);
                });
            }
            if (debitTransactions != null) {
                debitTransactions.forEach(transaction -> {
                    User user = (User)userMap.get(transaction.getUserId());
                    if (user == null) {
                        user = this.get(transaction.getUserId(), session);
                        userMap.put(user.getId(), user);
                    }
                    debitTransactionMap.put(user, transaction);
                });
            }
            ArrayList userEntries = new ArrayList(userMap.entrySet());
            userEntries.forEach(entry -> {
                User user = (User)entry.getValue();
                PosTransaction creditTransaction = (PosTransaction)creditTransactionMap.get(user);
                PosTransaction debitTransaction = (PosTransaction)debitTransactionMap.get(user);
                if (creditTransaction != null && debitTransaction != null) {
                    creditTransaction.setAmount(creditTransaction.getAmount() - debitTransaction.getAmount());
                } else if (creditTransaction == null) {
                    creditTransaction = debitTransaction;
                }
                userTransactionHashMap.put(creditTransaction, user);
            });
            userTransactionTreeMap.putAll(userTransactionHashMap);
            userTransactionHashMap.clear();
            ArrayList userTransactionEntries = new ArrayList(userTransactionTreeMap.entrySet());
            for (int i = 0; i < userTransactionEntries.size() && i < maxResult; ++i) {
                userTransactionHashMap.put((PosTransaction)((Map.Entry)userTransactionEntries.get(i)).getKey(), (User)((Map.Entry)userTransactionEntries.get(i)).getValue());
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
        }
        return userTransactionHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> loadUsers(PaginationSupport model, String filterItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)filterItem)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)filterItem, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getRandomUser() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true));
            criteria.setMaxResults(1);
            List users = criteria.list();
            if (users.size() > 0) {
                User user = (User)users.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    @Override
    public List<User> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
    }

    public List<User> findUsersForServerSummeryReport() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.isNotNull((String)User.PROP_USER_TYPE_ID));
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findClockedInUsers() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllActive() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)activeUserCriteria);
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findActiveUsersForPayroll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)activeUserCriteria);
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findDrivers() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_DRIVER, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public User findUser(String userId) {
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)userId));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Object result = criteria.uniqueResult();
            if (result != null) {
                User user = (User)result;
                return user;
            }
            try {
                throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), userId));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public User findUserByEmail(String userEmail) {
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)userEmail));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Object result = criteria.uniqueResult();
            if (result != null) {
                User user = (User)result;
                return user;
            }
            try {
                throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), userEmail));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserBySecretKey(String secretKey) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_PASSWORD, (Object)this.getEncrypedPassword(secretKey)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                User user = (User)list.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private String getEncrypedPassword(String secretKey) {
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                secretKey = AESencrp.encrypt((String)secretKey);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        return secretKey;
    }

    public boolean isUserExist(String userId) {
        try {
            User user = this.findUser(userId);
            return user != null;
        }
        catch (UserNotFoundException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findUserWithMaxId() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection((Projection)Projections.max((String)User.PROP_ID));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Integer n = (Integer)list.get(0);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getClockedInUser(Terminal terminal, boolean includeStaffBank) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)Boolean.TRUE));
            if (!includeStaffBank) {
                criteria.add((Criterion)Restrictions.eq((String)User.PROP_STAFF_BANK, (Object)Boolean.FALSE));
            }
            Junction activeUserCriteria = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)activeUserCriteria);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockIn(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK IN");
        actionHistory.setActionTime(attendenceHistory.getClockInTime());
        String actionMessage = String.format("User %s clocks in", user.getId());
        actionHistory.setDescription(actionMessage);
        actionHistory.setPerformer(user);
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            session.save((Object)actionHistory);
            tx.commit();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockOut(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK OUT");
        actionHistory.setActionTime(attendenceHistory.getClockOutTime());
        String actionMessage = String.format("User %s clocks out", user.getId());
        actionHistory.setDescription(actionMessage);
        actionHistory.setPerformer(user);
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            UserDAO.getInstance().saveOrUpdate(user, session);
            AttendenceHistoryDAO.getInstance().saveOrUpdate(attendenceHistory, session);
            ActionHistoryDAO.getInstance().save(actionHistory, session);
            tx.commit();
        }
        catch (StaleStateException e) {
            throw new PosException(Messages.getString("UserDAO.5") + Messages.getString("UserDAO.15"), e);
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverOut(User user, EmployeeInOutHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            tx.commit();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverIn(User user, EmployeeInOutHistory attendenceHistory, Shift shift, Calendar currentTime) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.3"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private boolean validate(User user, boolean editMode) throws PosException {
        String hql = "from User u where u." + User.PROP_ID + "=:userId";
        Session session = this.getSession();
        Query query = session.createQuery(hql);
        if ((query = query.setParameter("userId", (Object)user.getId())).list().size() > 0) {
            throw new PosException(Messages.getString("UserDAO.7"));
        }
        return true;
    }

    public void saveOrUpdate(User user, boolean editMode) {
        Session session = null;
        try {
            if (!editMode) {
                this.validate(user, editMode);
            }
            super.saveOrUpdate(user);
        }
        catch (Exception x) {
            throw new PosException(x.getMessage(), x);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int findNumberOfOpenTickets(User user) throws PosException {
        Session session = null;
        Transaction tx = null;
        String hql = "select count(*) from Ticket ticket where ticket.owner=:owner and ticket." + Ticket.PROP_CLOSED + "settled=false";
        int count = 0;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            Query query = session.createQuery(hql);
            query = query.setEntity("owner", (Object)user);
            Iterator iterator = query.iterate();
            if (iterator.hasNext()) {
                count = (Integer)iterator.next();
            }
            tx.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PosException(Messages.getString("UserDAO.12"), e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public boolean isClockedIn(User user) {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)user.getId()));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)User.PROP_CLOCKED_IN));
        ResultTransformer transformer = new ResultTransformer(){

            public Object transformTuple(Object[] row, String[] arg1) {
                return row[0];
            }

            public List transformList(List arg0) {
                return arg0;
            }
        };
        criteria.setProjection((Projection)projectionList).setResultTransformer(transformer);
        Boolean result = (Boolean)criteria.uniqueResult();
        return result == null ? Boolean.FALSE : result;
    }

    public User getRandomUser(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (User)list.get(0);
        }
        return null;
    }

    public void performForceCloseStaffBank(User staffBankOwner, User closedByUser, Session session) throws Exception {
        CashDrawer staffBank = staffBankOwner.getActiveDrawerPullReport();
        CashDrawerReportService reportService = new CashDrawerReportService(staffBank);
        reportService.populateReport(session);
        staffBank.setClosedBy(closedByUser);
        staffBank.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(staffBank, session);
        staffBankOwner.setStaffBankStarted(false);
        staffBankOwner.setCurrentCashDrawer(null);
        StringBuilder sb = new StringBuilder();
        sb.append(" Staff id: " + staffBankOwner.getId());
        sb.append(" Staff bank id: " + staffBank.getId());
        ActionHistoryDAO.saveHistory("Staff bank force close", sb.toString(), session);
    }

    public void doForceClockOutUser(User userToClockOut, User actionPerformer) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            if (!(actionPerformer.isManager() || actionPerformer.isAdministrator() || actionPerformer.hasPermission(UserPermission.OPEN_CLOSE_STORE))) {
                throw new PosException(Messages.getString("UserDAO.18"));
            }
            session = this.createNewSession();
            tx = session.beginTransaction();
            if (userToClockOut.isStaffBankStarted().booleanValue()) {
                this.performForceCloseStaffBank(userToClockOut, actionPerformer, session);
            }
            this.saveAttendenceHistory(userToClockOut, session);
            userToClockOut.setClockedIn(false);
            userToClockOut.setCurrentShift(null);
            userToClockOut.setLastClockInTime(null);
            userToClockOut.setLastClockOutTime(null);
            userToClockOut.setAvailableForDelivery(false);
            session.evict((Object)userToClockOut);
            this.update(userToClockOut, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    private void saveAttendenceHistory(User userToClockOut, Session session) {
        AttendenceHistory history = AttendenceHistoryDAO.getInstance().findHistoryByClockedInTime(userToClockOut, session);
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.setTime(StoreDAO.getServerTimestamp());
        if (history == null) {
            history = new AttendenceHistory();
            Date lastClockInTime = userToClockOut.getLastClockInTime();
            if (lastClockInTime != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockInTime);
                history.setClockInTime(lastClockInTime);
                history.setClockInHour((short)c.get(10));
            }
            history.setUser(userToClockOut);
            history.setTerminal(DataProvider.get().getCurrentTerminal());
            history.setShift(userToClockOut.getCurrentShift());
        }
        history.setClockedOut(true);
        history.setClockOutTime(StoreDAO.getServerTimestamp());
        history.setClockOutHour((short)currentCalendar.get(11));
        AttendenceHistoryDAO.getInstance().saveOrUpdate(history, session);
        StringBuilder sb = new StringBuilder();
        sb.append("Staff id: " + userToClockOut.getId());
        ActionHistoryDAO.saveHistory("Forced clock out", sb.toString(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsersPasswords() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true));
            criteria.setProjection((Projection)Projections.property((String)User.PROP_PASSWORD));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public User findUserById(String userId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)userId));
            Object result = criteria.uniqueResult();
            if (result != null) {
                User user = (User)result;
                return user;
            }
            throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), userId));
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void startStaffBank(User assignToUser) {
        Session session = null;
        Transaction tx = null;
        try {
            CashDrawer staffBankReport = new CashDrawer();
            staffBankReport.setStartTime(new Date());
            staffBankReport.setAssignedUser(assignToUser);
            staffBankReport.setTerminal(Application.getInstance().getTerminal());
            staffBankReport.setStoreSession(DataProvider.get().getStoreSession());
            staffBankReport.setDrawerType(DrawerType.STAFF_BANK);
            staffBankReport.setAssignedBy(assignToUser);
            session = this.createNewSession();
            tx = session.beginTransaction();
            CashDrawerDAO.getInstance().save(staffBankReport, session);
            assignToUser.setCurrentCashDrawer(staffBankReport);
            assignToUser.setStaffBankStarted(true);
            this.saveOrUpdate(assignToUser, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    @Deprecated
    public void saveOrUpdateAllUsers(List<User> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        ArrayList<User> parentUser = new ArrayList<User>();
        ArrayList<User> childUser = new ArrayList<User>();
        for (User user : dataList) {
            if (user.isRoot().booleanValue()) {
                parentUser.add(user);
                continue;
            }
            childUser.add(user);
        }
        this.saveOrUpdateUsers(parentUser, updateLastUpdateTime, updateSyncTime);
        this.saveOrUpdateUsers(childUser, updateLastUpdateTime, updateSyncTime);
    }

    private void saveOrUpdateUsers(List<User> users, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (users == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (User user : users) {
                User existingUser = this.get(user.getId());
                if (existingUser != null) {
                    CashDrawer sourceCashDrawer = StringUtils.isBlank((String)user.getCurrentCashDrawerId()) ? null : CashDrawerDAO.getInstance().get(user.getCurrentCashDrawerId());
                    CashDrawer existingCashDrawer = StringUtils.isBlank((String)existingUser.getCurrentCashDrawerId()) ? null : CashDrawerDAO.getInstance().get(existingUser.getCurrentCashDrawerId());
                    String id = existingUser.getId();
                    long version = existingUser.getVersion();
                    PropertyUtils.copyProperties((Object)existingUser, (Object)user);
                    existingUser.setId(id);
                    existingUser.setVersion(version);
                    existingUser.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingUser.setUpdateSyncTime(updateSyncTime);
                    if (sourceCashDrawer == null && existingCashDrawer != null && existingCashDrawer.getReportTime() == null) {
                        existingUser.setCurrentCashDrawerId(existingCashDrawer.getId());
                    }
                    if (sourceCashDrawer != null && existingCashDrawer != null && !sourceCashDrawer.getId().equals(existingCashDrawer.getId()) && existingCashDrawer.getStartTime().after(sourceCashDrawer.getStartTime())) {
                        existingUser.setCurrentCashDrawerId(existingCashDrawer.getId());
                    }
                    this.update(existingUser, session);
                    continue;
                }
                user.setUpdateLastUpdateTime(updateLastUpdateTime);
                user.setUpdateSyncTime(updateSyncTime);
                this.save(user, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getIdListForType(UserType userType, Session session) {
        Criteria userIdCrit = session.createCriteria(User.class);
        userIdCrit.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        userIdCrit.setProjection((Projection)Projections.property((String)User.PROP_ID));
        userIdCrit.add((Criterion)Restrictions.eq((String)User.PROP_USER_TYPE_ID, (Object)userType.getId()));
        return userIdCrit.list();
    }

    public List<User> findUsersExcept(String id) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ne((String)User.PROP_ID, (Object)id));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExist(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)email));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExistExceptUser(String email, User customer) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)email));
            criteria.add((Criterion)Restrictions.ne((String)User.PROP_ID, (Object)customer.getId()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

