/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.util.AESencrp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class GeneratePasswordUtil {
    public String createRandPass(String passWordLength) throws Exception {
        ArrayList<String> passList = new ArrayList<String>();
        List<String> passwords = UserDAO.getInstance().findUsersPasswords();
        Iterator<String> iterator = passwords.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (StringUtils.isEmpty((String)string)) {
                iterator.remove();
                continue;
            }
            String deCryptedPass = AESencrp.decrypt((String)string);
            passList.add(deCryptedPass);
        }
        String rawString = "1234567890";
        StringBuilder stringBuilder = new StringBuilder();
        String password = this.genPassword(rawString, stringBuilder, passWordLength);
        while (passList.contains(password)) {
            stringBuilder.setLength(0);
            password = this.genPassword(rawString, stringBuilder, passWordLength);
        }
        return password;
    }

    private String genPassword(String rawString, StringBuilder stringBuilder, String passWordLength) {
        Random rand = new Random();
        String password = "";
        if (passWordLength.length() == 0) {
            while (stringBuilder.length() < 4) {
                int index = (int)(rand.nextFloat() * (float)rawString.length());
                stringBuilder.append(rawString.charAt(index));
            }
            password = stringBuilder.toString();
        } else {
            while (stringBuilder.length() < Integer.parseInt(passWordLength)) {
                int index = (int)(rand.nextFloat() * (float)rawString.length());
                stringBuilder.append(rawString.charAt(index));
            }
            password = stringBuilder.toString();
        }
        return password;
    }

    public String createRandomCustomerId(int passWordLength) {
        String rawString = "1234567890";
        StringBuilder stringBuilder = new StringBuilder();
        String userId = this.genUserId(rawString, stringBuilder, passWordLength);
        while (UserDAO.getInstance().isUserExist(userId)) {
            stringBuilder.setLength(0);
            userId = this.genUserId(rawString, stringBuilder, passWordLength);
        }
        return userId;
    }

    private String genUserId(String rawString, StringBuilder stringBuilder, int passWordLength) {
        Random rand = new Random();
        String password = "";
        if (passWordLength == 0) {
            while (stringBuilder.length() < 5) {
                int index = (int)(rand.nextFloat() * (float)rawString.length());
                stringBuilder.append(rawString.charAt(index));
            }
            password = stringBuilder.toString();
        } else {
            while (stringBuilder.length() < passWordLength) {
                int index = Math.abs((int)(rand.nextDouble() * 10.0));
                if (stringBuilder.length() == 0 && index > 0) {
                    stringBuilder.append(index);
                    continue;
                }
                if (stringBuilder.length() <= 0) continue;
                stringBuilder.append(index);
            }
            password = stringBuilder.toString();
        }
        return password;
    }
}

