/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.Store;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.DottedLineSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ITextPrinter {
    private static final int FONT_SIZE = 9;
    private static final int KITCHEN_FONT_SIZE_16 = 16;
    private static final int KITCHEN_FONT_SIZE_14 = 14;
    private Font headerLine1Font = new Font(1, 11.0f, 1);
    private Font font_normal = new Font(1, 9.0f, 0);
    private Font font_bold = new Font(1, 9.0f, 1);
    private Font table_font = new Font(1, 9.0f, 0);
    private Document document = null;
    private PdfWriter pdfWriter;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(ReciptPaperSize paperSize, Map<String, Object> params, AbstractReportDataSource dataSource) throws Exception {
        try {
            this.renderFonts(dataSource);
            Document document = this.createDocument();
            int marginHorizontal = 19;
            int pageWidth = 228;
            int pageHeight = 600;
            int[] pointColumnWidths = new int[]{138, 50};
            int tableWidth = pointColumnWidths[0] + pointColumnWidths[1];
            Rectangle pagesize = new Rectangle((float)pageWidth, (float)pageHeight);
            document.setPageSize(pagesize);
            document.setMargins((float)marginHorizontal, (float)marginHorizontal, 0.0f, 0.0f);
            document.newPage();
            Paragraph br = new Paragraph(" ");
            document.add((Element)br);
            this.addText(params, "headerLine1", 1, this.headerLine1Font);
            this.addText(params, "ticketHeader", 1);
            this.addText(params, "additionalOrderInfo", 0);
            document.add((Element)this.getSep());
            PdfPTable table = this.createTable(2, tableWidth, pointColumnWidths);
            this.populateRows(dataSource, table);
            document.add((Element)table);
            document.add((Element)br);
            document.add((Element)this.getSep());
            if (dataSource instanceof TicketDataSource) {
                boolean showTipsSection;
                int[] summaryColumnWidths = new int[]{126, 66};
                PdfPTable summarySection = this.createTable(2, tableWidth, summaryColumnWidths);
                this.addSummaryCell(summarySection, params, "totalText", "grandSubtotal", false);
                this.addSummaryCell(summarySection, params, "discountText", "discountAmount");
                boolean isShowTaxBreakdown = Boolean.parseBoolean(String.valueOf(params.get("isShowTaxBreakdown")));
                if (!isShowTaxBreakdown) {
                    this.addSummaryCell(summarySection, params, "taxText", "taxAmount");
                } else {
                    document.add((Element)summarySection);
                    this.addText(params, "taxBreakdownText", 2, null, false);
                    summarySection = this.createTable(2, tableWidth, summaryColumnWidths);
                }
                this.addSummaryCell(summarySection, params, "serviceChargeText", "serviceCharge");
                this.addSummaryCell(summarySection, params, "deliveryChargeText", "deliveryCharge");
                summarySection.setSpacingAfter(5.0f);
                document.add((Element)summarySection);
                document.add((Element)this.getSep());
                summarySection = this.createTable(2, tableWidth, summaryColumnWidths);
                this.addSummaryCell(summarySection, params, "netAmountText", "netAmount", false);
                this.addSummaryCell(summarySection, params, "paidAmountText", "paidAmount", false);
                this.addSummaryCell(summarySection, params, "refundAmountText", "refundAmount");
                this.addSummaryCell(summarySection, params, "tenderAmountText", "tenderAmount");
                this.addSummaryCell(summarySection, params, "dueAmountText", "dueAmount", false);
                if (params.get("tenderAmount") != null) {
                    this.addSummaryCell(summarySection, params, "changeAmountText", "changedAmount", false);
                }
                this.addSummaryCell(summarySection, params, "tipsText", "tipAmount");
                document.add((Element)summarySection);
                this.addText(params, "showTips", 1);
                summarySection = this.createTable(2, tableWidth, summaryColumnWidths);
                this.addSummaryCell(summarySection, params, "feeAmountText", "feeAmount");
                document.add((Element)summarySection);
                this.addText(params, "additionalPaymentProperties", 2);
                this.addText(params, "additionalProperties", 2);
                boolean cardPayment = Boolean.parseBoolean(String.valueOf(params.get("cardPayment")));
                boolean bl = showTipsSection = cardPayment && Boolean.parseBoolean(String.valueOf(params.get("showTipsBlock")));
                if (showTipsSection) {
                    summarySection = this.createTable(2, tableWidth, summaryColumnWidths);
                    summarySection.setWidthPercentage(80.0f);
                    summarySection.setHorizontalAlignment(2);
                    this.addTextWithUnderline(summarySection, Messages.getString("EscPosPrintService.4"));
                    this.addTextWithUnderline(summarySection, Messages.getString("EscPosPrintService.5"));
                    this.addTextWithUnderline(summarySection, Messages.getString("EscPosPrintService.6"));
                    document.add((Element)summarySection);
                }
                if (cardPayment) {
                    this.addText(params, "approvalCode", 0);
                }
                this.addText(params, "bottomMessage", 0);
                document.add((Element)br);
                this.addText(params, "copyType", 1);
                this.addText(params, "footerMessage", 1);
            } else {
                this.addText(params, "printerName", 0);
                this.addText(params, "bottomMessage", 0);
                document.add((Element)br);
                this.addText(params, "footerMessage", 1);
            }
        }
        finally {
            this.closeDocument();
        }
    }

    private void renderFonts(AbstractReportDataSource dataSource) {
        if (dataSource instanceof KitchenTicketDataSource) {
            this.headerLine1Font.setSize(14.0f);
            this.font_bold.setSize(14.0f);
            this.font_normal.setSize(14.0f);
            this.table_font.setSize(16.0f);
        } else {
            this.headerLine1Font.setSize(9.0f);
            this.font_bold.setSize(9.0f);
            this.font_normal.setSize(9.0f);
            this.table_font.setSize(9.0f);
        }
    }

    private void populateRows(AbstractReportDataSource dataSource, PdfPTable table) {
        Store store = DataProvider.get().getStore();
        List rows = dataSource.getRows();
        if (rows != null) {
            if (dataSource instanceof TicketDataSource) {
                TicketDataSource ticketDataSource = (TicketDataSource)dataSource;
                for (ITicketItem item : rows) {
                    String color = ticketDataSource.getColorCode(store, item);
                    this.table_font.setColor(ITextPrinter.decodeHtmlColorString(color));
                    PdfPCell nameCell = this.getCell(item.getNameDisplay(), 0);
                    PdfPCell subtotalCell = this.getCell(item.getSubTotalAmountDisplay(), 2);
                    table.addCell(nameCell);
                    table.addCell(subtotalCell);
                }
            } else if (dataSource instanceof KitchenTicketDataSource) {
                KitchenTicketDataSource kitchenTicketDataSource = (KitchenTicketDataSource)dataSource;
                for (KitchenTicketItem item : rows) {
                    String color = kitchenTicketDataSource.getColorCode(item, item.getKitchenTicket().getOrderTypeId());
                    this.table_font.setColor(ITextPrinter.decodeHtmlColorString(color));
                    PdfPCell cell = this.getCell(item.getMenuItemNameDisplay(), 0);
                    cell.setColspan(2);
                    table.addCell(cell);
                }
            }
        }
        this.table_font.setColor(Color.black);
    }

    public static Color decodeHtmlColorString(String colorString) {
        Color color;
        if (StringUtils.isEmpty((String)colorString)) {
            return Color.BLACK;
        }
        if (colorString.startsWith("#")) {
            colorString = colorString.substring(1);
        }
        if (colorString.endsWith(";")) {
            colorString = colorString.substring(0, colorString.length() - 1);
        }
        switch (colorString.length()) {
            case 6: {
                int red = Integer.parseInt(colorString.substring(0, 2), 16);
                int green = Integer.parseInt(colorString.substring(2, 4), 16);
                int blue = Integer.parseInt(colorString.substring(4, 6), 16);
                color = new Color(red, green, blue);
                break;
            }
            case 3: {
                int red = Integer.parseInt(colorString.substring(0, 1), 16);
                int green = Integer.parseInt(colorString.substring(1, 2), 16);
                int blue = Integer.parseInt(colorString.substring(2, 3), 16);
                color = new Color(red, green, blue);
                break;
            }
            case 1: {
                int blue;
                int green = blue = Integer.parseInt(colorString.substring(0, 1), 16);
                int red = blue;
                color = new Color(red, green, blue);
                break;
            }
            default: {
                return Color.BLACK;
            }
        }
        return color;
    }

    private PdfPTable createTable(int col, int tableWidth, int[] summaryColumnWidths) throws DocumentException {
        PdfPTable summarySection = new PdfPTable(col);
        summarySection.setHorizontalAlignment(1);
        summarySection.setWidths(summaryColumnWidths);
        summarySection.setKeepTogether(true);
        summarySection.setTotalWidth((float)tableWidth);
        summarySection.setWidthPercentage(100.0f);
        return summarySection;
    }

    private Image getBarcode(Map<String, Object> parameters) throws DocumentException {
        Object barcode = parameters.get(ReceiptParam.BARCODE.getParamName());
        if (barcode != null) {
            PdfContentByte cb = this.getPdfWriter().getDirectContent();
            Barcode128 code128 = new Barcode128();
            code128.setBaseline(-1.0f);
            code128.setSize(12.0f);
            code128.setFont(this.font_normal.getBaseFont());
            code128.setCode(String.valueOf(barcode));
            code128.setCodeType(9);
            code128.setBarHeight(20.0f);
            code128.setX(1.0f);
            code128.setTextAlignment(1);
            Image code128Image = code128.createImageWithBarcode(cb, null, null);
            code128Image.setAlignment(1);
            code128Image.setSpacingBefore(1.0f);
            code128Image.setSpacingAfter(1.0f);
            code128Image.setWidthPercentage(90.0f);
            return code128Image;
        }
        return null;
    }

    private Image getImage(Map<String, Object> parameters, int maxWidth) throws BadElementException, MalformedURLException, IOException, DocumentException {
        java.awt.Image orinImage = (java.awt.Image)parameters.get("storeLogoIcon");
        if (orinImage != null) {
            Image image = Image.getInstance((java.awt.Image)POSUtil.convertBlackAndWhiteImage(orinImage), null);
            image.setAlignment(1);
            float width = image.getWidth();
            float height = image.getHeight();
            if (width > (float)maxWidth) {
                height = height * (float)maxWidth / width;
                width = maxWidth;
            }
            image.scaleToFit(width, height);
            return image;
        }
        return null;
    }

    public PdfWriter getPdfWriter() {
        return this.pdfWriter;
    }

    private void addSummaryCell(PdfPTable table, Map<String, Object> parameters, String labelKey, String valueKey) {
        this.addSummaryCell(table, parameters, labelKey, valueKey, true);
    }

    private void addSummaryCell(PdfPTable table, Map<String, Object> parameters, String labelKey, String valueKey, boolean removeNullOrBlank) {
        Object value = parameters.get(valueKey);
        if (removeNullOrBlank && (value == null || value.equals("null") || value.equals("0.00"))) {
            return;
        }
        table.addCell(this.getCell(String.valueOf(parameters.get(labelKey)), 2));
        table.addCell(this.getCell(String.valueOf(value), 2));
    }

    private PdfPCell getCell(String text, int align) {
        Font font = new Font(this.table_font);
        PdfPCell c1 = new PdfPCell(new Phrase(text, font));
        c1.setHorizontalAlignment(align);
        c1.setBorder(0);
        return c1;
    }

    private DottedLineSeparator getSep() {
        return this.getSep(2.0f, 2.0f);
    }

    private DottedLineSeparator getSep(float offset, float gap) {
        DottedLineSeparator sep = new DottedLineSeparator();
        sep.setAlignment(1);
        sep.setOffset(offset);
        sep.setGap(gap);
        return sep;
    }

    public Document createDocument() throws Exception {
        this.document = new Document();
        this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
        this.document.open();
        return this.document;
    }

    public void closeDocument() {
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
    }

    public void rendererReport(JPanel reportPanel) throws Exception {
        PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(this.getPrintableByteArray()));
        MigLayout layout = new MigLayout("fill,hidemode 3,wrap 1,ins 0", "", "[]0px[]");
        JPanel pagePanel = new JPanel((LayoutManager)layout);
        pagePanel.setBackground(Color.WHITE);
        float scale = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f;
        for (int i = 0; i < document.getNumberOfPages(); ++i) {
            BufferedImage croppedImage = this.crop(new PDFRenderer(document).renderImage(i, scale), i + 1 == document.getNumberOfPages() ? 20 : 0);
            if (croppedImage == null) continue;
            pagePanel.add((Component)new JLabel(new ImageIcon(croppedImage)), "gap 0");
        }
        reportPanel.add(pagePanel);
    }

    public BufferedImage crop(BufferedImage bi, int bottomMergin) {
        int w = bi.getWidth();
        int trimHeight = this.getTrimmedHeight(bi);
        BufferedImage newImg = new BufferedImage(w, trimHeight + bottomMergin, 1);
        Graphics2D g = newImg.createGraphics();
        g.drawImage((java.awt.Image)bi, 0, 0, null);
        return newImg;
    }

    private int getTrimmedHeight(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int trimmedHeight = 0;
        block0: for (int i = 0; i < width; ++i) {
            for (int j = height - 1; j >= 0; --j) {
                if (img.getRGB(i, j) == Color.WHITE.getRGB() || j <= trimmedHeight) continue;
                trimmedHeight = j;
                continue block0;
            }
        }
        return trimmedHeight;
    }

    public boolean allWhiteRow(int row, BufferedImage bi, int w) {
        for (int i = 0; i < w; ++i) {
            if (bi.getRGB(i, row) != 255) continue;
            return true;
        }
        return false;
    }

    public boolean allWhiteColumn(int col, BufferedImage bi, int h) {
        for (int i = 0; i < h; ++i) {
            if (bi.getRGB(i, col) != 255) continue;
            return true;
        }
        return false;
    }

    public byte[] getPrintableByteArray() {
        return this.os.toByteArray();
    }

    public void addText(Map<String, Object> parameters, String key, int align) throws Exception {
        this.addText(parameters, key, align, null);
    }

    public Document getDocument() {
        return this.document;
    }

    public void addText(Map<String, Object> parameters, String key, int align, Font font) throws Exception {
        this.addText(parameters, key, align, font, true);
    }

    public void addText(Map<String, Object> parameters, String key, int align, Font font, boolean addNewLine) throws Exception {
        Document doc = this.getDocument();
        String text = String.valueOf(parameters.get(key));
        if (StringUtils.isEmpty((String)text) || text.equals("null")) {
            return;
        }
        boolean html = false;
        if (text.contains("<div>")) {
            text = text.replaceAll("<div>", "").replaceAll("</div>", "<br>").replaceAll("&nbsp;", " ");
            html = true;
        }
        PdfPTable table = new PdfPTable(1);
        table.setHorizontalAlignment(1);
        table.setWidthPercentage(100.0f);
        String[] splitTexts = text.split("<br>");
        if (splitTexts.length > 0) {
            for (int i = 0; i < splitTexts.length; ++i) {
                Image logo;
                String displayText;
                String p = splitTexts[i];
                if (p.contains("<b>")) {
                    font = this.font_bold;
                }
                if (font == null) {
                    font = this.font_normal;
                }
                if (StringUtils.isEmpty((String)(displayText = p.replaceAll("<.*?>", "").replaceAll("</", "").replaceAll("&nbsp;", " ")))) continue;
                if (html) {
                    displayText = displayText.replaceAll("\n", "");
                }
                if (p.contains("<strike>")) {
                    displayText = Messages.getString("EscPosPrintService.25") + " " + displayText;
                }
                PdfPCell c1 = new PdfPCell(new Phrase(displayText, font));
                c1.setHorizontalAlignment(align);
                c1.setBorder(0);
                table.addCell(c1);
                if (p.contains("<barcode>")) {
                    Image barcodeImage = this.getBarcode(parameters);
                    if (barcodeImage != null) {
                        c1 = new PdfPCell(barcodeImage);
                        c1.setHorizontalAlignment(align);
                        c1.setBorder(0);
                        table.addCell(c1);
                    }
                } else if (p.contains("<storeLogo>") && (logo = this.getImage(parameters, 200)) != null) {
                    c1 = new PdfPCell(logo);
                    c1.setHorizontalAlignment(align);
                    c1.setBorder(0);
                    table.addCell(c1);
                }
                if (!p.contains("</b>")) continue;
                font = this.font_normal;
            }
        }
        if (addNewLine) {
            PdfPCell c1 = new PdfPCell(new Phrase(Chunk.NEWLINE));
            c1.setBorder(0);
            table.addCell(c1);
        }
        doc.add((Element)table);
    }

    private Chunk getStrikeThroughText(String text, Font font) {
        Chunk chunk = new Chunk(text, font);
        chunk.setUnderline(0.5f, 3.0f);
        return chunk;
    }

    public void addTextWithUnderline(PdfPTable summarySection, String text) throws DocumentException {
        PdfPCell cell2 = this.getCell("          ", 0);
        PdfPCell cell = this.getCell(text, 0);
        cell.setColspan(2);
        cell.setBorder(2);
        summarySection.addCell(cell);
        summarySection.addCell(cell2);
        summarySection.addCell(cell2);
    }

    public void addLine(Document document, int number) throws DocumentException {
        for (int i = 0; i < number; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    public static ITextPrinter create() {
        return new ITextPrinter();
    }
}

