/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.User;
import java.util.Date;

public class AttendanceReportData {
    User user;
    Date date;
    Date from;
    Date to;
    double totalHour;
    double overtime;
    double rate;
    double overtimeRate;
    double regularPayment;
    double overtimePayment;
    double totalPayment;
    Date fromDateOfWeek;
    Date toDateOfWeek;
    double totalDeclaredTips;
    double totalNoCashTips;
    int firstDayOfWeek;
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public double getTotalHour() {
        return this.totalHour;
    }

    public void setTotalHour(double totalHour) {
        this.totalHour = totalHour;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getTotalPayment() {
        return this.totalPayment;
    }

    public void setTotalPayment(double payment) {
        this.totalPayment = payment;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void calculate() {
        long fromTime = this.from.getTime();
        long toTime = this.to.getTime();
        long milliseconds = toTime - fromTime;
        if (milliseconds < 0L) {
            this.totalHour = 0.0;
            return;
        }
        double seconds = (double)milliseconds / 1000.0;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        double diff = toTime - fromTime;
        diff /= 8.64E7;
        this.totalHour = hours;
        this.rate = this.user.getCostPerHour();
        this.totalPayment = this.totalHour * this.rate;
    }

    public void calculateTotalHour() {
        long fromTime = this.from.getTime();
        long toTime = this.to.getTime();
        long milliseconds = toTime - fromTime;
        long totalWorkHour = milliseconds / 3600000L;
        long regularWHInms = 144000000L;
        long overTimeWHms = milliseconds - regularWHInms;
        if (milliseconds < 0L) {
            this.totalHour = 0.0;
            return;
        }
        double seconds = (double)milliseconds / 1000.0;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        double diff = toTime - fromTime;
        diff /= 8.64E7;
        this.totalHour += hours;
        this.overtime = this.totalHour > 40.0 ? this.totalHour - 40.0 : 0.0;
        this.rate = this.user.getCostPerHour();
        this.overtimeRate = this.user.getOvertimeRatePerHour();
        this.regularPayment = (this.totalHour - this.overtime) * this.rate;
        this.overtimePayment = this.overtime * this.overtimeRate;
        this.totalPayment = this.regularPayment + this.overtimePayment;
    }

    public Date getFromDateOfWeek() {
        return this.fromDateOfWeek;
    }

    public void setFromDateOfWeek(Date fromDateOfWeek) {
        this.fromDateOfWeek = fromDateOfWeek;
    }

    public Date getToDateOfWeek() {
        return this.toDateOfWeek;
    }

    public void setToDateOfWeek(Date toDateOfWeek) {
        this.toDateOfWeek = toDateOfWeek;
    }

    public double getOvertime() {
        return this.overtime;
    }

    public void setOvertime(double overtime) {
        this.overtime = overtime;
    }

    public double getOvertimeRate() {
        return this.overtimeRate;
    }

    public void setOvertimeRate(double overtimeRate) {
        this.overtimeRate = overtimeRate;
    }

    public double getRegularPayment() {
        return this.regularPayment;
    }

    public void setRegularPayment(double regularPayment) {
        this.regularPayment = regularPayment;
    }

    public double getOvertimePayment() {
        return this.overtimePayment;
    }

    public void setOvertimePayment(double overtimePayment) {
        this.overtimePayment = overtimePayment;
    }

    public double getTotalDeclaredTips() {
        return this.totalDeclaredTips;
    }

    public void setTotalDeclaredTips(double totalDeclaredTips) {
        this.totalDeclaredTips = totalDeclaredTips;
    }

    public double getTotalNoCashTips() {
        return this.totalNoCashTips;
    }

    public void setTotalNoCashTips(double totalNoCashTips) {
        this.totalNoCashTips = totalNoCashTips;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }
}

