/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.AttendanceReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.RoledUser;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.beanutils.PropertyUtils;
import org.jdesktop.swingx.JXDatePicker;

public class AttendanceReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private MultiSelectComboBox<RoledUser> cbUserType;

    public AttendanceReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttendanceReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        List<User> users = UserDAO.getInstance().findAll();
        ArrayList<RoledUser> list = new ArrayList<RoledUser>();
        for (User user : users) {
            RoledUser roledUser = new RoledUser();
            try {
                PropertyUtils.copyProperties((Object)roledUser, (Object)user);
                list.add(roledUser);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        this.cbUserType = new MultiSelectionOverflowCombobox<RoledUser>();
        this.cbUserType.setItems(list);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"MMM dd, yyyy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"MMM dd, yyyy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.USER + ":"));
        topPanel.add(this.cbUserType);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        List<RoledUser> list = this.cbUserType.getSelectedItems();
        ArrayList<User> users = new ArrayList<User>();
        if (list != null) {
            for (RoledUser roledUser : list) {
                users.add(roledUser);
            }
        }
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List<AttendanceReportData> attendanceReportData = dao.findAttendance(fromDate, toDate, users);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("EmployeeAttendanceReport"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties, true);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        AttendanceReportModel reportModel = new AttendanceReportModel();
        Collections.sort(attendanceReportData, new Comparator<AttendanceReportData>(){

            @Override
            public int compare(AttendanceReportData o1, AttendanceReportData o2) {
                if (o1.getUser().getParentUserId() == null || o2.getUser().getParentUserId() == null) {
                    return 0;
                }
                return o1.getUser().getParentUserId().compareTo(o2.getUser().getParentUserId());
            }
        });
        reportModel.setRows(attendanceReportData);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("RTitle", Messages.getString("EmployeeAttendanceAction.1"));
        map.put("colEID", Messages.getString("EmployeeId") + ":");
        map.put("colEName", Messages.getString("EmployeeName") + ":");
        map.put("colCIn", Messages.getString("PayrollReportView.2"));
        map.put("colCOut", Messages.getString("PayrollReportView.3"));
        map.put("colWHour", Messages.getString("WorkHour"));
        map.put("colRole", Messages.getString("colRole") + ":");
        map.put("rowTotal", POSConstants.TOTAL + ":");
        map.put("rowGrandTotal", POSConstants.GRAND_TOTAL);
    }
}

