/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Discount;
import com.floreantpos.model.Printer;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PrintServiceUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;

public class DiscountReport {
    public static JasperPrint createPrint() {
        JasperPrint jasperPrint = null;
        try {
            List<Discount> discountList = DiscountDAO.getInstance().findAll();
            DiscountReportModel model = new DiscountReportModel();
            model.setRows(discountList);
            HashMap<String, Date> map = new HashMap<String, Date>();
            ReportUtil.populateRestaurantProperties(map);
            map.put("reportDate", new Date());
            JasperReport report = ReportUtil.getReport("DiscountReport");
            jasperPrint = JasperFillManager.fillReport((JasperReport)report, map, (JRDataSource)new JRTableModelDataSource((TableModel)model));
        }
        catch (JRException e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
        return jasperPrint;
    }

    public static void print() {
        try {
            List<Printer> reportPrinters = DataProvider.get().getPrinters().getReportPrinters();
            for (Printer printer : reportPrinters) {
                JasperPrint jasperPrint = DiscountReport.createPrint();
                jasperPrint.setProperty("printerName", printer.getDeviceName());
                DiscountReport.printQuitely(jasperPrint);
            }
        }
        catch (JRException e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        try {
            JRPrintServiceExporter exporter = new JRPrintServiceExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty("printerName")));
            exporter.exportReport();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static class DiscountReportModel
    extends ListTableModel {
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd, MMM yyyy, hh:mm a");
        DecimalFormat decimalFormat = new DecimalFormat("0.00");

        public DiscountReportModel() {
            super(new String[]{"name", "type", "active", "sdate", "edate", "value"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Discount data = (Discount)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getName();
                }
                case 1: {
                    return Discount.COUPON_TYPE_NAMES[data.getType()];
                }
                case 2: {
                    return data.isEnabled() != false ? "Active" : "Inactive";
                }
                case 3: {
                    if (data.getStartDate() == null) break;
                    return String.valueOf(this.dateFormat2.format(data.getStartDate()));
                }
                case 4: {
                    if (data.getExpiryDate() == null) break;
                    return String.valueOf(this.dateFormat2.format(data.getExpiryDate()));
                }
                case 5: {
                    return String.valueOf(data.getValue());
                }
            }
            return null;
        }
    }
}

