/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class SalesStatistics {
    private int capacity;
    private int guestCount;
    private double guestPerSeat;
    private double tableTurnOver;
    private double avgGuest;
    private int openChecks;
    private int voidChecks;
    private double laborCount;
    private double laborHour;
    private double laborCost;
    private double laborSale;
    private int tableCount;
    private int checkCount;
    private double guestPerCheck;
    private double avgCheck;
    private double openAmount;
    private double voidAmount;
    private double closedChecks;
    private double grossSales;
    private double discount;
    private double tax;
    private double netSales;
    private ArrayList<ShiftwiseSalesTableData> salesTableDataList;

    public void calculateOthers() {
        this.netSales = this.grossSales - this.discount;
        if (this.tableCount > 0) {
            this.tableTurnOver = (double)this.checkCount / (double)this.tableCount;
        }
        if (this.guestCount > 0) {
            this.avgGuest = this.netSales / (double)this.guestCount;
        }
        if (this.capacity > 0) {
            this.guestPerSeat = (double)this.guestCount / (double)this.capacity;
        }
        if (this.checkCount > 0) {
            this.guestPerCheck = (double)this.guestCount / (double)this.checkCount;
            this.avgCheck = this.netSales / (double)this.checkCount;
        }
    }

    public double getNetSales() {
        return this.netSales;
    }

    public void setNetSales(double netSale) {
        this.netSales = netSale;
    }

    public double getAvgGuest() {
        return this.avgGuest;
    }

    public void setAvgGuest(double averageGuest) {
        this.avgGuest = averageGuest;
    }

    public double getAvgCheck() {
        return this.avgCheck;
    }

    public void setAvgCheck(double avgChecks) {
        this.avgCheck = avgChecks;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCheckCount() {
        return this.checkCount;
    }

    public void setCheckCount(int checkCount) {
        this.checkCount = checkCount;
    }

    public int getGuestCount() {
        return this.guestCount;
    }

    public void setGuestCount(int guestCount) {
        this.guestCount = guestCount;
    }

    public double getGuestPerCheck() {
        return this.guestPerCheck;
    }

    public void setGuestPerCheck(double guestPerCheck) {
        this.guestPerCheck = guestPerCheck;
    }

    public double getGuestPerSeat() {
        return this.guestPerSeat;
    }

    public void setGuestPerSeat(double guestPerSeat) {
        this.guestPerSeat = guestPerSeat;
    }

    public double getLaborCount() {
        return this.laborCount;
    }

    public void setLaborCount(double labor) {
        this.laborCount = labor;
    }

    public double getLaborCost() {
        return this.laborCost;
    }

    public void setLaborCost(double laborCost) {
        this.laborCost = laborCost;
    }

    public double getLaborHour() {
        return this.laborHour;
    }

    public void setLaborHour(double laborHours) {
        this.laborHour = laborHours;
    }

    public double getLaborSale() {
        return this.laborSale;
    }

    public void setLaborSale(double laborSales) {
        this.laborSale = laborSales;
    }

    public double getOpenAmount() {
        return this.openAmount;
    }

    public void setOpenAmount(double openAmount) {
        this.openAmount = openAmount;
    }

    public int getOpenChecks() {
        return this.openChecks;
    }

    public void setOpenChecks(int openChecks) {
        this.openChecks = openChecks;
    }

    public double getClosedChecks() {
        return this.closedChecks;
    }

    public void setClosedChecks(double paidChecks) {
        this.closedChecks = paidChecks;
    }

    public int getTableCount() {
        return this.tableCount;
    }

    public void setTableCount(int tables) {
        this.tableCount = tables;
    }

    public double getTableTurnOver() {
        return this.tableTurnOver;
    }

    public void setTableTurnOver(double tableTurnOver) {
        this.tableTurnOver = tableTurnOver;
    }

    public double getVoidAmount() {
        return this.voidAmount;
    }

    public void setVoidAmount(double voidAmount) {
        this.voidAmount = voidAmount;
    }

    public int getVoidChecks() {
        return this.voidChecks;
    }

    public void setVoidChecks(int voidChecks) {
        this.voidChecks = voidChecks;
    }

    public ArrayList<ShiftwiseSalesTableData> getSalesTableDataList() {
        return this.salesTableDataList;
    }

    public void addSalesTableData(ShiftwiseSalesTableData data) {
        if (this.salesTableDataList == null) {
            this.salesTableDataList = new ArrayList();
        }
        if (NumberUtil.isZero(data.getGrossSales())) {
            return;
        }
        this.salesTableDataList.add(data);
    }

    public double getGrossSales() {
        return this.grossSales;
    }

    public void setGrossSales(double grossSale) {
        this.grossSales = grossSale;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double totalDiscount) {
        this.discount = totalDiscount;
    }

    public double getTax() {
        return this.tax;
    }

    public void setTax(double totalTax) {
        this.tax = totalTax;
    }

    public static class ShiftwiseDataTableModel
    extends ListTableModel {
        public ShiftwiseDataTableModel(List<ShiftwiseSalesTableData> list) {
            super(new String[]{"DayPart", "profitCenter", "Check", "Guest", "SalesAmount", "AvgChk", "AvgGst", "Percentage"}, list);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ShiftwiseSalesTableData data = (ShiftwiseSalesTableData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getShiftName();
                }
                case 1: {
                    return data.getOrderType();
                }
                case 2: {
                    return data.getCheckCount();
                }
                case 3: {
                    return data.getGuestCount();
                }
                case 4: {
                    return data.getNetSales();
                }
                case 5: {
                    return NumberUtil.formatNumber(data.getAvgChecks());
                }
                case 6: {
                    return NumberUtil.formatNumber(data.getAvgGuests());
                }
                case 7: {
                    if (Double.isNaN(data.getPercentage())) {
                        return NumberUtil.formatNumber(0.0);
                    }
                    return NumberUtil.formatNumber(data.getPercentage());
                }
            }
            return null;
        }
    }

    public static class ShiftwiseSalesTableData {
        private String shiftName;
        private String orderType;
        private int checkCount;
        private int guestCount;
        private double grossSales;
        private double discount;
        private double netSales;
        private double avgChecks;
        private double avgGuests;
        private double percentage;

        public double getAvgChecks() {
            return this.avgChecks;
        }

        public void setAvgChecks(double avgChecks) {
            this.avgChecks = avgChecks;
        }

        public double getAvgGuests() {
            return this.avgGuests;
        }

        public void setAvgGuests(double avgGuests) {
            this.avgGuests = avgGuests;
        }

        public int getCheckCount() {
            return this.checkCount;
        }

        public void setCheckCount(int checkCount) {
            this.checkCount = checkCount;
        }

        public int getGuestCount() {
            return this.guestCount;
        }

        public void setGuestCount(int guestCount) {
            this.guestCount = guestCount;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public void setPercentage(double percentage) {
            this.percentage = percentage;
        }

        public String getShiftName() {
            return this.shiftName;
        }

        public void setShiftName(String shiftName) {
            this.shiftName = shiftName;
        }

        public double getGrossSales() {
            return this.grossSales;
        }

        public void setGrossSales(double totalSales) {
            this.grossSales = totalSales;
        }

        public void calculateOthers() {
            this.netSales = this.grossSales - this.discount;
            if (this.netSales > 0.0 && this.checkCount > 0) {
                this.avgChecks = this.netSales / (double)this.checkCount;
            }
            if (this.netSales > 0.0 && this.guestCount > 0) {
                this.avgGuests = this.netSales / (double)this.guestCount;
            }
        }

        public String getOrderType() {
            return this.orderType;
        }

        public void setOrderType(String profitCenter) {
            this.orderType = profitCenter;
        }

        public double getDiscount() {
            return this.discount;
        }

        public void setDiscount(double discount) {
            this.discount = discount;
        }

        public double getNetSales() {
            return this.netSales;
        }

        public void setNetSales(double netSales) {
            this.netSales = netSales;
        }
    }
}

