/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.User;
import java.util.Date;

public class WeeklyPayrollReportData {
    private User user;
    private long totalWorkHourMs;
    private double regularWorkHour;
    private double overtimeHour;
    private double costPerHour;
    private double overtimeRatePerHour;
    private double regularPayment;
    private double overtimePayment;
    private double totalPayment;
    private Date fromDateOfWeek;
    private Date toDateOfWeek;
    private double totalDeclaredTips;
    private double totalNoCashTips;
    private int firstDayOfWeek;
    private String regularHourDisplay;
    private String overtimeDisplay;
    private String totalHourDisplay;

    public void calculateTotalHour() {
        double totalWorkHour = (double)this.totalWorkHourMs / 3600000.0;
        this.regularWorkHour = totalWorkHour < 40.0 ? totalWorkHour : 40.0;
        this.overtimeHour = totalWorkHour > 40.0 ? totalWorkHour - 40.0 : 0.0;
        this.costPerHour = this.user.getCostPerHour();
        this.overtimeRatePerHour = this.user.getOvertimeRatePerHour();
        this.regularPayment = this.regularWorkHour * this.costPerHour;
        this.overtimePayment = this.overtimeHour * this.overtimeRatePerHour;
        this.totalPayment = this.regularPayment + this.overtimePayment;
        long totalWorkInHour = this.getHour(this.totalWorkHourMs);
        long totalWorkInMin = this.getMin(this.totalWorkHourMs);
        this.totalHourDisplay = totalWorkInHour + "h " + totalWorkInMin + "m";
        this.regularHourDisplay = totalWorkHour < 40.0 ? this.totalHourDisplay : "40h";
        long overtimeMS = (long)(this.overtimeHour * 3600000.0);
        long otHour = this.getHour(overtimeMS);
        long otMin = this.getMin(overtimeMS);
        this.overtimeDisplay = otHour + "h " + otMin + "m";
    }

    private long getHour(long valueInMS) {
        return valueInMS / 3600000L;
    }

    private long getMin(long valueInMS) {
        long hour = valueInMS / 3600000L;
        return (valueInMS -= hour * 3600000L) / 60000L;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public double getRegularHour() {
        return this.regularWorkHour;
    }

    public void setRegularHour(double totalHour) {
        this.regularWorkHour = totalHour;
    }

    public double getRate() {
        return this.costPerHour;
    }

    public void setRate(double rate) {
        this.costPerHour = rate;
    }

    public double getTotalPayment() {
        return this.totalPayment;
    }

    public void setTotalPayment(double payment) {
        this.totalPayment = payment;
    }

    public Date getFromDateOfWeek() {
        return this.fromDateOfWeek;
    }

    public void setFromDateOfWeek(Date fromDateOfWeek) {
        this.fromDateOfWeek = fromDateOfWeek;
    }

    public Date getToDateOfWeek() {
        return this.toDateOfWeek;
    }

    public void setToDateOfWeek(Date toDateOfWeek) {
        this.toDateOfWeek = toDateOfWeek;
    }

    public double getOvertime() {
        return this.overtimeHour;
    }

    public void setOvertime(double overtime) {
        this.overtimeHour = overtime;
    }

    public double getOvertimeRate() {
        return this.overtimeRatePerHour;
    }

    public void setOvertimeRate(double overtimeRate) {
        this.overtimeRatePerHour = overtimeRate;
    }

    public double getRegularPayment() {
        return this.regularPayment;
    }

    public void setRegularPayment(double regularPayment) {
        this.regularPayment = regularPayment;
    }

    public double getOvertimePayment() {
        return this.overtimePayment;
    }

    public void setOvertimePayment(double overtimePayment) {
        this.overtimePayment = overtimePayment;
    }

    public double getTotalDeclaredTips() {
        return this.totalDeclaredTips;
    }

    public void setTotalDeclaredTips(double totalDeclaredTips) {
        this.totalDeclaredTips = totalDeclaredTips;
    }

    public double getTotalNoCashTips() {
        return this.totalNoCashTips;
    }

    public void setTotalNoCashTips(double totalNoCashTips) {
        this.totalNoCashTips = totalNoCashTips;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public long getTotalWorkHourMs() {
        return this.totalWorkHourMs;
    }

    public void setTotalWorkHourMs(long totalWorkHourMs) {
        this.totalWorkHourMs = totalWorkHourMs;
    }

    public String getRegularHourDisplay() {
        return this.regularHourDisplay;
    }

    public void setRegularHourDisplay(String regularHourDisplay) {
        this.regularHourDisplay = regularHourDisplay;
    }

    public String getOvertimeDisplay() {
        return this.overtimeDisplay;
    }

    public void setOvertimeDisplay(String overtimeDisplay) {
        this.overtimeDisplay = overtimeDisplay;
    }

    public String getTotalHourDisplay() {
        return this.totalHourDisplay;
    }

    public void setTotalHourDisplay(String totalHourDisplay) {
        this.totalHourDisplay = totalHourDisplay;
    }
}

