/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GiftCardTransactionsReportModel
extends ListTableModel {
    private String[] columnNames = new String[]{"txNumber", "ticketNo", "txTime", "desc", "txAmount"};

    public GiftCardTransactionsReportModel(List rows) {
        this.setColumnNames(this.columnNames);
        this.setRows(rows);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PosTransaction transaction = (PosTransaction)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return transaction.getId();
            }
            case 1: {
                if (StringUtils.isNotEmpty((String)transaction.getTicketId())) {
                    return transaction.getTicketId();
                }
                return "";
            }
            case 2: {
                if (transaction.getTransactionTime() != null) {
                    return DateUtil.formatReportDateAsString(transaction.getTransactionTime());
                }
                return "";
            }
            case 3: {
                if (transaction instanceof GiftCertificateTransaction) {
                    return Messages.getString("GiftCardTransactionsReportModel.2");
                }
                if (transaction instanceof CashTransaction) {
                    return Messages.getString("GiftCardTransactionsReportModel.3");
                }
                return "";
            }
            case 4: {
                if (transaction instanceof GiftCertificateTransaction) {
                    return transaction.getAmount() * -1.0;
                }
                return transaction.getAmount();
            }
        }
        return null;
    }
}

