/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import org.apache.commons.lang3.StringUtils;

public class PaymentReceivedReportModel
extends ListTableModel {
    public PaymentReceivedReportModel() {
        super(new String[]{"user", "transTime", "transNo", "ticket", "transType", "total", "memberName"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PosTransaction data = (PosTransaction)this.rows.get(rowIndex);
        Ticket ticket = data.getTicket();
        switch (columnIndex) {
            case 0: {
                User user = data.getUser();
                return user.getFullName();
            }
            case 1: {
                return DateUtil.formatFullDateAndTimeWithoutYearAsString(data.getTransactionTime());
            }
            case 2: {
                return data.getId();
            }
            case 3: {
                if (ticket == null) {
                    return "";
                }
                return data.getTicket().getId();
            }
            case 4: {
                String customPaymentName;
                PaymentType paymentType = data.getPaymentType();
                if (paymentType == null) {
                    return null;
                }
                String paymentTypeStr = paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) ? (StringUtils.isEmpty((CharSequence)(customPaymentName = data.getCustomPaymentName())) ? null : customPaymentName) : paymentType.getDisplayString();
                return paymentTypeStr;
            }
            case 5: {
                return data.getAmount();
            }
            case 6: {
                if (ticket == null) {
                    return "";
                }
                if (data.getTicket().getCustomer() != null) {
                    return data.getTicket().getCustomer().getName();
                }
                return "";
            }
        }
        return null;
    }
}

