/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CashDrawerReportService {
    private CashDrawer cashDrawer;
    private Session session;

    public CashDrawerReportService(CashDrawer cashDrawer) {
        this.cashDrawer = cashDrawer;
    }

    public void populateReport() {
        GenericDAO dao = new GenericDAO();
        try {
            this.session = dao.createNewSession();
            this.populateReport(this.session);
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer() {
        GenericDAO dao = new GenericDAO();
        try {
            this.session = dao.createNewSession();
            this.populateSummaryOfCashdrawer(this.session);
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer(Session session) {
        this.session = session;
        this.calculateNetSales();
        this.calculateRefundAmount();
        this.calculateDrawerBleed();
        this.calculateCashTips();
        this.calculateChargedTips();
        double totalRev = this.cashDrawer.getNetSales() - this.cashDrawer.getRefundAmount() - this.cashDrawer.getDrawerBleedAmount() + this.cashDrawer.getSalesTax() + this.cashDrawer.getServiceCharge();
        this.cashDrawer.setTotalRevenue(POSUtil.getRoundedDouble(totalRev));
        this.cashDrawer.setGrossReceipts(POSUtil.getRoundedDouble(this.cashDrawer.getTotalRevenue() + this.cashDrawer.getCashTips() + this.cashDrawer.getChargedTips()));
    }

    public void populateReport(Session session) {
        this.session = session;
        this.calculateNetSales();
        this.calculateRefundAmount();
        this.calculateDrawerBleed();
        this.calculateCashTips();
        this.calculateChargedTips();
        double totalRev = this.cashDrawer.getNetSales() - this.cashDrawer.getRefundAmount() - this.cashDrawer.getDrawerBleedAmount() + this.cashDrawer.getSalesTax() + this.cashDrawer.getServiceCharge();
        this.cashDrawer.setTotalRevenue(POSUtil.getRoundedDouble(totalRev));
        this.cashDrawer.setGrossReceipts(POSUtil.getRoundedDouble(this.cashDrawer.getTotalRevenue() + this.cashDrawer.getCashTips() + this.cashDrawer.getChargedTips()));
        this.calculateCashReceipt();
        this.calculateCreditReceipt();
        this.calculateDebitReceipt();
        this.calculateMemberPayment();
        this.calculateCustomPaymentWithoutPromotion();
        this.calculatePromotionAmount();
        this.calculateGiftCertReceipts();
        this.calculateVoidAmount();
        this.calculateCashPayout();
        this.calculateCashBack();
        this.calculateTipsPaid();
        this.calculateReceiptDiff();
        this.calculateTipsDiff();
        this.calculateDrawerAccountable();
    }

    private void calculateMemberPayment() {
        Criteria criteria = this.getCriteriaForTransaction(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.cashDrawer.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDrawerAccountable() {
        double drawerAccountableAmnt = this.cashDrawer.getCashReceiptAmount() - this.cashDrawer.getTipsPaid() - this.cashDrawer.getPayOutAmount() - this.cashDrawer.getCashBack() + this.cashDrawer.getBeginCash() - this.cashDrawer.getDrawerBleedAmount();
        this.cashDrawer.setDrawerAccountable(POSUtil.getRoundedDouble(drawerAccountableAmnt));
    }

    private void calculateTipsDiff() {
        double tipsDiff = this.cashDrawer.getCashTips() + this.cashDrawer.getChargedTips() - this.cashDrawer.getTipsPaid();
        this.cashDrawer.setTipsDifferential(POSUtil.getRoundedDouble(tipsDiff));
    }

    private void calculateReceiptDiff() {
        double receiptDiff = this.cashDrawer.getGrossReceipts() - this.cashDrawer.getCashReceiptAmount() - this.cashDrawer.getCreditCardReceiptAmount() - this.cashDrawer.getDebitCardReceiptAmount() - this.cashDrawer.getCustomerPaymentAmount() - this.cashDrawer.getCustomPaymentAmount() - this.cashDrawer.getPromotionAmount() - this.cashDrawer.getGiftCertChangeAmount() - this.cashDrawer.getGiftCertReturnAmount() + this.cashDrawer.getTotalVoid() + this.cashDrawer.getRefundAmount();
        this.cashDrawer.setReceiptDifferential(POSUtil.getRoundedDouble(receiptDiff));
    }

    private Criteria getCriteriaForTransaction(Class transactionClass) {
        Criteria criteria = this.session.createCriteria(transactionClass);
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.cashDrawer.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private Criteria getCriteriaForTipsTransaction(Class transactionClass) {
        Criteria criteria = this.session.createCriteria(transactionClass);
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.cashDrawer.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_OWNER_ID), (Object)this.cashDrawer.getAssignedUserId()));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    private void calculateNetSales() {
        Criteria criteria = this.getCriteriaForTransaction(PosTransaction.class);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_SERVICE_CHARGE_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        double tipsAmnt = this.calculateTipsAmount();
        for (Object[] objects : list) {
            if (objects[0] == null) {
                return;
            }
            double salesAmnt = objects[0] != null ? ((Number)objects[0]).doubleValue() : 0.0;
            double taxAmnt = objects[1] != null ? ((Number)objects[1]).doubleValue() : 0.0;
            double serviceChrgAmnt = objects[2] != null ? ((Number)objects[2]).doubleValue() : 0.0;
            double netSales = salesAmnt - taxAmnt - tipsAmnt - serviceChrgAmnt;
            this.cashDrawer.setNetSales(NumberUtil.round(netSales));
            this.cashDrawer.setSalesTax(NumberUtil.round(taxAmnt));
            this.cashDrawer.setServiceCharge(NumberUtil.round(serviceChrgAmnt));
        }
    }

    private double calculateTipsAmount() {
        Criteria criteria = this.getCriteriaForTipsTransaction(PosTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return POSUtil.getRoundedDouble(criteria.uniqueResult());
    }

    private void calculateCashTips() {
        Criteria criteria = this.getCriteriaForTipsTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.cashDrawer.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateChargedTips() {
        Criteria criteria = this.getCriteriaForTipsTransaction(PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.cashDrawer.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.cashDrawer.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCreditReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.cashDrawer.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDebitReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.cashDrawer.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCustomPaymentWithoutPromotion() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.cashDrawer.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculatePromotionAmount() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.cashDrawer.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateGiftCertReceipts() {
        Criteria criteria = this.getCriteriaForTransaction(GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.cashDrawer.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateRefundAmount() {
        Criteria criteria = this.getCriteriaForTransaction(RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.cashDrawer.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateVoidAmount() {
        Criteria criteria = this.session.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.cashDrawer.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.cashDrawer.setCardVoidAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashPayout() {
        Criteria criteria = this.getCriteriaForTransaction(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.cashDrawer.setPayOutAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDrawerBleed() {
        Criteria criteria = this.getCriteriaForTransaction(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.cashDrawer.setDrawerBleedAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashBack() {
        Criteria criteria = this.getCriteriaForTransaction(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.cashDrawer.setCashBack(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateTipsPaid() {
        Criteria criteria = this.session.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_CASH_DRAWER, (Object)this.cashDrawer));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        this.cashDrawer.setTipsPaid(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }
}

