/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionSummaryReportService {
    private StoreSession storeSession;
    private Session session;
    private CashDrawer sessionCashDrawer = new CashDrawer();

    public StoreSessionSummaryReportService(StoreSession storeSession) {
        this.storeSession = storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer populateStoreSessionSummaryReport() {
        GenericDAO dao = new GenericDAO();
        try {
            this.session = dao.createNewSession();
            this.calculateRefundAmount();
            this.calculateNetSales();
            this.calculateCashTips();
            this.calculateChargedTips();
            double totalTips = this.sessionCashDrawer.getCashTips() + this.sessionCashDrawer.getChargedTips();
            double totalRev = this.sessionCashDrawer.getNetSales() - this.sessionCashDrawer.getTotalDiscountAmount() + this.sessionCashDrawer.getSalesTax() + this.sessionCashDrawer.getServiceCharge();
            this.sessionCashDrawer.setTotalRevenue(POSUtil.getRoundedDouble(totalRev));
            this.sessionCashDrawer.setGrossReceipts(POSUtil.getRoundedDouble(this.sessionCashDrawer.getTotalRevenue() + totalTips));
            this.calculateCashReceipt();
            this.calculateCreditReceipt();
            this.calculateDebitReceipt();
            this.calculateMemberPayment();
            this.calculateCustomPaymentWithoutPromotion();
            this.calculatePromotionPayment();
            this.calculateGiftCertReceipts();
            this.calculateVoidAmount();
            this.calculateTipsPaid();
            this.calculateCashPayout();
            this.calculateCashBack();
            this.calculateDrawerBleed();
            this.calculateToleranceAmount();
            double totalReceiptsDiff = this.sessionCashDrawer.getCashReceiptAmount() + this.sessionCashDrawer.getCreditCardReceiptAmount() + this.sessionCashDrawer.getDebitCardReceiptAmount() + this.sessionCashDrawer.getCustomerPaymentAmount() + this.sessionCashDrawer.getCustomPaymentAmount() + this.sessionCashDrawer.getPromotionAmount() + this.sessionCashDrawer.getGiftCertChangeAmount() - this.sessionCashDrawer.getRefundAmount() - this.sessionCashDrawer.getToleranceAmount();
            this.sessionCashDrawer.setReceiptDifferential(POSUtil.getRoundedDouble(this.sessionCashDrawer.getGrossReceipts() - totalReceiptsDiff));
            this.sessionCashDrawer.setAssignedUser(this.storeSession.getOpenedBy());
            this.sessionCashDrawer.setStartTime(this.storeSession.getOpenTime());
            this.sessionCashDrawer.setAssignedBy(this.storeSession.getOpenedBy());
            this.sessionCashDrawer.setReportTime(this.storeSession.getCloseTime());
            this.sessionCashDrawer.setClosedBy(this.storeSession.getClosedBy());
            this.sessionCashDrawer.setStoreOperationData(this.storeSession);
            this.calculateTipsDiff();
            this.calculateDeclaredTips();
            this.calculateCashDrawerBeginAmount();
            this.calculateDrawerAccountable();
            CashDrawer cashDrawer = this.sessionCashDrawer;
            return cashDrawer;
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    private Criteria getCriteriaForTransaction(Class transactionClass) {
        Criteria criteria = this.session.createCriteria(transactionClass);
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void calculateNetSales() {
        Criteria criteria = this.session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.ne((String)Ticket.PROP_VOIDED, (Object)Boolean.TRUE));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        for (Object[] objects : list) {
            double salesAmnt = objects[0] != null ? ((Number)objects[0]).doubleValue() : 0.0;
            double taxAmnt = objects[1] != null ? ((Number)objects[1]).doubleValue() : 0.0;
            double serviceChrgAmnt = objects[2] != null ? ((Number)objects[2]).doubleValue() : 0.0;
            double discountAmount = objects[3] != null ? ((Number)objects[3]).doubleValue() : 0.0;
            this.sessionCashDrawer.setNetSales(NumberUtil.round(salesAmnt));
            this.sessionCashDrawer.setSalesTax(NumberUtil.round(taxAmnt));
            this.sessionCashDrawer.setServiceCharge(NumberUtil.round(serviceChrgAmnt));
            this.sessionCashDrawer.setTotalDiscountAmount(NumberUtil.round(discountAmount));
        }
    }

    private void calculateCashTips() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.sessionCashDrawer.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateChargedTips() {
        Criteria criteria = this.getCriteriaForTransaction(PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.sessionCashDrawer.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCreditReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDebitReceipt() {
        Criteria criteria = this.getCriteriaForTransaction(DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCustomPaymentWithoutPromotion() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculatePromotionPayment() {
        Criteria criteria = this.getCriteriaForTransaction(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateGiftCertReceipts() {
        Criteria criteria = this.getCriteriaForTransaction(GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateRefundAmount() {
        Criteria criteria = this.getCriteriaForTransaction(RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateVoidAmount() {
        Criteria criteria = this.session.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCardVoidAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashDrawerBeginAmount() {
        Criteria criteria = this.session.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        this.sessionCashDrawer.setBeginCash(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateTipsPaid() {
        Criteria criteria = this.session.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        this.sessionCashDrawer.setTipsPaid(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashPayout() {
        Criteria criteria = this.getCriteriaForTransaction(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setPayOutAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDrawerBleed() {
        Criteria criteria = this.getCriteriaForTransaction(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setDrawerBleedAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateCashBack() {
        Criteria criteria = this.getCriteriaForTransaction(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCashBack(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateMemberPayment() {
        Criteria criteria = this.getCriteriaForTransaction(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateDrawerAccountable() {
        double drawerAccountableAmnt = this.sessionCashDrawer.getCashReceiptAmount() - this.sessionCashDrawer.getTipsPaid() - this.sessionCashDrawer.getPayOutAmount() - this.sessionCashDrawer.getCashBack() + this.sessionCashDrawer.getBeginCash() - this.sessionCashDrawer.getDrawerBleedAmount();
        this.sessionCashDrawer.setDrawerAccountable(POSUtil.getRoundedDouble(drawerAccountableAmnt));
    }

    private void calculateTipsDiff() {
        double tipsDiff = this.sessionCashDrawer.getCashTips() + this.sessionCashDrawer.getChargedTips() - this.sessionCashDrawer.getTipsPaid();
        this.sessionCashDrawer.setTipsDifferential(POSUtil.getRoundedDouble(tipsDiff));
    }

    private void calculateDeclaredTips() {
        Criteria criteria = this.session.createCriteria(DeclaredTips.class);
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.sessionCashDrawer.setDeclaredTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void calculateToleranceAmount() {
        Criteria criteria = this.getCriteriaForTransaction(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.storeSession.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        this.sessionCashDrawer.setToleranceAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }
}

