/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.swing.PosUIManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CheckBoxList<E>
extends JTable {
    public CheckBoxList() {
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public CheckBoxList(E[] items) {
        this.setModel(items);
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public CheckBoxList(List<E> items) {
        this.setModel(items);
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public void setModel(E[] items) {
        this.setModel(items, new String[]{"", ""});
    }

    public void setModel(List<E> items) {
        this.setModel(items, new String[]{"", ""});
    }

    public void setModel(List<E> items, String[] header) {
        CheckBoxListModel<E> model = new CheckBoxListModel<E>(header, items);
        this.setModel(model);
        this.init();
    }

    public void setModel(E[] items, String[] header) {
        CheckBoxListModel<E> model = new CheckBoxListModel<E>(items, header);
        this.setModel(model);
        this.init();
    }

    public List<E> getCheckedValues() {
        ArrayList values = new ArrayList();
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Entry entry = (Entry)model.getRow(i);
            if (!entry.checked) continue;
            values.add(entry.value);
        }
        return values;
    }

    public Set<E> getCheckedValuesAsSet() {
        HashSet values = new HashSet();
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Entry entry = (Entry)model.getRow(i);
            if (!entry.checked) continue;
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public void selectAll() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Entry entry = (Entry)model.getRow(i);
            entry.checked = true;
        }
        model.fireTableRowsUpdated(0, model.getRowCount());
    }

    public void selectItems(List types) {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        if (types != null) {
            block0: for (int i = 0; i < model.getRowCount(); ++i) {
                Entry entry = (Entry)model.getRow(i);
                for (int j = 0; j < types.size(); ++j) {
                    Object type = types.get(j);
                    if (!type.equals(entry.value)) continue;
                    entry.checked = true;
                    continue block0;
                }
            }
            model.fireTableRowsUpdated(0, model.getRowCount());
        }
    }

    public void selectItems(Set<E> types) {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        if (types != null) {
            block0: for (int i = 0; i < model.getRowCount(); ++i) {
                Entry entry = (Entry)model.getRow(i);
                for (E e : types) {
                    if (!e.equals(entry.value)) continue;
                    entry.checked = true;
                    continue block0;
                }
            }
            model.fireTableRowsUpdated(0, model.getRowCount());
        }
    }

    public void selectItem(E item) {
        if (item == null) {
            return;
        }
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Entry entry = (Entry)model.getRow(i);
            if (!item.equals(entry.value)) continue;
            entry.checked = true;
            break;
        }
        model.fireTableRowsUpdated(0, model.getRowCount());
    }

    public void unCheckAll() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Entry entry = (Entry)model.getRow(i);
            entry.checked = false;
        }
        model.fireTableRowsUpdated(0, model.getRowCount());
    }

    public Entry[] getValues() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        return (Entry[])model.getItems().toArray();
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.getModel().getValueAt(row, 1);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer cellRenderer = super.getCellRenderer(row, column);
        if (cellRenderer instanceof JCheckBox) {
            ((JCheckBox)((Object)cellRenderer)).setEnabled(this.isEnabled());
        }
        return cellRenderer;
    }

    public void init() {
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(false);
        this.setAutoResizeMode(3);
        if (this.getColumnModel() != null && this.getColumnCount() > 0) {
            TableColumn column = this.getColumnModel().getColumn(0);
            int checkBoxWidth = new JCheckBox().getPreferredSize().width;
            column.setPreferredWidth(checkBoxWidth);
            column.setMinWidth(checkBoxWidth);
            column.setWidth(checkBoxWidth);
            column.setMaxWidth(checkBoxWidth);
            column.setResizable(false);
        }
    }

    public void setTableHeaderHide(boolean hideHeader) {
        if (hideHeader) {
            this.setTableHeader(null);
        }
    }

    public static class Entry<E> {
        public boolean checked;
        public E value;

        public Entry(boolean checked, E value) {
            this.checked = checked;
            this.value = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public Object getValue() {
            return this.value;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public void setValue(E value) {
            this.value = value;
        }
    }
}

