/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.DoubleDocument;
import com.floreantpos.swing.FocusedTextField;
import com.floreantpos.swing.NumberDocument;
import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class DoubleTextField
extends FocusedTextField {
    public DoubleTextField() {
        this.setDocument(new DoubleDocument());
    }

    public DoubleTextField(int columns) {
        super(columns);
        this.setDocument(new DoubleDocument());
    }

    public DoubleTextField(int columns, int beforeDecimal, int afterDecimal) {
        super(columns);
        this.setDocument(new DoubleDocument(beforeDecimal, afterDecimal));
    }

    public DoubleTextField(int columns, int length) {
        super(columns);
        this.setDocument(new DoubleDocument(length));
    }

    public void setAllowNegativeValue(boolean b) {
        if (b) {
            this.setDocument(new NumberDocument());
        } else {
            this.setDocument(new DoubleDocument());
        }
    }

    public double getDouble() {
        String text = this.getText();
        if (StringUtils.isBlank((String)text)) {
            return Double.NaN;
        }
        return NumberUtil.parseOrGetZero(text).doubleValue();
    }

    public double getDoubleOrZero() {
        return NumberUtil.parseOrGetZero(this.getText()).doubleValue();
    }
}

