/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;

public class IntegerDocument
extends PlainDocument {
    public IntegerDocument() {
        this.setDocumentFilter(new IntegerDocumentFilter(8));
    }

    public IntegerDocument(int length) {
        this.setDocumentFilter(new IntegerDocumentFilter(length));
    }

    class IntegerDocumentFilter
    extends DocumentFilter {
        private int length;

        public IntegerDocumentFilter() {
        }

        public IntegerDocumentFilter(int length) {
            this.length = length;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            int currentLength = IntegerDocument.this.getLength() + string.length();
            if (this.length != 0 && currentLength > this.length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        private boolean test(String text) {
            try {
                if (StringUtils.isNotBlank((String)text)) {
                    Integer.parseInt(text);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.length != 0 && sb.length() > this.length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (sb.toString().length() == 0) {
                super.replace(fb, offset, length, "", null);
            } else if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }
    }
}

