/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class OrderTypeLoginButton
extends PosButton
implements ActionListener {
    private OrderType orderType;

    public OrderTypeLoginButton() {
        super("");
    }

    public OrderTypeLoginButton(OrderType orderType) {
        this.orderType = orderType;
        if (orderType != null) {
            ImageIcon imgIcon = orderType.getImage();
            Color buttonColor = orderType.getButtonColor();
            Color textColor = orderType.getTextColor();
            if (imgIcon != null) {
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(POSUtil.scaleImage(imgIcon, 60));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setIcon(POSUtil.scaleImage(imgIcon, 60));
                    if (buttonColor != null) {
                        this.setBackground(buttonColor);
                    }
                    if (textColor != null) {
                        this.setForeground(textColor);
                    }
                    this.setText(orderType.name());
                }
            } else {
                this.setText(orderType.name());
                if (buttonColor != null) {
                    this.setBackground(buttonColor);
                }
                if (textColor != null) {
                    this.setForeground(textColor);
                }
            }
        } else {
            this.setText(POSConstants.TAKE_OUT_BUTTON_TEXT);
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TerminalConfig.setDefaultView(this.orderType.getId());
        LoginView.getInstance().doLogin();
    }
}

