/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.PosButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class PosBlinkButton
extends PosButton
implements ActionListener {
    private boolean blinking = false;
    private boolean blinked = false;
    private final Color originalBackColor = this.getBackground();
    private final Color originalForeColor = this.getForeground();
    private boolean originalOpaque = this.isOpaque();
    private Color blinkColor = Color.YELLOW;
    private Color blinkDimColor;
    private boolean blinkText = false;
    private int[] blinkRate = new int[]{13, 8, 5, 3, 2, 1};
    private int blinkRateIndex = 0;
    private int numOfBlink = 10;
    private int blinkCount;

    public PosBlinkButton() {
        this.addActionListener(this);
    }

    public PosBlinkButton(ImageIcon imageIcon) {
        super(imageIcon);
        this.addActionListener(this);
    }

    public PosBlinkButton(String text) {
        super(text);
        this.addActionListener(this);
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public void setBlinking(boolean blinking) {
        if (blinking && this.blinking == blinking) {
            return;
        }
        this.blinking = blinking;
        this.blinkCount = 0;
        if (blinking) {
            if (this.blinkText) {
                this.blinkForeGround();
            } else {
                this.blinkBackground();
            }
        } else {
            this.blinkRateIndex = 0;
            this.setOpaque(this.originalOpaque);
            this.setForeground(this.originalForeColor);
            this.setBackground(this.originalBackColor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            this.setBlinking(false);
            return;
        }
        this.blinked = !this.blinked;
        ++this.blinkCount;
        if (this.blinkText) {
            this.blinkForeGround();
        } else {
            this.blinkBackground();
        }
        if (this.numOfBlink > 0 && this.blinkCount > this.numOfBlink) {
            this.stopBlinking();
        }
    }

    private void stopBlinking() {
        this.blinking = false;
        this.blinkRateIndex = 0;
        if (this.blinkText) {
            this.setForeground(this.blinkColor);
        } else {
            this.setBackground(this.blinkColor);
        }
    }

    public void setNumOfBlink(int blinkTime) {
        this.numOfBlink = blinkTime;
    }

    private void blinkBackground() {
        this.setOpaque(true);
        if (this.blinked) {
            this.setBackground(this.blinkColor.darker());
        } else {
            this.setBackground(this.blinkColor);
        }
    }

    private void blinkForeGround() {
        if (this.blinked) {
            this.setForeground(this.blinkDimColor == null ? this.blinkColor.darker() : this.blinkDimColor);
        } else {
            this.setForeground(this.blinkColor);
        }
    }

    public Color getBlinkColor() {
        return this.blinkColor;
    }

    public void setBlinkColor(Color blinkColor) {
        if (blinkColor != null) {
            this.blinkColor = blinkColor;
        }
    }

    public boolean isBlinkText() {
        return this.blinkText;
    }

    public void setBlinkText(boolean blinkText) {
        this.blinkText = blinkText;
    }

    public void setOriginalOpaque(boolean originalOpaque) {
        this.originalOpaque = originalOpaque;
        this.setOpaque(originalOpaque);
    }

    public Color getBlinkDimColor() {
        return this.blinkDimColor;
    }

    public void setBlinkDimColor(Color blinkDimColor) {
        this.blinkDimColor = blinkDimColor;
    }
}

