/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.teminaltype;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.teminaltype.TerminalCategory;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleObjectStateException;

public class TerminalTypeForm
extends BeanEditor<TerminalType> {
    private FixedLengthTextField tfName;
    private CheckBoxList orderTypeCheckBoxList;
    private CheckBoxList categoryCheckBoxList;
    private String newTerminalType;
    private TerminalCategoryPanel terminalTypePanel;

    public TerminalTypeForm() {
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        this.setBorder(BorderFactory.createTitledBorder("Terminal Type"));
        this.orderTypeCheckBoxList = new CheckBoxList();
        this.orderTypeCheckBoxList.setModel(OrderTypeDAO.getInstance().findAll());
        this.categoryCheckBoxList = new CheckBoxList();
        this.categoryCheckBoxList.setModel(MenuCategoryDAO.getInstance().findAll());
        JLabel lblName = new JLabel("Name");
        this.add((Component)lblName, "alignx right,aligny center");
        this.tfName = new FixedLengthTextField();
        this.add((Component)this.tfName, "alignx left,growx,split 2");
        this.terminalTypePanel = new TerminalCategoryPanel();
        this.add((Component)this.terminalTypePanel, "wrap");
        JScrollPane orderTypeScrollPane = new JScrollPane(this.orderTypeCheckBoxList);
        orderTypeScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.1")));
        this.add((Component)orderTypeScrollPane, "skip 1,split 2,grow");
        JScrollPane categoryScrollPane = new JScrollPane(this.categoryCheckBoxList);
        categoryScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.2")));
        this.add((Component)categoryScrollPane, "grow");
    }

    @Override
    public void createNew() {
        TerminalType bean2 = new TerminalType();
        this.setBean(bean2);
        this.tfName.setText("");
        this.orderTypeCheckBoxList.unCheckAll();
        this.categoryCheckBoxList.unCheckAll();
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.0")));
    }

    @Override
    public void cancel() {
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.4")));
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.orderTypeCheckBoxList.unCheckAll();
        this.categoryCheckBoxList.unCheckAll();
        this.terminalTypePanel.setSelectedTerminalCategory(0);
    }

    @Override
    public boolean delete() {
        try {
            TerminalType bean2 = (TerminalType)this.getBean();
            if (bean2 == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalTypeForm.5"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return false;
            }
            TerminalTypeDAO.getInstance().delete(bean2);
            this.tfName.setText("");
            this.orderTypeCheckBoxList.unCheckAll();
            return true;
        }
        catch (PosException e) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(e.getMessage(), e.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
        return false;
    }

    public boolean deleteAllTables() {
        List<TerminalType> list = TerminalTypeDAO.getInstance().findAll();
        if (list.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Empty");
            return false;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalTypeForm.7"), Messages.getString("CONFIRM"));
        if (option != 0) {
            return false;
        }
        for (TerminalType terminalType : list) {
            TerminalTypeDAO.getInstance().delete(terminalType);
        }
        this.tfName.setText("");
        this.orderTypeCheckBoxList.unCheckAll();
        return true;
    }

    public void setFieldsEditerminalType(boolean editerminalType) {
        this.tfName.setEditable(editerminalType);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.orderTypeCheckBoxList.setEnabled(enable);
        this.orderTypeCheckBoxList.clearSelection();
        this.categoryCheckBoxList.setEnabled(enable);
        this.categoryCheckBoxList.clearSelection();
        this.tfName.setEnabled(enable);
        this.terminalTypePanel.setEnableButtons(enable);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalType terminalType = (TerminalType)this.getBean();
            TerminalTypeDAO.getInstance().saveOrUpdate(terminalType);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException terminalType) {
        }
        catch (StaleObjectStateException e) {
            BOMessageDialog.showError(this, Messages.getString("MessageDialog.0"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        TerminalType terminalType = (TerminalType)this.getBean();
        if (terminalType == null) {
            return;
        }
        TerminalTypeDAO.getInstance().initialize(terminalType);
        this.orderTypeCheckBoxList.unCheckAll();
        this.categoryCheckBoxList.unCheckAll();
        this.orderTypeCheckBoxList.selectItems(terminalType.getOrderTypes());
        this.categoryCheckBoxList.selectItems(terminalType.getCategories());
        this.tfName.setText(terminalType.getName());
        this.terminalTypePanel.setSelectedTerminalCategory(terminalType.getType());
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.4")));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String name;
        TerminalType terminalType = (TerminalType)this.getBean();
        if (terminalType == null) {
            terminalType = new TerminalType();
            this.setBean(terminalType, false);
        }
        if (StringUtils.isBlank((String)(name = this.tfName.getText()))) {
            POSMessageDialog.showError(this, Messages.getString("CouponForm.1"));
            return false;
        }
        if (TerminalTypeDAO.getInstance().nameExists(terminalType, name)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalTypeForm.3"));
            return false;
        }
        terminalType.setName(name.trim());
        List<OrderType> checkValues = this.orderTypeCheckBoxList.getCheckedValues();
        terminalType.setOrderTypes(checkValues);
        List<MenuCategory> checkedCategories = this.categoryCheckBoxList.getCheckedValues();
        terminalType.setCategories(checkedCategories);
        terminalType.setType(this.terminalTypePanel.getSelectedTerminalCategory());
        this.newTerminalType = terminalType.getName();
        return true;
    }

    @Override
    public void edit() {
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalTypeForm.11")));
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("TerminalTypeForm.4");
    }

    public void setTableTypeCBoxListEnable(boolean enable) {
        this.orderTypeCheckBoxList.setEnabled(enable);
        this.categoryCheckBoxList.setEnabled(enable);
    }

    public String getNewlyAddedRow() {
        return this.newTerminalType;
    }

    private class TerminalCategoryPanel
    extends JPanel {
        public TerminalCategoryPanel() {
            this.setLayout((LayoutManager)new MigLayout());
            ButtonGroup group = new ButtonGroup();
            for (TerminalCategory category : TerminalCategory.values()) {
                JRadioButton btnCategory = new JRadioButton(category.toString());
                btnCategory.putClientProperty("terminalType", category.getType());
                group.add(btnCategory);
                this.add(btnCategory);
            }
        }

        public void setSelectedTerminalCategory(Integer type) {
            for (Component c : this.getComponents()) {
                JRadioButton button = (JRadioButton)c;
                int terminalType = (Integer)button.getClientProperty("terminalType");
                if (terminalType != type) continue;
                button.setSelected(true);
                break;
            }
        }

        public void setEnableButtons(boolean b) {
            for (Component c : this.getComponents()) {
                JRadioButton button = (JRadioButton)c;
                button.setEnabled(b);
            }
        }

        public int getSelectedTerminalCategory() {
            for (Component c : this.getComponents()) {
                JRadioButton button = (JRadioButton)c;
                if (!button.isSelected()) continue;
                return (Integer)button.getClientProperty("terminalType");
            }
            return 0;
        }
    }
}

