/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.teminaltype;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.model.TerminalType;
import com.floreantpos.teminaltype.TerminalTypeForm;
import com.floreantpos.ui.BeanEditor;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;

public class TerminalTypeModelBrowser<E>
extends ModelBrowser {
    private BeanEditor beanEditor;
    private JButton btnDeleteAll = new JButton(Messages.getString("ShopTableModelBrowser.1"));

    public TerminalTypeModelBrowser(BeanEditor<E> beanEditor) {
        super(beanEditor);
        this.beanEditor = beanEditor;
    }

    @Override
    public void init(TableModel tableModel) {
        super.init(tableModel);
        this.buttonPanel.add(this.btnDeleteAll);
        this.btnDeleteAll.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = Command.fromString(e.getActionCommand());
        try {
            switch (command) {
                case NEW: {
                    this.beanEditor.createNew();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.browserTable.clearSelection();
                    break;
                }
                case EDIT: {
                    this.beanEditor.edit();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    break;
                }
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.beanEditor.save()) break;
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    this.customSelectedRow();
                    break;
                }
                case DELETE: {
                    if (!this.beanEditor.delete()) break;
                    this.beanEditor.setBean(null);
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    break;
                }
            }
            this.handleAdditionaButtonActionIfApplicable(e);
            TerminalTypeForm form = (TerminalTypeForm)this.beanEditor;
            if (e.getSource() == this.btnDeleteAll) {
                if (!form.deleteAllTables()) {
                    return;
                }
                this.refreshTable();
                this.btnNew.setEnabled(true);
                this.btnEdit.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnDelete.setEnabled(false);
                this.btnCancel.setEnabled(false);
            }
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.btnDeleteAll.setEnabled(true);
    }

    @Override
    public void doCancelEditing() {
        super.doCancelEditing();
        if (this.browserTable.getSelectedRow() != -1) {
            // empty if block
        }
    }

    private void customSelectedRow() {
        TerminalTypeForm form = (TerminalTypeForm)this.beanEditor;
        TerminalType newlyAddedRow = (TerminalType)form.getBean();
        if (newlyAddedRow == null) {
            return;
        }
        int x = this.getRowByValue(this.browserTable.getModel(), newlyAddedRow);
        this.browserTable.setRowSelectionInterval(x, x);
    }

    private int getRowByValue(TableModel model, TerminalType value) {
        for (int i = 0; i <= model.getRowCount(); ++i) {
            String terminalType = (String)model.getValueAt(i, 0);
            if (!terminalType.equals(value.getName())) continue;
            return i;
        }
        return -1;
    }
}

