/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.order.TicketListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class OrderFilterPanel
extends JXCollapsiblePane {
    private ITicketList ticketList;
    private TicketListView ticketLists;
    private POSToggleButton btnFilterByOpenStatus;
    private POSToggleButton btnFilterByUnPaidStatus;

    public OrderFilterPanel(ITicketList ticketList) {
        this.ticketList = ticketList;
        this.ticketLists = (TicketListView)ticketList;
        this.setCollapsed(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.createPaymentStatusFilterPanel();
        this.createOrderTypeFilterPanel();
        this.createMyTicketPanel();
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
    }

    private void createPaymentStatusFilterPanel() {
        this.btnFilterByOpenStatus = new POSToggleButton(PaymentStatusFilter.OPEN.getDisplayString());
        this.btnFilterByOpenStatus.setActionCommand(PaymentStatusFilter.OPEN.name());
        this.btnFilterByUnPaidStatus = new POSToggleButton(PaymentStatusFilter.CLOSED.getDisplayString());
        this.btnFilterByUnPaidStatus.setActionCommand(PaymentStatusFilter.CLOSED.name());
        ButtonGroup paymentGroup = new ButtonGroup();
        paymentGroup.add(this.btnFilterByOpenStatus);
        paymentGroup.add(this.btnFilterByUnPaidStatus);
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        switch (paymentStatusFilter) {
            case OPEN: {
                this.btnFilterByOpenStatus.setSelected(true);
                break;
            }
            case CLOSED: {
                this.btnFilterByUnPaidStatus.setSelected(true);
            }
        }
        ActionListener psFilterHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                String filter = actionCommand.replaceAll("\\s", "_");
                TerminalConfig.setPaymentStatusFilter(filter);
                OrderFilterPanel.this.doUpdateTicketList();
            }
        };
        this.btnFilterByOpenStatus.addActionListener(psFilterHandler);
        this.btnFilterByUnPaidStatus.addActionListener(psFilterHandler);
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout("ins 5", "fill, grow", ""));
        filterPanel.setPreferredSize(PosUIManager.getSize(200, 60));
        filterPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.3")));
        filterPanel.add(this.btnFilterByOpenStatus);
        filterPanel.add(this.btnFilterByUnPaidStatus);
        this.getContentPane().add((Component)filterPanel, "West");
    }

    private void createOrderTypeFilterPanel() {
        OrderTypeFilterButton btnFilterByOrderTypeALL = new OrderTypeFilterButton(null);
        HorizontalTouchScrollPanel filterByOrderPanel = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("fill, ins 0", "fill, grow", ""));
        ButtonGroup orderTypeGroup = new ButtonGroup();
        orderTypeGroup.add(btnFilterByOrderTypeALL);
        ((Container)filterByOrderPanel).add(btnFilterByOrderTypeALL);
        List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
        for (OrderType orderType : orderTypes) {
            OrderTypeFilterButton orderTypeFilterButton = new OrderTypeFilterButton(orderType);
            orderTypeGroup.add(orderTypeFilterButton);
            ((Container)filterByOrderPanel).add(orderTypeFilterButton);
        }
        JPanel rootPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("SwitchboardView.4"));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        rootPanel.setBorder(new CompoundBorder(titledBorder, emptyBorder));
        rootPanel.add((Component)((Object)new HorizontalSimpleScrollPane(filterByOrderPanel)));
        this.getContentPane().add(rootPanel);
    }

    private void createMyTicketPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 5", "fill, grow", ""));
        panel.setBorder(new TitledBorder(Messages.getString("OrderFilterPanel.7")));
        POSToggleButton btnMyTickets = new POSToggleButton(POSConstants.MY_TICKETS);
        panel.add(btnMyTickets);
        btnMyTickets.setSelected(TerminalConfig.isFilterByOwner());
        btnMyTickets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    TerminalConfig.setFilterByOwner(true);
                    OrderFilterPanel.this.doUpdateTicketList();
                } else {
                    TerminalConfig.setFilterByOwner(false);
                    OrderFilterPanel.this.doUpdateTicketList();
                }
            }
        });
        panel.setPreferredSize(PosUIManager.getSize(200, 60));
        this.getContentPane().add((Component)panel, "East");
    }

    private void doUpdateTicketList() {
        this.ticketList.updateTicketList();
        this.ticketLists.updateButtonStatus();
    }

    private class OrderTypeFilterButton
    extends POSToggleButton
    implements ActionListener {
        public OrderTypeFilterButton(OrderType orderType) {
            String orderTypeFilter = TerminalConfig.getOrderTypeFilter();
            if (orderType != null) {
                if (orderTypeFilter.equals(orderType.getId())) {
                    this.setSelected(true);
                }
                this.setText(orderType.getName());
                this.setActionCommand(orderType.getId());
            } else {
                if (orderTypeFilter.equals(POSConstants.ALL)) {
                    this.setSelected(true);
                }
                this.setText(POSConstants.ALL);
                this.setActionCommand(POSConstants.ALL);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setSelected(true);
            String actionCommand = e.getActionCommand();
            TerminalConfig.setOrderTypeFilter(actionCommand);
            OrderFilterPanel.this.doUpdateTicketList();
        }
    }
}

