/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.AttributeEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class AttributesSelectionDialog
extends POSDialog {
    private JXTable table;
    private BeanTableModel<Attribute> tableModel;
    private Attribute selectedAttribute;
    private List<Attribute> attributes;
    private boolean singleGroupSelection;

    public AttributesSelectionDialog(List<Attribute> existingAttributes) {
        super(POSUtil.getFocusedWindow(), "");
        this.init();
        List<Attribute> attributeList = AttributeDAO.getInstance().findAll();
        if (existingAttributes != null) {
            for (Attribute attribute : attributeList) {
                if (!existingAttributes.contains(attribute)) continue;
                attribute.setEnable(true);
            }
        }
        this.tableModel.setRows(attributeList);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("AttributesSelectionDialog.1"));
        TitlePanel titelpanel = new TitlePanel();
        titelpanel.setTitle(Messages.getString("AttributesSelectionDialog.2"));
        this.add((Component)titelpanel, "North");
        this.tableModel = new BeanTableModel<Attribute>(Attribute.class){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Attribute attribute;
                if (columnIndex == 1 && (attribute = (Attribute)AttributesSelectionDialog.this.tableModel.getRow(rowIndex)) != null) {
                    return attribute.getGroup() + ": " + attribute.getName();
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        };
        this.tableModel.addColumn("", "enable");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setShowGrid(true, false);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    AttributesSelectionDialog.this.editSelectedRow();
                } else {
                    AttributesSelectionDialog.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        contentPanel.add(new JScrollPane((Component)this.table));
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        this.add((Component)this.createButtonPanel(), "South");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        JButton btnOk = new JButton(Messages.getString("AttributesSelectionDialog.5"));
        btnOk.setHorizontalTextPosition(4);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesSelectionDialog.this.doOk();
            }
        });
        JButton btnCancel = new JButton(POSConstants.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesSelectionDialog.this.setCanceled(true);
                AttributesSelectionDialog.this.dispose();
            }
        });
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Attribute attribute = new Attribute();
                    AttributeEntryForm editor = new AttributeEntryForm(attribute);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Attribute foodItem = (Attribute)editor.getBean();
                    AttributesSelectionDialog.this.tableModel.addRow(foodItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        btnOk.setBackground(Color.GREEN);
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0 0 5 0", "sg,fill", ""));
        int h = PosUIManager.getSize(40);
        panel.add((Component)btnAdd, "h " + h);
        panel.add((Component)btnEdit, "h " + h);
        panel.add((Component)btnOk, "h " + h);
        panel.add((Component)btnCancel, "h " + h);
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(50);
        columnWidth.add(250);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Attribute attribute = this.tableModel.getRow(index);
            this.tableModel.setRow(index, attribute);
            AttributeEntryForm editor = new AttributeEntryForm(attribute);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doOk() {
        try {
            this.attributes = new ArrayList<Attribute>();
            List<Attribute> modifierList = this.tableModel.getRows();
            for (Attribute attribute : modifierList) {
                if (!attribute.isEnable().booleanValue()) continue;
                this.attributes.add(attribute);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public Attribute getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public List<Attribute> getSelectedAttributeList() {
        return this.attributes;
    }

    public void setSelectedAttribute(Attribute selectedAttribute) {
        this.selectedAttribute = selectedAttribute;
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        Attribute attribute = this.tableModel.getRow(selectedRow);
        if (this.singleGroupSelection && !attribute.isEnable().booleanValue()) {
            for (Attribute att : this.tableModel.getRows()) {
                if (att.getGroup() != attribute.getGroup()) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("AttributesSelectionDialog.13") + att.getName() + Messages.getString("AttributesSelectionDialog.14") + att.getGroup());
                return;
            }
        }
        attribute.setEnable(attribute.isEnable() == false);
        this.table.repaint();
    }

    public void setSingleGroupSelection(boolean b) {
        this.singleGroupSelection = b;
    }
}

