/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.ScrollableContainer;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.hibernate.StaleStateException;

public class BeanEditorDialog
extends JDialog {
    protected BeanEditor beanEditor;
    private boolean canceled = true;
    private boolean showSaveButton = false;
    private TransparentPanel beanEditorContainer;
    private PosSmallButton btnCancel;
    private PosSmallButton btnOk;
    private PosSmallButton btnSave;
    private TransparentPanel jPanel1;
    private TransparentPanel buttonPanel;
    private JSeparator jSeparator1;
    private TitlePanel titlePanel;

    public BeanEditorDialog() {
        this((BeanEditor)null);
    }

    public BeanEditorDialog(Window parent, BeanEditor beanEditor) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setBeanEditor(beanEditor);
        this.addCloseHandler();
    }

    public BeanEditorDialog(Window parent, BeanEditor beanEditor, boolean showSaveButton) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.showSaveButton = showSaveButton;
        this.initComponents();
        this.setBeanEditor(beanEditor);
    }

    public BeanEditorDialog(BeanEditor beanEditor) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setBeanEditor(beanEditor);
        this.addCloseHandler();
    }

    public BeanEditorDialog(Frame owner, BeanEditor beanEditor) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setBeanEditor(beanEditor);
        this.addCloseHandler();
    }

    public BeanEditorDialog(Frame owner, BeanEditor beanEditor, boolean showSaveButton) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.showSaveButton = showSaveButton;
        this.initComponents();
        this.setBeanEditor(beanEditor);
        this.addCloseHandler();
    }

    private void initComponents() {
        this.setTitle(VersionInfo.getAppName());
        this.titlePanel = new TitlePanel();
        this.jPanel1 = new TransparentPanel();
        this.jSeparator1 = new JSeparator();
        this.buttonPanel = new TransparentPanel();
        this.btnSave = new PosSmallButton();
        this.btnSave.setVisible(this.showSaveButton);
        this.btnOk = new PosSmallButton();
        this.btnCancel = new PosSmallButton();
        this.beanEditorContainer = new TransparentPanel(new BorderLayout());
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.jSeparator1, "North");
        this.buttonPanel.setLayout(new FlowLayout());
        this.btnSave.setText(POSConstants.SAVE);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditorDialog.this.doPerformSave();
            }
        });
        this.btnOk.setText(POSConstants.OK);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BeanEditorDialog.this.performOk();
            }
        });
        this.btnCancel.setText(POSConstants.CANCEL);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BeanEditorDialog.this.performCancel();
            }
        });
        this.buttonPanel.add(this.btnSave);
        this.buttonPanel.add(this.btnOk);
        this.buttonPanel.add(this.btnCancel);
        this.jPanel1.add((Component)this.buttonPanel, "Center");
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.beanEditorContainer.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.beanEditorContainer, "Center");
    }

    @Override
    public void dispose() {
        if (this.beanEditor != null) {
            this.beanEditor = null;
        }
        super.dispose();
    }

    public void disposeWithNotCancelled() {
        if (this.beanEditor != null) {
            this.beanEditor = null;
        }
        this.setCancel(false);
        super.dispose();
    }

    private void addCloseHandler() {
        ActionListener escapeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanEditorDialog.this.canceled = true;
                BeanEditorDialog.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void doPerformSave() {
        try {
            if (this.beanEditor.save()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("BeanEditorDialog.0"));
            }
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.beanEditor);
        }
        catch (Exception exception) {
            String message = Messages.getString("BeanEditorDialog.1");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, exception);
        }
    }

    private void performCancel() {
        this.canceled = true;
        this.dispose();
    }

    private void performOk() {
        try {
            if (this.beanEditor == null) {
                return;
            }
            boolean saved = this.beanEditor.save();
            if (saved) {
                this.canceled = false;
                this.dispose();
            }
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.beanEditor);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("BeanEditorDialog.2"), e);
        }
    }

    public void open() {
        this.canceled = true;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        super.setVisible(true);
    }

    public void openFullScreen() {
        this.canceled = true;
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public void openWithScale(int w, int h) {
        this.canceled = true;
        this.setSize(PosUIManager.getSize(w, h));
        this.setLocationRelativeTo(this.getOwner());
        super.setVisible(true);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCancel(boolean isCancel) {
        this.canceled = isCancel;
    }

    public Frame getParentFrame() {
        return (Frame)this.getOwner();
    }

    public BeanEditor getBeanEditor() {
        return this.beanEditor;
    }

    public Object getBean() {
        if (this.beanEditor != null) {
            return this.beanEditor.getBean();
        }
        return null;
    }

    public void setBean(Object bean) {
        if (this.beanEditor != null) {
            this.beanEditor.setBean(bean);
        }
    }

    public void setBeanEditor(BeanEditor beanEditor) {
        if (this.beanEditor != beanEditor) {
            this.beanEditor = beanEditor;
            this.beanEditorContainer.removeAll();
            if (beanEditor != null) {
                beanEditor.setEditorDialog(this);
                if (beanEditor instanceof ScrollableContainer) {
                    JScrollPane scrollPane = new JScrollPane(beanEditor);
                    scrollPane.setBorder(null);
                    this.beanEditorContainer.add(scrollPane);
                } else {
                    this.beanEditorContainer.add(beanEditor);
                }
                this.titlePanel.setTitle(beanEditor.getDisplayText());
            }
            this.beanEditorContainer.revalidate();
        }
    }

    public TransparentPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setOkButtonVisible(boolean isVisible) {
        this.btnOk.setVisible(isVisible);
    }
}

