/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StoreSessionReportAction;
import com.floreantpos.actions.UploadPaymentSyncableAction;
import com.floreantpos.config.ui.CloudSyncConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SFSyncDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportHistoryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UploadSfTicketsDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class DrawerAndStaffBankReportDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JTable tableDrawerReport;
    private DrawerReportTableModel tableModel;
    private List<CashDrawer> drawerPullReportList;
    private DefaultListSelectionModel selectionModel;
    private PosButton btnReportHistory;
    private PosButton btnCloseStore;
    private User user;
    private Terminal currentTerminal;

    public DrawerAndStaffBankReportDialog(User user) {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle("Store status");
        this.user = user;
        this.initComponents();
        this.initData();
    }

    public void initData() {
        this.currentTerminal = Application.getInstance().getTerminal();
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.tableDrawerReport.getSelectionModel().setSelectionMode(0);
        this.tableDrawerReport.setDefaultRenderer(Object.class, new TableRenderer());
        this.tableModel = new DrawerReportTableModel();
        this.tableDrawerReport.setModel(this.tableModel);
        this.updateView();
        boolean hasStoreAccess = StoreUtil.isStoreOpen() && this.user.hasPermission(UserPermission.OPEN_CLOSE_STORE);
        this.btnCloseStore.setVisible(hasStoreAccess);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = Integer.parseInt(e.getActionCommand());
                    CashDrawer pullReport = (CashDrawer)DrawerAndStaffBankReportDialog.this.tableModel.getRowData(row);
                    if (pullReport.getId() != null) {
                        DrawerAndStaffBankReportDialog.this.showReport(pullReport);
                    } else {
                        if (!DrawerAndStaffBankReportDialog.this.user.isClockedIn().booleanValue()) {
                            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "You are not clockd in.\n Please clock in first to assign drawer.");
                            return;
                        }
                        DrawerAssignmentAction action = new DrawerAssignmentAction(pullReport.getTerminal(), DrawerAndStaffBankReportDialog.this.user);
                        action.execute();
                    }
                    DrawerAndStaffBankReportDialog.this.updateView();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(e2.getMessage(), e2);
                }
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.tableDrawerReport, action, 3){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(5, 15, 5, 15, this.tableDrawerReport.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(5, 15, 5, 15, this.tableDrawerReport.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnCloseStore.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnCloseStore.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        this.resizeTableColumns();
    }

    private void updateView() {
        StoreSession currentStoreOperationData = DataProvider.get().getStoreSession();
        if (currentStoreOperationData == null) {
            return;
        }
        this.drawerPullReportList = new ArrayList<CashDrawer>();
        List<Terminal> terminalList = TerminalDAO.getInstance().findCashDrawerTerminals();
        List<CashDrawer> drawerStatusList = CashDrawerDAO.getInstance().findByStoreOperationData(currentStoreOperationData, true);
        for (CashDrawer cashDrawer : drawerStatusList) {
            if (cashDrawer.getReportTime() != null) continue;
            this.drawerPullReportList.add(cashDrawer);
        }
        for (Terminal terminal : terminalList) {
            if (terminal.getCurrentCashDrawer() != null) continue;
            CashDrawer toBeAssignedPullReport = new CashDrawer();
            toBeAssignedPullReport.setTerminal(terminal);
            toBeAssignedPullReport.setAssignedUser(this.user);
            this.drawerPullReportList.add(toBeAssignedPullReport);
        }
        this.tableModel.setRows(this.drawerPullReportList);
        this.tableModel.fireTableDataChanged();
    }

    private void resizeTableColumns() {
        this.tableDrawerReport.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(2, PosUIManager.getSize(150));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.tableDrawerReport.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void initComponents() {
        TransparentPanel container = new TransparentPanel();
        this.titlePanel = new TitlePanel();
        TransparentPanel contentPanel = new TransparentPanel();
        TransparentPanel bottomActionPanel = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator1 = new JSeparator();
        PosButton btnOK = new PosButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.tableDrawerReport = new JTable();
        this.tableDrawerReport.setRowHeight(PosUIManager.getSize(40));
        this.tableDrawerReport.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jSeparator1, "North");
        PosButton btnPostPayments = new PosButton("UPLOAD PAYMENTS");
        btnPostPayments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<TicketItem> unsyncedTicketItems = SFSyncDAO.getInstance().findUnsyncedItems();
                List<Gratuity> unsyncedGratuities = SFSyncDAO.getInstance().findUnsyncedGratuities();
                List<PosTransaction> unsyncedTransactions = SFSyncDAO.getInstance().findUnsyncedTransactions();
                ArrayList<Object> unsyncedItems = new ArrayList<Object>();
                unsyncedItems.addAll(unsyncedTicketItems);
                unsyncedItems.addAll(unsyncedGratuities);
                unsyncedItems.addAll(unsyncedTransactions);
                UploadSfTicketsDialog paymentDialog = new UploadSfTicketsDialog(DrawerAndStaffBankReportDialog.this.user, unsyncedItems);
                paymentDialog.openFullScreen();
            }
        });
        PosButton btnSessionReport = new PosButton("REPORT");
        btnSessionReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionReportAction action = new StoreSessionReportAction(DataProvider.get().getStoreSession());
                action.execute();
            }
        });
        this.btnReportHistory = new PosButton("HISTORY");
        this.btnReportHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerAndStaffBankReportHistoryDialog dialog = new DrawerAndStaffBankReportHistoryDialog(Application.getPosWindow(), DrawerAndStaffBankReportDialog.this.user, DataProvider.get().getStoreSession());
                dialog.setInfo("Cash drawer and staff bank history");
                dialog.setSize(PosUIManager.getSize(880, 580));
                dialog.open();
            }
        });
        this.btnCloseStore = new PosButton("CLOSE STORE");
        this.btnCloseStore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerAndStaffBankReportDialog.this.doCloseStore();
            }
        });
        bottomActionPanel.add(btnPostPayments);
        bottomActionPanel.add(btnSessionReport);
        bottomActionPanel.add(this.btnReportHistory);
        bottomActionPanel.add(this.btnCloseStore);
        btnOK.setText(POSConstants.SAVE_BUTTON_TEXT);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerAndStaffBankReportDialog.this.btnCloseActionPerformed(evt);
            }
        });
        bottomActionPanel.add(btnOK);
        container.add((Component)bottomActionPanel, "Center");
        this.getContentPane().add((Component)container, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.titlePanel, "North");
        jScrollPane1.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 15, 10, 15), jScrollPane1.getBorder()));
        jScrollPane1.setViewportView(this.tableDrawerReport);
        contentPanel.add((Component)jScrollPane1, "Center");
        this.getContentPane().add((Component)contentPanel, "Center");
        this.setSize(PosUIManager.getSize(830, 550));
    }

    private void showReport(CashDrawer report) {
        if (report == null) {
            return;
        }
        if (report.getDrawerType() == DrawerType.STAFF_BANK) {
            this.showBankStatus(report);
        } else {
            this.showDrawerStatus(report);
        }
    }

    private void doCloseStore() {
        try {
            List<User> clockInUsers;
            boolean hasClockedInUser;
            int option;
            if (!this.user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage("You are not clocked in.\nPlease clock in first to close the store.");
                return;
            }
            if (PosTransactionDAO.getInstance().hasUnauthorizedTransactions(null).booleanValue() && (option = POSMessageDialog.showYesNoQuestionDialog(this, "There are transactions that are not captured yet. Are you sure to close store?", "Confirm")) != 0) {
                return;
            }
            StoreSession currentData = DataProvider.get().getStoreSession();
            List<CashDrawer> reportList = CashDrawerDAO.getInstance().findByStoreOperationData(currentData, true);
            if (reportList != null) {
                for (CashDrawer report : reportList) {
                    if (report.getReportTime() != null) continue;
                    String message = "Not all cash drawers/staff banks are closed. Please close them first.";
                    POSMessageDialog.showMessage(this, message);
                    return;
                }
            }
            boolean bl = hasClockedInUser = (clockInUsers = UserDAO.getInstance().findClockedInUsers()) != null && clockInUsers.size() > 0;
            if (hasClockedInUser && clockInUsers.size() == 1) {
                boolean bl2 = hasClockedInUser = !clockInUsers.get(0).getId().equals(this.user.getId());
            }
            if (hasClockedInUser) {
                String message = "Not all users are cloked out. Please clocked out all users first.";
                POSMessageDialog.showMessage(this, message);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(this, "Are you sure you want to close store?", "Confirm") != 0) {
                return;
            }
            this.doUploadPaymentSync(currentData);
            if (this.user.isClockedIn().booleanValue()) {
                this.doClockedOutUser(this.user);
            }
            currentData.setCloseTime(new Date());
            currentData.setClosedBy(this.user);
            StoreUtil.closeStore(this.user);
            this.printEndOfDayReport(currentData);
            String msg = "Store is closed";
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                this.printEndOfDayReport(currentData);
            }
            this.dispose();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void printEndOfDayReport(StoreSession currentData) {
        try {
            PosPrintService.printCashDrawerReportSummary(currentData);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doUploadPaymentSync(StoreSession currentData) {
        Store store = Application.getInstance().getStore();
        if (!store.isAutoSyncCharges()) {
            return;
        }
        List<TicketItem> unsyncedTicketItems = SFSyncDAO.getInstance().findUnsyncedItems();
        List<Gratuity> unsyncedGratuities = SFSyncDAO.getInstance().findUnsyncedGratuities();
        List<PosTransaction> unsyncedTransactions = SFSyncDAO.getInstance().findUnsyncedTransactions();
        CloudSyncConfigurationView.createEvenExchangeData(unsyncedTicketItems, unsyncedTransactions);
        ArrayList<Object> unsyncedItems = new ArrayList<Object>();
        unsyncedItems.addAll(unsyncedTicketItems);
        unsyncedItems.addAll(unsyncedGratuities);
        unsyncedItems.addAll(unsyncedTransactions);
        UploadPaymentSyncableAction action = new UploadPaymentSyncableAction(unsyncedItems);
        action.execute();
    }

    private void createEvenExchangeData(List<TicketItem> unsyncedTicketItems, List<PosTransaction> unsyncedTransactions) {
        HashMap zeroCostTransactions = new HashMap();
        Iterator<TicketItem> iterator = unsyncedTicketItems.iterator();
        while (iterator.hasNext()) {
            TicketItem ticketItem = iterator.next();
            if (!ticketItem.isVoided().booleanValue()) continue;
            iterator.remove();
            Ticket ticket = ticketItem.getTicket();
            if (zeroCostTransactions.containsKey(ticket) || ticket.getTotalAmount() != 0.0) continue;
            PosTransaction posTransaction = PaymentType.MEMBER_ACCOUNT.createTransaction();
            posTransaction.setTicket(ticket);
            posTransaction.setTransactionTime(ticketItem.getCreateDate());
            unsyncedTransactions.add(posTransaction);
        }
    }

    private void doClockedOutUser(User user) {
        try {
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                Date lastClockInTime = user.getLastClockInTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockInTime);
                attendenceHistory.setClockInTime(lastClockInTime);
                attendenceHistory.setClockInHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, shift, calendar);
            String m1 = Messages.getString("ClockInOutAction.8");
            String m2 = Messages.getString("ClockInOutAction.10");
            POSMessageDialog.showMessage(m1 + " " + user.getFirstName() + " " + user.getLastName() + m2);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void showBankStatus(CashDrawer report) {
        try {
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.user, report);
            dialog.setTitle(report.getDrawerType() == DrawerType.STAFF_BANK ? "BANK STATUS" : POSConstants.DRAWER_PULL_BUTTON_TEXT);
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.openFullScreen();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void showDrawerStatus(CashDrawer report) {
        try {
            if (report.getTerminal() == null) {
                return;
            }
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.user, report);
            dialog.setTitle(POSConstants.DRAWER_PULL_BUTTON_TEXT);
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.openFullScreen();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void setInfo(String info) {
        this.titlePanel.setTitle(info);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CashDrawer t;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            if (column == 0 && (t = (CashDrawer)DrawerAndStaffBankReportDialog.this.drawerPullReportList.get(row)).getDrawerType() != DrawerType.STAFF_BANK && t.getTerminal().getId().intValue() == DrawerAndStaffBankReportDialog.this.currentTerminal.getId().intValue()) {
                label.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
            }
            if (value instanceof Date) {
                String string = this.dateFormat.format(value);
                label.setText(string);
                label.setHorizontalAlignment(4);
            }
            if (value instanceof Double) {
                label.setHorizontalAlignment(4);
            } else {
                label.setHorizontalAlignment(2);
            }
            if (column == 1 || column == 2) {
                label.setHorizontalAlignment(0);
            }
            return label;
        }
    }

    class DrawerReportTableModel
    extends ListTableModel<CashDrawer> {
        public DrawerReportTableModel() {
            super(new String[]{"Drawer/Staff Bank Name", "Type", "Status", ""});
        }

        @Override
        public int getRowCount() {
            if (DrawerAndStaffBankReportDialog.this.drawerPullReportList == null) {
                return 0;
            }
            int size = DrawerAndStaffBankReportDialog.this.drawerPullReportList.size();
            return size;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        public CashDrawer getSelectedRow() {
            int index = DrawerAndStaffBankReportDialog.this.tableDrawerReport.getSelectedRow();
            if (index < 0) {
                return null;
            }
            index = DrawerAndStaffBankReportDialog.this.tableDrawerReport.convertRowIndexToModel(index);
            return (CashDrawer)DrawerAndStaffBankReportDialog.this.tableModel.getRowData(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (DrawerAndStaffBankReportDialog.this.drawerPullReportList == null) {
                return "";
            }
            CashDrawer t = (CashDrawer)DrawerAndStaffBankReportDialog.this.drawerPullReportList.get(rowIndex);
            User assignedUser = t.getAssignedUser();
            switch (columnIndex) {
                case 0: {
                    if (t.getDrawerType() == DrawerType.DRAWER) {
                        return "Terminal - " + t.getTerminal();
                    }
                    return t.getAssignedUser();
                }
                case 1: {
                    return t.getDrawerType().toString();
                }
                case 2: {
                    if (t.getId() == null) {
                        return "NOT ASSIGNED";
                    }
                    if (assignedUser != null) {
                        return t.getReportTime() == null ? "ASSIGNED" : "CLOSED";
                    }
                }
                case 3: {
                    if (t.getId() == null) {
                        return "ASSIGN";
                    }
                    return "STATUS";
                }
            }
            return "";
        }
    }
}

