/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSFileChooser;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    private ImageResource.IMAGE_CATEGORY imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    private JLabel lblImagePreview;
    private JLabel lblDescription;
    private ImageResource imgResource;
    private POSTextField tfDescription;
    private POSToggleButton tbtnUnlisted;
    private POSToggleButton tbtnFloorPlan;
    private POSToggleButton tbtnProducts;
    private POSToggleButton tbtnPeople;
    private JPanel imagePanel;
    private ArrayList<byte[]> imageList;
    private boolean isMultipleSelection;
    private JProgressBar progressBar;
    private JLabel lblProgressing;
    private PosButton btnSelect;
    private POSFileChooser fileChooserWithPreview = null;
    boolean cancel = false;

    public ImageUploaderDialog(ImageResource imgResource, ImageResource.IMAGE_CATEGORY defaultCategory) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imageType = defaultCategory;
        this.imgResource = imgResource;
        this.init();
        this.updateView();
    }

    public ImageUploaderDialog(ImageResource imgResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imgResource = imgResource;
        this.init();
        this.updateView();
    }

    public ImageUploaderDialog(ImageResource.IMAGE_CATEGORY defaultCategory) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imageType = defaultCategory;
        this.init();
        this.updateView();
        this.isMultipleSelection = true;
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.init();
        this.updateView();
        this.isMultipleSelection = true;
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ImageUploaderDialog.1"));
        this.add((Component)titlePanel, "North");
        JPanel filterPanel = new JPanel();
        ButtonGroup btnGroup = new ButtonGroup();
        this.tbtnUnlisted = new POSToggleButton(Messages.getString("ImageUploaderDialog.2"));
        this.tbtnFloorPlan = new POSToggleButton(Messages.getString("ImageUploaderDialog.3"));
        this.tbtnProducts = new POSToggleButton(Messages.getString("ImageUploaderDialog.4"));
        this.tbtnPeople = new POSToggleButton(Messages.getString("ImageUploaderDialog.5"));
        btnGroup.add(this.tbtnUnlisted);
        btnGroup.add(this.tbtnFloorPlan);
        btnGroup.add(this.tbtnProducts);
        btnGroup.add(this.tbtnPeople);
        filterPanel.add(this.tbtnUnlisted);
        filterPanel.add(this.tbtnFloorPlan);
        filterPanel.add(this.tbtnProducts);
        filterPanel.add(this.tbtnPeople);
        this.tbtnProducts.setEnabled(true);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setBorder(new EmptyBorder(20, 5, 20, 5));
        centerPanel.add((Component)filterPanel, "North");
        this.lblImagePreview = new JLabel();
        this.lblDescription = new JLabel(Messages.getString("ImageUploaderDialog.6"));
        this.tfDescription = new POSTextField(50);
        this.imagePanel = new JPanel(new FlowLayout());
        this.imagePanel.add((Component)this.lblImagePreview, "center");
        JScrollPane scrollPane = new JScrollPane(this.imagePanel, 20, 30);
        scrollPane.setPreferredSize(new Dimension(350, 220));
        scrollPane.setVisible(true);
        centerPanel.add(scrollPane);
        JPanel desPanel = new JPanel();
        desPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        desPanel.setLayout(new BorderLayout(5, 0));
        desPanel.add((Component)this.lblDescription, "West");
        desPanel.add((Component)this.tfDescription, "Center");
        centerPanel.add((Component)desPanel, "South");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(40, 40, 160, 30);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.btnSelect = new PosButton(Messages.getString("ImageUploaderDialog.11"));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ImageUploaderDialog.this.isMultipleSelection) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException e1) {
                    POSMessageDialog.showError(e1.getMessage());
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(e2.getMessage(), e2);
                }
            }
        });
        PosButton btnOk = new PosButton(Messages.getString("ImageUploaderDialog.15"));
        btnOk.setPreferredSize(PosUIManager.getSize(100, 0));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton btnCancel = new PosButton(Messages.getString("ImageUploaderDialog.16"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.lblProgressing = new JLabel(Messages.getString("ImageUploaderDialog.17"));
        this.lblProgressing.setVisible(false);
        buttonPanel.add((Component)this.btnSelect, "");
        buttonPanel.add((Component)this.lblProgressing, "left,split 2");
        buttonPanel.add((Component)this.progressBar, "");
        buttonPanel.add((Component)btnOk, "growy,right,skip 2, split 2");
        buttonPanel.add((Component)btnCancel, "");
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void doOk() {
        if (!this.isMultipleSelection) {
            this.doSaveSingleImage();
            ImageResourceDAO.getInstance().saveOrUpdate(this.imgResource);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void doSaveSingleImage() {
        try {
            byte[] imageByte;
            if (this.imgResource == null) {
                this.imgResource = new ImageResource();
            }
            if ((imageByte = (byte[])this.lblImagePreview.getClientProperty("image")) != null) {
                this.imgResource.setImageBytes(imageByte);
            }
            this.imgResource.setDescription(this.tfDescription.getText());
            if (this.tbtnUnlisted.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.tbtnFloorPlan.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.tbtnPeople.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.tbtnProducts.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            } else {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception e) {
            PosLog.error(ImageUploaderDialog.class, e.getMessage(), e);
        }
    }

    public void doSaveMultipleImage() {
        try {
            ArrayList<ImageResource> imageResourceList = new ArrayList<ImageResource>();
            for (byte[] file : this.imageList) {
                this.imgResource = new ImageResource();
                if (file != null) {
                    this.imgResource.setImageBytes(file);
                }
                if (this.tbtnUnlisted.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.tbtnFloorPlan.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.tbtnPeople.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.tbtnProducts.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                } else {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                imageResourceList.add(this.imgResource);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(imageResourceList);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void selectBulkImage() throws Exception {
        Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
        this.fileChooserWithPreview = LAST_USED_FOLDER != null ? new POSFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.fileChooserWithPreview.setMultiSelectionEnabled(true);
        this.fileChooserWithPreview.setFileSelectionMode(2);
        this.fileChooserWithPreview.setAcceptAllFileFilterUsed(false);
        int option = this.fileChooserWithPreview.showOpenDialog(POSUtil.getFocusedWindow());
        this.imageList = new ArrayList();
        if (option == 0) {
            File[] selectedFiles;
            for (File file : selectedFiles = this.fileChooserWithPreview.getSelectedFiles()) {
                if (file.isDirectory()) {
                    File[] f = file.listFiles();
                    for (int i = 0; i < f.length; ++i) {
                        if (f[i].isDirectory()) {
                            this.addFileIfImageType(f[i]);
                            continue;
                        }
                        this.addFileIfImageType(f[i]);
                    }
                    continue;
                }
                this.addFileIfImageType(file);
            }
        } else {
            return;
        }
        this.setCanceled(false);
    }

    public void showImages() {
        if (!this.isMultipleSelection) {
            this.progressBar.setVisible(false);
            return;
        }
        this.progressBar.setVisible(true);
        this.btnSelect.setVisible(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageUploaderDialog.this.cancel) {
                        return;
                    }
                    int i = 1;
                    ImageUploaderDialog.this.progressBar.setMaximum(ImageUploaderDialog.this.imageList.size());
                    ImageUploaderDialog.this.lblProgressing.setVisible(true);
                    for (byte[] file : ImageUploaderDialog.this.imageList) {
                        JLabel lblImagePreview = new JLabel();
                        lblImagePreview.putClientProperty("image", file);
                        try (ByteArrayInputStream bis = new ByteArrayInputStream(file);){
                            BufferedImage rImage = ImageIO.read(bis);
                            ImageIcon imageIcon = new ImageIcon(ImageUploaderDialog.doScaleImageWithRatio(rImage, false, rImage.getWidth(), rImage.getHeight()));
                            lblImagePreview.setIcon(imageIcon);
                            ImageUploaderDialog.this.imagePanel.add(lblImagePreview);
                            ImageUploaderDialog.this.imagePanel.revalidate();
                            ImageUploaderDialog.this.imagePanel.repaint();
                        }
                        Thread.sleep(500L);
                        ImageUploaderDialog.this.progressBar.setValue(i);
                        ++i;
                    }
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e);
                }
            }
        });
    }

    private void addFileIfImageType(File file) throws Exception {
        String extension = this.getExtension(file.toString());
        if (this.getValidImageExtensions().contains(extension.trim().toLowerCase())) {
            int imageSize;
            BufferedImage image = ImageIO.read(file);
            byte[] byteImage = ImageUploaderDialog.convertImageToByteArray(image);
            if (byteImage != null && (imageSize = byteImage.length / 1024) > 500 && (byteImage = ImageUploaderDialog.convertImageToByteArray(image = ImageUploaderDialog.doScaleImageWithRatio(image, false, image.getWidth(), image.getHeight()))) != null && (imageSize = byteImage.length / 1024) > 500) {
                throw new PosException(Messages.getString("ImageUploaderDialog.0"));
            }
            this.imageList.add(byteImage);
        }
    }

    private String getExtension(String filename) {
        int afterLastBackslash;
        if (filename == null) {
            return null;
        }
        String afterLastSlash = filename.substring(filename.lastIndexOf(47) + 1);
        int dotIndex = afterLastSlash.indexOf(46, afterLastBackslash = afterLastSlash.lastIndexOf(92) + 1);
        return dotIndex == -1 ? "" : afterLastSlash.substring(dotIndex + 1);
    }

    private List<String> getValidImageExtensions() {
        return Arrays.asList("jpg", "jpeg", "png", "gif");
    }

    public void selectImage() throws Exception {
        Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
        this.fileChooserWithPreview = LAST_USED_FOLDER != null ? new POSFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.fileChooserWithPreview.setMultiSelectionEnabled(false);
        this.fileChooserWithPreview.setFileSelectionMode(0);
        int option = this.fileChooserWithPreview.showOpenDialog(POSUtil.getFocusedWindow());
        if (option == 0) {
            File imageFile = this.fileChooserWithPreview.getSelectedFile();
            prefs.put(LAST_USED_FOLDER, imageFile.getPath());
            byte[] itemImageByte = FileUtils.readFileToByteArray((File)imageFile);
            if (itemImageByte != null) {
                int imageSizeInKb = itemImageByte.length / 1024;
                BufferedImage image = ImageIO.read(imageFile);
                if (imageSizeInKb > 500 && (itemImageByte = ImageUploaderDialog.convertImageToByteArray(image = ImageUploaderDialog.doScaleImageWithRatio(image, false, image.getWidth(), image.getHeight()))) != null && (imageSizeInKb = itemImageByte.length / 1024) > 500) {
                    throw new PosException(Messages.getString("ImageUploaderDialog.0"));
                }
                this.lblImagePreview.setIcon(new ImageIcon(image));
                this.lblImagePreview.putClientProperty("image", itemImageByte);
                this.lblImagePreview.setText("");
                this.setCanceled(false);
            }
        } else if (option == 1) {
            this.setCanceled(true);
        }
    }

    public static byte[] convertImageToByteArray(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "jpg", baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage doScaleImageWithRatio(Image image, boolean reduceSize, int width, int height) throws IOException {
        if (reduceSize) {
            if (width > height) {
                height = height * (width -= 100) / width;
            } else {
                width = width * (height -= 100) / height;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        byte[] byteArray = ImageUploaderDialog.convertImageToByteArray(bufferedImage);
        if (byteArray.length / 1024 > 500) {
            bufferedImage = null;
            byteArray = null;
            return ImageUploaderDialog.doScaleImageWithRatio(image, true, width, height);
        }
        return bufferedImage;
    }

    private void updateView() {
        if (this.imgResource != null && this.imgResource.getImageCategory() != null) {
            this.imageType = this.imgResource.getImageCategory();
        }
        if (this.imageType == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.tbtnUnlisted.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.tbtnFloorPlan.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.tbtnProducts.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.tbtnPeople.setSelected(true);
        } else {
            this.tbtnProducts.setSelected(true);
        }
        if (this.imgResource == null) {
            return;
        }
        ImageIcon rImage = this.imgResource.getImageIcon();
        if (rImage == null) {
            return;
        }
        this.lblImagePreview.setText("");
        this.lblImagePreview.setIcon(rImage);
        if (this.imgResource.getDescription() != null) {
            this.tfDescription.setText(this.imgResource.getDescription());
        }
    }

    public ImageResource getSelectedImageResourse() {
        return this.imgResource;
    }

    @Override
    public void open() {
        this.showImages();
        super.open();
    }

    public void setDescriptionVisible(boolean isBulkUpload) {
        this.lblDescription.setVisible(isBulkUpload);
        this.tfDescription.setVisible(isBulkUpload);
    }
}

