/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemQtySelectionDialog
extends OkCancelOptionDialog {
    private int defaultValue;
    private JTextField tfNumber;
    private boolean floatingPoint;
    private PosButton incrementQuantitybtn;
    private PosButton decrementQuantitybtn;
    private MenuItem menuItem;
    private List<IUnit> itemUnits;
    private IUnit itemDefaultUnit;
    private IUnit selectedUnit;

    public ItemQtySelectionDialog() {
        super(POSUtil.getFocusedWindow());
        this.init();
    }

    public ItemQtySelectionDialog(boolean allowFlotingPoint, MenuItem menuItem) {
        super(POSUtil.getFocusedWindow());
        this.menuItem = menuItem;
        this.itemUnits = this.menuItem.getUnits();
        this.itemDefaultUnit = this.menuItem.getUnit();
        this.setFloatingPoint(allowFlotingPoint);
        this.init();
    }

    public ItemQtySelectionDialog(boolean allowFlotingPoint, MenuItem menuItem, IUnit itemDefaultUnit) {
        super(POSUtil.getFocusedWindow());
        this.menuItem = menuItem;
        this.itemUnits = this.menuItem.getUnits();
        this.itemDefaultUnit = itemDefaultUnit;
        this.setFloatingPoint(allowFlotingPoint);
        this.init();
    }

    private void init() {
        this.setResizable(false);
        JPanel contentPane = this.getContentPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        this.tfNumber = this.isFloatingPoint(true) ? new DoubleTextField(10) : new IntegerTextField(10);
        this.tfNumber.setHorizontalAlignment(11);
        this.tfNumber.setFont(this.tfNumber.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.tfNumber.setFocusable(true);
        this.tfNumber.requestFocus();
        this.tfNumber.setBackground(Color.WHITE);
        this.incrementQuantitybtn = new PosButton("+");
        this.incrementQuantitybtn.setFont(new Font("Arial", 0, 30));
        this.incrementQuantitybtn.setFocusable(false);
        this.incrementQuantitybtn.setPreferredSize(PosUIManager.getSize(60, 60));
        this.decrementQuantitybtn = new PosButton("-");
        this.decrementQuantitybtn.setPreferredSize(PosUIManager.getSize(60, 60));
        this.decrementQuantitybtn.setFont(new Font("Arial", 1, 30));
        this.decrementQuantitybtn.setFocusable(false);
        JPanel unitPanel = new JPanel(new WrapLayout(3));
        unitPanel.setPreferredSize(PosUIManager.getSize(200, 100));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("SelectUnit"), 2, 0), new EmptyBorder(0, 0, 0, 0));
        unitPanel.setBorder(compoundBorder);
        this.createUnitButtonPanel(unitPanel);
        JPanel firstpanel = new JPanel(new BorderLayout(5, 0));
        firstpanel.add((Component)this.incrementQuantitybtn, "East");
        firstpanel.add((Component)this.tfNumber, "Center");
        firstpanel.add((Component)this.decrementQuantitybtn, "West");
        JPanel secondpanel = new JPanel(new BorderLayout(0, 0));
        secondpanel.add((Component)new NumericKeypad(), "Center");
        JPanel centerContentPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0 0 0 0", "[grow][grow]", ""));
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 7 0 2 0"));
        leftPanel.add((Component)firstpanel, "grow, wrap");
        leftPanel.add((Component)secondpanel, "grow");
        centerContentPanel.add((Component)leftPanel, "grow");
        centerContentPanel.add((Component)unitPanel, "grow");
        contentPane.add((Component)centerContentPanel, "Center");
        this.setControlButtonsVisible(true);
        this.buttonAction();
    }

    private void createUnitButtonPanel(JPanel unitPanel) {
        if (this.itemUnits == null) {
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.itemUnits != null) {
            for (IUnit inventoryUnit : this.itemUnits) {
                UnitButton unitButton = new UnitButton(inventoryUnit);
                buttonGroup.add(unitButton);
                unitPanel.add(unitButton);
            }
        }
    }

    public IUnit getSelectedUnit() {
        return this.selectedUnit;
    }

    @Override
    public void doOk() {
        if (!this.validate(this.tfNumber.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        if ((this.menuItem.isFractionalUnit() == null || !this.menuItem.isFractionalUnit().booleanValue()) && this.isFractional().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("ItemQtySelectionDialog.0"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void buttonAction() {
        try {
            this.incrementQuantitybtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double total;
                    String text = ItemQtySelectionDialog.this.tfNumber.getText();
                    if (StringUtils.isNotEmpty((String)text) && ((total = Double.parseDouble(text)) == Math.floor(total) || !Double.isInfinite(total))) {
                        ItemQtySelectionDialog.this.tfNumber.setText("" + NumberUtil.trimDecilamIfNotNeeded(total += 1.0));
                    }
                }
            });
            this.decrementQuantitybtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double total;
                    String text = ItemQtySelectionDialog.this.tfNumber.getText();
                    if (StringUtils.isNotEmpty((String)text) && ((total = Double.parseDouble(text)) == Math.floor(total) || !Double.isInfinite(total)) && (total -= 1.0) >= 0.0) {
                        ItemQtySelectionDialog.this.tfNumber.setText("" + NumberUtil.trimDecilamIfNotNeeded(total));
                    }
                }
            });
        }
        catch (NumberFormatException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void setControlButtonsVisible(boolean visible) {
        this.incrementQuantitybtn.setVisible(visible);
        this.decrementQuantitybtn.setVisible(visible);
    }

    private boolean validate(String str) {
        if (this.isFloatingPoint(false)) {
            try {
                Double.parseDouble(str);
            }
            catch (Exception x) {
                return false;
            }
        }
        try {
            Long.parseLong(str);
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String title) {
        super.setCaption(title);
        super.setTitle(title);
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }

    public double getValue() {
        return Double.parseDouble(this.tfNumber.getText());
    }

    public void setValue(double value) {
        if (value == 0.0) {
            if (this.floatingPoint) {
                this.tfNumber.setText("0");
                this.tfNumber.selectAll();
            } else {
                this.tfNumber.setText("");
            }
        } else if (this.isFloatingPoint(true)) {
            this.tfNumber.setText(String.valueOf(value));
        } else {
            this.tfNumber.setText(String.valueOf((int)value));
        }
        this.tfNumber.selectAll();
    }

    public boolean isFloatingPoint(boolean b) {
        return this.floatingPoint;
    }

    public void setFloatingPoint(boolean decimalAllowed) {
        this.floatingPoint = decimalAllowed;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
        this.tfNumber.setText(String.valueOf(defaultValue));
    }

    private Boolean isFractional() {
        if (this.menuItem == null) {
            return Boolean.FALSE;
        }
        Double unitQuantity = this.menuItem.getUnitQuantity(this.selectedUnit == null ? this.itemDefaultUnit : this.selectedUnit, this.menuItem.getUnit());
        unitQuantity = Double.parseDouble(this.tfNumber.getText()) * unitQuantity;
        double doubleValue = unitQuantity;
        int integerValue = (int)doubleValue;
        unitQuantity = new Double(integerValue);
        return doubleValue > unitQuantity;
    }

    public static ItemQtySelectionDialog getQtyAndUnit(MenuItem menuItem, String dialogTitle, double initialAmount) {
        ItemQtySelectionDialog dialog = new ItemQtySelectionDialog(true, menuItem);
        dialog.setValue(initialAmount);
        dialog.setTitle(dialogTitle);
        dialog.setDialogTitle(dialogTitle);
        return dialog;
    }

    public static ItemQtySelectionDialog getQtyAndUnit(MenuItem menuItem, IUnit itemDefaultUnit, String dialogTitle, double initialAmount) {
        ItemQtySelectionDialog dialog = new ItemQtySelectionDialog(true, menuItem, itemDefaultUnit);
        dialog.setValue(initialAmount);
        dialog.setTitle(dialogTitle);
        dialog.setDialogTitle(dialogTitle);
        return dialog;
    }

    public void setUtilityButtonsVisible(boolean visible) {
        this.incrementQuantitybtn.setVisible(visible);
        this.decrementQuantitybtn.setVisible(visible);
    }

    class UnitButton
    extends POSToggleButton
    implements ActionListener {
        private IUnit newUnit;

        public UnitButton(IUnit newUnit) {
            this.newUnit = newUnit;
            this.setText(newUnit.getName());
            this.addActionListener(this);
            if (newUnit.equals(ItemQtySelectionDialog.this.itemDefaultUnit)) {
                this.setSelected(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button = (JToggleButton)e.getSource();
            if (button.isSelected()) {
                ItemQtySelectionDialog.this.selectedUnit = this.newUnit;
            }
        }
    }
}

