/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.swing.HTMLImageToolKit;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.MailTemplateUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PreviewTicketUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.apache.velocity.runtime.parser.ParseException;

public class MailPreviewDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private String emailBody;

    public MailPreviewDialog(String emailBody) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.emailBody = emailBody;
        this.initComponents();
        this.setSize(PosUIManager.getSize(550, 700));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        PosButton btnFinish = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        buttonPanel.add((Component)btnFinish, "grow");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0"));
        int fontSize = PosUIManager.getDefaultFontSize();
        JTextPane emailBodyTextArea = new JTextPane();
        emailBodyTextArea.setContentType("text/html");
        emailBodyTextArea.setEditable(false);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontSize(attributes, fontSize);
        StyleConstants.setAlignment(attributes, 1);
        HTMLImageToolKit toolKit = new HTMLImageToolKit();
        emailBodyTextArea.setEditorKit(toolKit);
        emailBodyTextArea.setParagraphAttributes(attributes, true);
        this.emailBody = this.emailBody.replaceAll("\n", "<br>");
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        OrderType orderType = null;
        orderType = orderTypes != null && !orderTypes.isEmpty() ? orderTypes.get(0) : new OrderType();
        Ticket previewTicket = PreviewTicketUtil.createPreviewTicket(orderType, null);
        TicketPrintProperties printProperties = new TicketPrintProperties("*** ORDER " + previewTicket.getId() + " ***", false, true, true);
        HashMap<String, Object> params = ReceiptPrintService.populateTicketProperties(previewTicket, printProperties, previewTicket.getTransactions().iterator().next());
        try {
            this.emailBody = MailTemplateUtil.process(this.emailBody, params);
        }
        catch (ParseException e1) {
            PosLog.error(this.getClass(), e1.getMessage(), (Exception)((Object)e1));
        }
        emailBodyTextArea.setText(this.emailBody);
        emailBodyTextArea.setCaretPosition(0);
        centerPanel.add((Component)new PosScrollPane(emailBodyTextArea), "grow");
        this.add((Component)this.titlePanel, "North");
        this.add(centerPanel);
        this.add((Component)buttonPanel, "South");
        btnFinish.addActionListener(e -> this.doCloseDialog());
    }

    private void doCloseDialog() {
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(VersionInfo.getAppName());
    }
}

