/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;

public class NotesDialog
extends OkCancelOptionDialog {
    JTextArea txtNote = new JTextArea();

    public NotesDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.txtNote.setWrapStyleWord(true);
        this.txtNote.setLineWrap(true);
        this.txtNote.setDocument(new FixedLengthDocument(255));
        this.txtNote.requestFocus();
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        TransparentPanel northPanel = new TransparentPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.txtNote);
        northPanel.setPreferredSize(new Dimension(100, 60));
        northPanel.add(scrollPane);
        mainPanel.add((Component)northPanel, "North");
        mainPanel.add((Component)((Object)new QwertyKeyPad()), "Center");
        this.getContentPanel().add(mainPanel);
        this.pack();
    }

    @Override
    public void doOk() {
        if (StringUtils.isBlank((String)this.getNote())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("EnterTextForNotes"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(Application.getTitle());
        this.setCaption(title);
    }

    public String getNote() {
        return this.txtNote.getText();
    }

    public void setNote(String note) {
        this.txtNote.setText(note);
    }
}

