/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.views.OrderTypeSelectionView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class OrderTypeSelectionDialog
extends POSDialog
implements ActionListener {
    private OrderTypeSelectionView orderTypeSelectionView;
    private List<OrderType> orderTypeList;
    private TitlePanel titelpanel;

    public OrderTypeSelectionDialog(List<OrderType> orderTypeList) {
        super(POSUtil.getFocusedWindow(), "");
        this.orderTypeList = orderTypeList;
        this.initComponents();
    }

    public OrderTypeSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle(Messages.getString("OrderTypeSelectionDialog.0"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(VersionInfo.getAppName());
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle(Messages.getString("OrderTypeSelectionDialog.0"));
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.orderTypeSelectionView = new OrderTypeSelectionView(this.orderTypeList, this);
        contentPane.add((Component)this.orderTypeSelectionView, "grow,span,wrap");
        PosButton btnOk = new PosButton(Messages.getString("MenuItemSelectionDialog.8"));
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,center,ins 0 5 5 5", "", ""));
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    private void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    public List<OrderType> getSelectedOrderTypes() {
        return this.orderTypeSelectionView.getSelectedOrderTypeList();
    }
}

