/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TaxExemptDialog
extends POSDialog {
    private JLabel lblTaxExemptId;
    private JLabel lblTaxExemptName;
    private JTextField tfTaxExemptId;
    private JTextField tfTaxExemptName;
    private PosButton btnSave;
    private PosButton btnCancel;
    private QwertyKeyPad qwertyKeyPad;

    public TaxExemptDialog() {
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][fill]", ""));
        JPanel southPanel = new JPanel();
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[grow]", "[grow]"));
        centerPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.lblTaxExemptId = new JLabel("Tax exempt ID :");
        northPanel.add(this.lblTaxExemptId);
        this.tfTaxExemptId = new JTextField(50);
        northPanel.add((Component)this.tfTaxExemptId, "wrap");
        this.lblTaxExemptName = new JLabel("Organization name :");
        northPanel.add(this.lblTaxExemptName);
        this.tfTaxExemptName = new JTextField(50);
        northPanel.add((Component)this.tfTaxExemptName, "wrap");
        this.btnSave = new PosButton("Done");
        southPanel.add(this.btnSave);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TaxExemptDialog.this.doSave();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        this.btnCancel = new PosButton("Cancel");
        southPanel.add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TaxExemptDialog.this.setCanceled(true);
                    TaxExemptDialog.this.dispose();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        this.qwertyKeyPad = new QwertyKeyPad();
        centerPanel.add((Component)((Object)this.qwertyKeyPad), "grow");
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
        this.add((Component)southPanel, "South");
    }

    private void doSave() {
        if (StringUtils.isEmpty((String)this.getTaxExemptId()) || StringUtils.isEmpty((String)this.getTaxExemptName())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "ID and name can not be empty!");
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public String getTaxExemptId() {
        return this.tfTaxExemptId.getText();
    }

    public String getTaxExemptName() {
        return this.tfTaxExemptName.getText();
    }
}

