/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class TicketItemDiscountSelectionDialog
extends OkCancelOptionDialog
implements ActionListener,
TicketEditListener {
    private ScrollableFlowPanel itemDiscountButtonPanel;
    private HashMap<String, DiscountButton> buttonMap = new HashMap();
    private JPanel itemSearchPanel;
    private JTextField txtSearchItem;
    private TicketViewerTable ticketViewerTable;
    private Ticket ticket;
    private List<TicketItemDiscountMapping> addedDiscounts;

    public TicketItemDiscountSelectionDialog(Ticket ticket) {
        super(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.0"));
        this.ticket = ticket;
        this.addedDiscounts = new ArrayList<TicketItemDiscountMapping>();
        this.initComponent();
    }

    private void initComponent() {
        this.setOkButtonText(POSConstants.SAVE);
        this.getContentPanel().setBorder(new EmptyBorder(5, 5, 0, 5));
        this.createCouponSearchPanel();
        this.getContentPanel().add((Component)this.itemSearchPanel, "North");
        this.itemDiscountButtonPanel = new ScrollableFlowPanel(1);
        TitledBorder itemPanelBorder = BorderFactory.createTitledBorder(null, Messages.getString("TicketItemDiscountSelectionDialog.1"), 2, 0);
        PosScrollPane discountButtonScrollPane = new PosScrollPane(this.itemDiscountButtonPanel, 20, 31);
        discountButtonScrollPane.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 0, 8), itemPanelBorder));
        this.ticketViewerTable = new TicketViewerTable(this.ticket);
        this.ticketViewerTable.addTicketUpdateListener(this);
        this.ticketViewerTable.setSelectionMode(2);
        this.ticketViewerTable.setVisibleDeleteButton(0);
        PosScrollPane ticketScrollPane = new PosScrollPane(this.ticketViewerTable);
        ticketScrollPane.setPreferredSize(PosUIManager.getSize(350, 0));
        ticketScrollPane.setBorder(new CompoundBorder(new EmptyBorder(12, 10, 2, 0), BorderFactory.createTitledBorder("")));
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.add((Component)ticketScrollPane, "West");
        mainPanel.add((Component)discountButtonScrollPane, "Center");
        this.getContentPanel().add((Component)mainPanel, "Center");
        PosButton btnMerge = new PosButton(Messages.getString("TicketItemDiscountSelectionDialog.2"));
        btnMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItemDiscountSelectionDialog.this.doMergeOperation();
            }
        });
        this.getButtonPanel().add((Component)btnMerge, 0);
        this.rendererDiscounts();
        this.setSize(1024, 720);
    }

    private void createCouponSearchPanel() {
        this.itemSearchPanel = new JPanel(new BorderLayout(5, 5));
        this.itemSearchPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        PosButton btnSearch = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        btnSearch.setPreferredSize(new Dimension(60, 40));
        JLabel lblCoupon = new JLabel(Messages.getString("DiscountSelectionDialog.4"));
        this.txtSearchItem = new JTextField();
        this.txtSearchItem.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText(Messages.getString("DiscountSelectionDialog.5"));
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.gray);
            }

            @Override
            public void focusGained(FocusEvent e) {
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.black);
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        this.txtSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketItemDiscountSelectionDialog.this.txtSearchItem.getText().equals("")) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.8"));
                    return;
                }
                if (!TicketItemDiscountSelectionDialog.this.addCouponByBarcode(TicketItemDiscountSelectionDialog.this.txtSearchItem.getText()) && !TicketItemDiscountSelectionDialog.this.addCouponById(TicketItemDiscountSelectionDialog.this.txtSearchItem.getText())) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = PosOptionPane.showInputDialog(Messages.getString("DiscountSelectionDialog.10"));
                if (value == null || value.isEmpty()) {
                    return;
                }
                TicketItemDiscountSelectionDialog.this.txtSearchItem.requestFocus();
                if (!TicketItemDiscountSelectionDialog.this.addCouponByBarcode(value) && !TicketItemDiscountSelectionDialog.this.addCouponById(value)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
            }
        });
        this.itemSearchPanel.add((Component)lblCoupon, "West");
        this.itemSearchPanel.add(this.txtSearchItem);
        this.itemSearchPanel.add((Component)btnSearch, "East");
    }

    private void doMergeOperation() {
        if (this.ticket.hasSeat()) {
            return;
        }
        String message = Messages.getString("TicketItemDiscountSelectionDialog.0");
        int option = POSMessageDialog.showYesNoQuestionDialog(message);
        if (option != 0) {
            return;
        }
        this.ticket.consolidateTicketItems();
        this.ticketViewerTable.updateView();
    }

    private boolean addCouponById(String id) {
        DiscountButton button;
        Discount discount = DiscountDAO.getInstance().get(id);
        if (discount == null) {
            return false;
        }
        if (discount.getQualificationType() == 0) {
            DiscountButton discountButton = this.buttonMap.get(discount.getId());
            this.applyDiscountToTicketItems(discountButton);
        }
        if ((button = this.buttonMap.get(discount.getId())) != null) {
            button.setSelected(true);
        }
        return true;
    }

    private boolean addCouponByBarcode(String barcode) {
        Discount discount = DiscountDAO.getInstance().getDiscountByBarcode(barcode, 0);
        if (discount == null) {
            return false;
        }
        DiscountButton discountButton = this.buttonMap.get(discount.getId());
        discountButton.setSelected(true);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.applyDiscountToTicketItems(discountButton);
        discountButton.setSelected(false);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rendererDiscounts();
    }

    private void rendererDiscounts() {
        this.buttonMap.clear();
        this.itemDiscountButtonPanel.getContentPane().removeAll();
        List<Discount> discounts = DiscountDAO.getInstance().getValidItemCoupons(this.ticket.getOrderType());
        for (Discount discount : discounts) {
            DiscountButton btnDiscount = new DiscountButton(discount);
            this.itemDiscountButtonPanel.add(btnDiscount);
            this.buttonMap.put(discount.getId(), btnDiscount);
        }
        this.itemDiscountButtonPanel.repaint();
        this.itemDiscountButtonPanel.revalidate();
    }

    @Override
    public void doOk() {
        this.addedDiscounts.clear();
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.revertTicketItemDiscountMapOperation();
        this.buttonMap.clear();
        this.setCanceled(true);
        this.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private void applyDiscountToTicketItems(DiscountButton discountButton) {
        void var7_11;
        boolean rePrice;
        int[] selectedRows = this.ticketViewerTable.getSelectedRows();
        Discount discount = discountButton.getDiscount();
        ArrayList<TicketItem> items = new ArrayList<TicketItem>();
        Store store = DataProvider.get().getStore();
        boolean bl = rePrice = discountButton.getDiscount().getType() == 2;
        if (rePrice) {
            this.applyReprice(discount);
            return;
        }
        if (selectedRows.length == 0) {
            String string = Messages.getString("TicketItemDiscountSelectionDialog.19");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, POSConstants.CONFIRM) != 0) {
                return;
            }
            for (int i = 0; i < this.ticketViewerTable.getRowCount(); ++i) {
                TicketItem ticketItem;
                ITicketItem item = this.ticketViewerTable.get(i);
                if (!(item instanceof TicketItem) || (ticketItem = (TicketItem)item).isTreatAsSeat().booleanValue()) continue;
                items.add((TicketItem)item);
            }
        } else {
            for (int i : selectedRows) {
                TicketItem ticketItem;
                ITicketItem item = this.ticketViewerTable.get(i);
                if (!(item instanceof TicketItem) || (ticketItem = (TicketItem)item).isTreatAsSeat().booleanValue()) continue;
                items.add(ticketItem);
            }
        }
        if (items.size() == 0) {
            return;
        }
        String string = "";
        boolean limitOver = false;
        for (TicketItem ticketItem : items) {
            boolean isAmountDiscount;
            List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
            if (discounts == null) {
                discounts = new ArrayList<TicketItemDiscount>();
            }
            if (discounts.size() >= 1 && !store.isAllowMulDiscount()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.20"));
                return;
            }
            boolean exists = false;
            if (!this.isApplicable(ticketItem.getMenuItem(), this.ticket.getOrderType(), discount)) {
                String string2 = (String)var7_11 + ticketItem.getName() + ",";
                continue;
            }
            for (TicketItemDiscount ticketItemDiscount2 : discounts) {
                if (discount.getMaximumOff() != 0.0 && ticketItemDiscount2.getCouponQuantity() + 1.0 > discount.getMaximumOff()) {
                    exists = true;
                    String string3 = (String)var7_11 + ticketItem.getName();
                    limitOver = true;
                    break;
                }
                if (!ticketItemDiscount2.getDiscountId().equals(discount.getId())) continue;
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount2.getCouponQuantity() + 1.0);
                exists = true;
                this.addTicketItemDiscountMapOperation(ticketItem, ticketItemDiscount2);
                break;
            }
            if (exists) continue;
            boolean bl2 = isAmountDiscount = discount.getType() == 0;
            if (isAmountDiscount && discount.isModifiable().booleanValue()) {
                this.doSetModifiableAmount(discount, ticketItem);
                continue;
            }
            TicketItemDiscount ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
            ticketItem.addTodiscounts(ticketItemDiscount);
            this.addTicketItemDiscountMapOperation(ticketItem, ticketItemDiscount);
        }
        if (!var7_11.isEmpty()) {
            if (limitOver) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.22") + " " + var7_11.substring(0, var7_11.length()));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.23") + " " + var7_11.substring(0, var7_11.length()));
            }
        }
        this.ticket.calculatePrice();
        this.ticketViewerTable.updateView();
    }

    private boolean isApplicable(MenuItem menuItem, OrderType orderType, Discount discount) {
        List<MenuCategory> menuCategories;
        List<MenuGroup> menuGroups;
        List<MenuItem> menuItems;
        DiscountDAO.getInstance().initialize(discount);
        boolean applicable = true;
        List<OrderType> orderTypes = discount.getOrderTypes();
        if (orderTypes != null && !orderTypes.isEmpty()) {
            if (orderTypes.contains(orderType)) {
                applicable = true;
            } else {
                return false;
            }
        }
        if ((menuItems = discount.getMenuItems()) != null && !menuItems.isEmpty()) {
            if (menuItems.contains(menuItem)) {
                return true;
            }
            applicable = false;
        }
        if ((menuGroups = discount.getMenuGroups()) != null && !menuGroups.isEmpty()) {
            for (MenuGroup menuGroup : menuGroups) {
                if (menuGroup.getId().equals(menuItem.getMenuGroupId())) {
                    applicable = true;
                    continue;
                }
                return false;
            }
        }
        if ((menuCategories = discount.getMenuCategories()) != null && !menuCategories.isEmpty()) {
            for (MenuCategory menuCategory : menuCategories) {
                if (menuCategory.getId().equals(menuItem.getMenuCategoryId())) {
                    applicable = true;
                    continue;
                }
                applicable = false;
            }
        }
        return applicable;
    }

    private void addTicketItemDiscountMapOperation(TicketItem ticketItem, TicketItemDiscount ticketItemDiscount) {
        block4: {
            try {
                TicketItemDiscountMapping mapping = new TicketItemDiscountMapping(ticketItem, ticketItemDiscount, 1.0);
                if (this.addedDiscounts.contains(mapping)) {
                    for (TicketItemDiscountMapping discount : this.addedDiscounts) {
                        if (!discount.equals(mapping)) continue;
                        discount.setQuantity(discount.getQuantity() + 1.0);
                        break block4;
                    }
                    break block4;
                }
                this.addedDiscounts.add(mapping);
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }
    }

    private void deleteTicketItemDiscountMapOperation(TicketItem ticketItem, TicketItemDiscount ticketItemDiscount) {
        block4: {
            try {
                TicketItemDiscountMapping mapping = new TicketItemDiscountMapping(ticketItem, ticketItemDiscount, -ticketItemDiscount.getCouponQuantity().doubleValue());
                if (this.addedDiscounts.contains(mapping)) {
                    for (TicketItemDiscountMapping discount : this.addedDiscounts) {
                        if (!discount.equals(mapping)) continue;
                        discount.setQuantity(discount.getQuantity() + mapping.getQuantity());
                        break block4;
                    }
                    break block4;
                }
                this.addedDiscounts.add(mapping);
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }
    }

    private void revertTicketItemDiscountMapOperation() {
        if (this.addedDiscounts.isEmpty()) {
            return;
        }
        Iterator<TicketItemDiscountMapping> i0 = this.addedDiscounts.iterator();
        while (i0.hasNext()) {
            TicketItemDiscountMapping mapping = i0.next();
            while (mapping.getQuantity() != 0.0) {
                TicketItem ticketItem = mapping.getTicketItem();
                TicketItemDiscount discount = mapping.getDiscount();
                if (mapping.getQuantity() > 0.0) {
                    Iterator<TicketItemDiscount> i1 = ticketItem.getDiscounts().iterator();
                    while (i1.hasNext()) {
                        TicketItemDiscount d = i1.next();
                        if (!d.getName().equals(discount.getName())) continue;
                        d.setCouponQuantity(d.getCouponQuantity() - mapping.getQuantity());
                        mapping.setQuantity(0.0);
                        if (d.getCouponQuantity() != 0.0) continue;
                        i1.remove();
                    }
                    continue;
                }
                discount.setCouponQuantity(-mapping.getQuantity().doubleValue());
                ticketItem.addTodiscounts(discount);
                mapping.setQuantity(0.0);
            }
            i0.remove();
        }
        this.ticket.calculatePrice();
        this.ticketViewerTable.updateView();
    }

    private void applyReprice(Discount discount) {
        int[] selectedRows = this.ticketViewerTable.getSelectedRows();
        if (selectedRows.length != 1) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.16"));
            return;
        }
        ITicketItem item = this.ticketViewerTable.get(selectedRows[0]);
        if (!(item instanceof TicketItem)) {
            return;
        }
        TicketItem ticketItem = (TicketItem)item;
        if (!this.isApplicable(ticketItem.getMenuItem(), this.ticket.getOrderType(), discount)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.23") + " " + ticketItem.getName());
            return;
        }
        TicketItemDiscount ticketItemDiscount = null;
        List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount itemDiscount : discounts) {
                if (!itemDiscount.getDiscountId().equals(discount.getId())) continue;
                ticketItemDiscount = itemDiscount;
                break;
            }
        }
        double initialAmount = NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmountWithoutModifiers()).doubleValue();
        double value = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketItemDiscountSelectionDialog.17"), initialAmount, true, false);
        if (value == -1.0) {
            return;
        }
        ticketItem.setUnitPrice(value);
        ticketItem.calculatePrice();
        if (ticketItemDiscount == null) {
            ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
            ticketItem.addTodiscounts(ticketItemDiscount);
        }
        ticketItemDiscount.setValue(value);
        ticketItemDiscount.setAmount(value);
        ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount()));
        this.ticketViewerTable.updateView();
    }

    private void doSetModifiableAmount(Discount discount, TicketItem ticketItem) {
        double value = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketItemDiscountSelectionDialog.6"), ticketItem.getSubtotalAmount(), true);
        if (value == -1.0) {
            return;
        }
        TicketItemDiscount ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
        ticketItem.addTodiscounts(ticketItemDiscount);
        ticketItemDiscount.setValue(value);
        ticketItemDiscount.setAmount(value);
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem item) {
    }

    @Override
    public void itemRemoved(ITicketItem item) {
        if (item instanceof TicketItemDiscount) {
            TicketItemDiscount discount = (TicketItemDiscount)item;
            this.deleteTicketItemDiscountMapOperation(discount.getTicketItem(), discount);
        }
        this.ticket.calculatePrice();
        this.ticketViewerTable.updateView();
    }

    private class TicketItemDiscountMapping {
        private TicketItem ticketItem;
        private TicketItemDiscount discount;
        private Double quantity;

        public TicketItemDiscountMapping(TicketItem ticketItem, TicketItemDiscount discount, Double quantity) {
            this.ticketItem = ticketItem;
            this.discount = discount;
            this.quantity = quantity;
        }

        public Double getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Double quantity) {
            this.quantity = quantity;
        }

        public TicketItem getTicketItem() {
            return this.ticketItem;
        }

        public TicketItemDiscount getDiscount() {
            return this.discount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.discount == null ? 0 : this.discount.hashCode());
            result = 31 * result + (this.ticketItem == null ? 0 : this.ticketItem.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TicketItemDiscountMapping other = (TicketItemDiscountMapping)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.discount == null ? other.discount != null : !this.discount.equals(other.discount)) {
                return false;
            }
            return !(this.ticketItem == null ? other.ticketItem != null : !this.ticketItem.equals(other.ticketItem));
        }

        private TicketItemDiscountSelectionDialog getOuterType() {
            return TicketItemDiscountSelectionDialog.this;
        }
    }

    private class DiscountButton
    extends JPanel
    implements ActionListener {
        private Discount discount;
        private PosButton btnDiscount;

        DiscountButton(Discount discount) {
            this.discount = discount;
            this.setLayout((LayoutManager)new MigLayout("hidemode 3, fill", "", "[grow][]"));
            JLabel lblCoupon = new JLabel();
            lblCoupon.setOpaque(false);
            lblCoupon.setHorizontalAlignment(0);
            lblCoupon.setMinimumSize(PosUIManager.getSize(120, 80));
            lblCoupon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            lblCoupon.setText("<html><body><center><strong>" + discount.getName() + "</strong></center></body></html>");
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.add((Component)lblCoupon, "grow,span,wrap,w 200!, h 160!");
            this.btnDiscount = new PosButton(POSConstants.APPLY);
            this.btnDiscount.addActionListener(this);
            this.add((Component)this.btnDiscount, "center");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TicketItemDiscountSelectionDialog.this.applyDiscountToTicketItems(this);
        }

        public Discount getDiscount() {
            return this.discount;
        }

        public void setSelected(Boolean selected) {
            this.btnDiscount.setSelected(selected);
            if (selected.booleanValue()) {
                this.btnDiscount.setText(Messages.getString("TicketItemDiscountSelectionDialog.13"));
                this.btnDiscount.setBackground(Color.PINK);
            } else {
                this.btnDiscount.setText(POSConstants.APPLY);
                this.btnDiscount.setBackground(UIManager.getColor("control"));
            }
        }
    }
}

