/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.service.ExcelImporterService;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import liquibase.util.file.FilenameUtils;
import net.miginfocom.swing.MigLayout;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.exception.ConstraintViolationException;

public class ExcelImportViewDialog
extends POSDialog {
    private static final String EMPTY_SPACE_STRING = " ";
    private TitlePanel titlePanel;
    private JPanel buttonPanel;
    private String filePath;
    private JTabbedPane mainTabbedPane;
    private ItemContainer menuItemPanel;
    private ItemContainer modifierPanel;
    private List<Object> objectList;
    private BusyDialog waitDialog;

    public ExcelImportViewDialog(String filePath) throws Exception {
        this.filePath = filePath;
        this.initDialog();
        this.initReader();
    }

    private void initDialog() {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.mainTabbedPane = new JTabbedPane();
        this.menuItemPanel = new ItemContainer(this.doCreateMenuItemModel());
        this.modifierPanel = new ItemContainer(this.doCreateMenuModifierModel());
        this.mainTabbedPane.addTab(Messages.getString("ExcelImportViewDialog.0"), this.menuItemPanel);
        this.mainTabbedPane.addTab(Messages.getString("ExcelImportViewDialog.1"), this.modifierPanel);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.mainTabbedPane, "Center");
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    private BeanTableModel doCreateMenuModifierModel() {
        BeanTableModel menuModifierTableModel = new BeanTableModel(MenuModifier.class);
        menuModifierTableModel.addColumn(POSConstants.NAME, MenuModifier.PROP_NAME);
        menuModifierTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuModifier.PROP_PRICE);
        menuModifierTableModel.addColumn(POSConstants.ACTIVE, MenuModifier.PROP_ENABLE);
        menuModifierTableModel.addColumn(POSConstants.PIZZA_MODIFIER, MenuModifier.PROP_PIZZA_MODIFIER);
        return menuModifierTableModel;
    }

    private BeanTableModel doCreateMenuItemModel() {
        BeanTableModel<MenuItem> menuItemTableModel = new BeanTableModel<MenuItem>(MenuItem.class){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 6 || columnIndex == 7;
            }
        };
        menuItemTableModel.addColumn(POSConstants.CATEGORY, MenuItem.PROP_MENU_CATEGORY_NAME);
        menuItemTableModel.addColumn(POSConstants.GROUP, MenuItem.PROP_MENU_GROUP_NAME);
        menuItemTableModel.addColumn(POSConstants.NAME, MenuItem.PROP_NAME);
        menuItemTableModel.addColumn(POSConstants.DESCRIPTION, MenuItem.PROP_DESCRIPTION);
        menuItemTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        menuItemTableModel.addColumn(POSConstants.COST, MenuItem.PROP_COST);
        menuItemTableModel.addColumn(POSConstants.SKU, MenuItem.PROP_SKU);
        menuItemTableModel.addColumn(POSConstants.BARCODE, MenuItem.PROP_BARCODE);
        menuItemTableModel.addColumn(POSConstants.ACTIVE, MenuItem.PROP_VISIBLE);
        menuItemTableModel.addColumn(POSConstants.FRACTIONAL_UNIT, MenuItem.PROP_FRACTIONAL_UNIT);
        menuItemTableModel.addColumn(POSConstants.INVENTORY_ITEM, MenuItem.PROP_INVENTORY_ITEM);
        menuItemTableModel.addColumn(POSConstants.ALLOW_PRICE_OVERRIDE, MenuItem.PROP_EDITABLE_PRICE);
        return menuItemTableModel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(90);
        columnWidth.add(90);
        columnWidth.add(130);
        columnWidth.add(130);
        columnWidth.add(90);
        columnWidth.add(80);
        columnWidth.add(110);
        columnWidth.add(80);
        columnWidth.add(80);
        columnWidth.add(100);
        columnWidth.add(105);
        columnWidth.add(95);
        return columnWidth;
    }

    private JPanel createButtonPanel() {
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.setText(Messages.getString("MenuItemExplorer.19"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.doDeleteItems();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage(), exp);
                }
            }
        });
        JButton btnSave = new JButton(POSConstants.SAVE);
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.setCanceled(false);
                    ExcelImportViewDialog.this.doSave();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage(), exp);
                }
            }
        });
        JButton btnCancel = new JButton(POSConstants.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage(), exp);
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        bottomPanel.add(btnSave);
        bottomPanel.add(deleteButton);
        bottomPanel.add(btnCancel);
        return bottomPanel;
    }

    protected void doSave() {
        try {
            List<Object> items = this.getItemsList();
            if (items == null || items.isEmpty()) {
                POSMessageDialog.showError(Messages.getString("DataImortedFailed"));
                return;
            }
            ArrayList<MenuItem> objectMenuItemList = new ArrayList<MenuItem>();
            for (Object object : items) {
                if (!(object instanceof MenuItem)) continue;
                objectMenuItemList.add((MenuItem)object);
            }
            ArrayList<MenuItem> unsavedMenuItems = new ArrayList<MenuItem>();
            ArrayList<MenuModifier> unsavedMenuModifiers = new ArrayList<MenuModifier>();
            long savedMenuItemsCount = 0L;
            long savedMenuModifiersCount = 0L;
            for (Object object : items) {
                if (object instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)object;
                    try {
                        MenuItemDAO.getInstance().saveOrUpdate(menuItem);
                        ++savedMenuItemsCount;
                    }
                    catch (Exception e) {
                        unsavedMenuItems.add(menuItem);
                    }
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                MenuModifier menuModifier = (MenuModifier)object;
                try {
                    MenuModifierDAO.getInstance().saveOrUpdate(menuModifier);
                    ++savedMenuModifiersCount;
                }
                catch (Exception e) {
                    unsavedMenuModifiers.add(menuModifier);
                }
            }
            if (unsavedMenuItems.isEmpty() && unsavedMenuModifiers.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImportedSuccessFully"));
                this.dispose();
            } else {
                boolean hasUnsavedMenuModifiers;
                boolean hasUnsavedMenuItems;
                this.objectList.clear();
                boolean bl = hasUnsavedMenuItems = !unsavedMenuItems.isEmpty();
                if (hasUnsavedMenuItems) {
                    this.objectList.addAll(unsavedMenuItems);
                }
                boolean bl2 = hasUnsavedMenuModifiers = !unsavedMenuModifiers.isEmpty();
                if (hasUnsavedMenuModifiers) {
                    this.objectList.addAll(unsavedMenuItems);
                }
                this.doUpdateTable();
                String message = savedMenuItemsCount + EMPTY_SPACE_STRING + Messages.getString("ExcelImportViewDialog.8") + EMPTY_SPACE_STRING + savedMenuModifiersCount + EMPTY_SPACE_STRING + Messages.getString("ExcelImportViewDialog.9") + EMPTY_SPACE_STRING;
                if (hasUnsavedMenuItems && hasUnsavedMenuModifiers) {
                    message = message + Messages.getString("ExcelImportViewDialog.10");
                } else if (hasUnsavedMenuItems) {
                    message = message + Messages.getString("ExcelImportViewDialog.13");
                } else if (hasUnsavedMenuModifiers) {
                    message = message + Messages.getString("ExcelImportViewDialog.14");
                }
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doDeleteItems() {
        try {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            int selectedIndex = this.mainTabbedPane.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.mainTabbedPane.getComponentAt(selectedIndex);
            JTable table = itemContainer.itemTable;
            BeanTableModel tableModel = itemContainer.tableModel;
            int[] selectedRows = table.getSelectedRows();
            if (selectedRows.length <= 0) {
                return;
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                tableModel.removeRow(selectedRows[i] - i);
            }
            this.updateTitle(tableModel.getRowCount());
        }
        catch (ConstraintViolationException ex) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ExcelImportViewDialog.7"));
            return;
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void initReader() throws Exception {
        SwingWorker<List<Object>, Void> worker = new SwingWorker<List<Object>, Void>(){

            @Override
            protected List<Object> doInBackground() throws Exception {
                String fileExtension = FilenameUtils.getExtension((String)ExcelImportViewDialog.this.filePath);
                if (fileExtension.equals("xlsx")) {
                    ExcelImportViewDialog.this.objectList = ExcelImportViewDialog.this.readXLSXFile();
                    return ExcelImportViewDialog.this.objectList;
                }
                if (fileExtension.equals("xls")) {
                    ExcelImportViewDialog.this.objectList = ExcelImportViewDialog.this.readXLSFile();
                    return ExcelImportViewDialog.this.objectList;
                }
                throw new PosException(Messages.getString("SelectAnExcelFile"));
            }

            @Override
            protected void done() {
                try {
                    if (this.get() == null) {
                        return;
                    }
                    ExcelImportViewDialog.this.doUpdateTable();
                    ExcelImportViewDialog.this.updateTitle(ExcelImportViewDialog.this.objectList.size());
                }
                catch (Exception e) {
                    ExcelImportViewDialog.this.waitDialog.dispose();
                    Throwable cause = e.getCause();
                    if (cause instanceof PosException) {
                        POSMessageDialog.showError(cause.getMessage());
                    } else if (e instanceof CancellationException) {
                    } else {
                        POSMessageDialog.showError(cause.getMessage(), cause);
                    }
                }
                finally {
                    ExcelImportViewDialog.this.waitDialog.dispose();
                }
            }
        };
        this.waitDialog = new BusyDialog(worker);
        worker.execute();
        this.waitDialog.setVisible(true);
    }

    private void doUpdateTable() {
        try {
            this.menuItemPanel.tableModel.removeAll();
            this.modifierPanel.tableModel.removeAll();
            for (Object object : this.objectList) {
                if (object instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)object;
                    this.menuItemPanel.tableModel.addRow(menuItem);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                MenuModifier menuModifier = (MenuModifier)object;
                this.modifierPanel.tableModel.addRow(menuModifier);
            }
        }
        catch (Exception exp) {
            POSMessageDialog.showError(this, exp.getMessage(), exp);
        }
    }

    private void updateTitle(int size) {
        this.titlePanel.setTitle(Messages.getString("ExcelImportViewDialog.11") + size + Messages.getString("ExcelImportViewDialog.12"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readXLSXFile() throws Exception {
        XSSFWorkbook wb = null;
        ArrayList<Object> objectList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try (FileInputStream xlsxFileToRead = null;){
            xlsxFileToRead = new FileInputStream(this.filePath);
            wb = new XSSFWorkbook((InputStream)xlsxFileToRead);
            ExcelImporterService.getInstance().doImportMenuItemFromXLSX(objectList, menuCategory, menuGroup, wb.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLSX(objectList, modifierGroup, wb.getSheetAt(1));
        }
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readXLSFile() throws Exception {
        HSSFWorkbook wb = null;
        ArrayList<Object> objectList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try (FileInputStream xlsFileToRead = null;){
            xlsFileToRead = new FileInputStream(this.filePath);
            wb = new HSSFWorkbook((InputStream)xlsFileToRead);
            ExcelImporterService.getInstance().doImportMenuItemFromXLS(objectList, menuCategory, menuGroup, wb.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLS(objectList, modifierGroup, wb.getSheetAt(1));
        }
        return objectList;
    }

    public List<Object> getItemsList() {
        ArrayList<Object> items = new ArrayList<Object>();
        int tabCount = this.mainTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            ItemContainer itemContainer = (ItemContainer)this.mainTabbedPane.getComponentAt(i);
            items.addAll(itemContainer.tableModel.getRows());
        }
        return items;
    }

    private void doSelectAll() {
        try {
            int selectedIndex = this.mainTabbedPane.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.mainTabbedPane.getComponentAt(selectedIndex);
            JTable table = itemContainer.itemTable;
            table.selectAll();
        }
        catch (Exception exp) {
            POSMessageDialog.showError(this, exp.getMessage(), exp);
        }
    }

    class ItemContainer
    extends JPanel {
        private BeanTableModel tableModel;
        private JTable itemTable;

        public ItemContainer(BeanTableModel tableModel) {
            this.tableModel = tableModel;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.itemTable = new JTable(this.tableModel);
            this.itemTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.itemTable.setSelectionMode(2);
            this.itemTable.setRowHeight(PosUIManager.getSize(50));
            ExcelImportViewDialog.this.resizeColumnWidth(this.itemTable);
            this.add(new JScrollPane(this.itemTable));
        }
    }
}

