/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.util.GeneratePasswordUtil;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GeneratePasswordDialog
extends POSDialog {
    private String USE_PASS = Messages.getString("GeneratePasswordDialog.0");
    private String COPY = Messages.getString("GeneratePasswordDialog.1");
    private JPanel mainPanel;
    private JTextField tfGenPass;
    private IntegerTextField tfPassLength;
    private TitlePanel titlePanel;
    private String generatedPassword;

    public GeneratePasswordDialog() {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle(Messages.getString("GeneratePasswordDialog.2"));
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("center", "[][grow][]", ""));
        JLabel passLengthLabel = new JLabel(Messages.getString("GeneratePasswordDialog.6"));
        this.tfPassLength = new IntegerTextField(10);
        this.tfPassLength.setText(String.valueOf(4));
        JButton btnGen = new JButton(Messages.getString("GeneratePasswordDialog.7"));
        btnGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GeneratePasswordDialog.this.doSetGeneratedPass();
            }
        });
        JLabel passLabel = new JLabel(Messages.getString("GeneratePasswordDialog.8"));
        this.tfGenPass = new JTextField(10);
        this.tfGenPass.setEditable(false);
        this.mainPanel.add(passLengthLabel);
        this.mainPanel.add((Component)this.tfPassLength, "growx");
        this.mainPanel.add((Component)btnGen, "wrap");
        this.mainPanel.add(passLabel);
        this.mainPanel.add((Component)this.tfGenPass, "growx");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton useThisPass = new PosButton(this.USE_PASS);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        PosButton btnCopy = new PosButton(this.COPY);
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratePasswordDialog.this.tfGenPass.getText().length() == 0) {
                    POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("GeneratePasswordDialog.13"));
                } else {
                    StringSelection selection = new StringSelection(GeneratePasswordDialog.this.tfGenPass.getText());
                    Clipboard clipbord = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipbord.setContents(selection, null);
                    GeneratePasswordDialog.this.tfGenPass.copy();
                }
            }
        });
        useThisPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneratePasswordDialog.this.doUseThisPass();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneratePasswordDialog.this.performCancel();
            }
        });
        buttonPanel.add(btnCopy);
        buttonPanel.add(useThisPass);
        buttonPanel.add(btnCancel);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void performCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    public String getGenPassword() {
        return this.generatedPassword;
    }

    private void doUseThisPass() {
        try {
            this.generatedPassword = this.tfGenPass.getText();
            if (StringUtils.isEmpty((String)this.generatedPassword)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GeneratePasswordDialog.14"));
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSetGeneratedPass() {
        try {
            if (this.tfPassLength.getText().equals("0") || this.tfPassLength.getText().equals("1") || this.tfPassLength.getText().equals("2") || this.tfPassLength.getText().equals("3")) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GeneratePasswordDialog.19"));
            } else {
                GeneratePasswordUtil passwordService = new GeneratePasswordUtil();
                this.tfGenPass.setText(passwordService.createRandPass(this.tfPassLength.getText()));
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

