/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CourseForm
extends BeanEditor {
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfShortName;
    private IntegerTextField tfSortOrder;
    private JLabel lblImagePreview;
    private ImageResource imageResource;
    private List<Course> existingCourses;

    public CourseForm() {
        this(new Course());
    }

    public CourseForm(Course course) {
        this.initComponents();
        this.setBean(course);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[134px][204px,grow]", ""));
        this.tfSortOrder = new IntegerTextField();
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(128);
        this.tfShortName = new FixedLengthTextField();
        this.tfShortName.setLength(3);
        this.lblImagePreview = new JLabel("");
        this.lblImagePreview.setText(Messages.getString("CourseForm.0"));
        this.lblImagePreview.setForeground(Color.gray);
        this.add((Component)new JLabel(Messages.getString("NAME")), "alignx trailing,aligny center");
        this.add((Component)this.tfName, "growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("CourseForm.2")), "alignx trailing,aligny center");
        this.add((Component)this.tfShortName, "growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("CourseForm.3")), "alignx trailing,aligny center");
        this.add((Component)this.tfSortOrder, "w 100!,aligny center");
        JPanel imagePanel = new JPanel((LayoutManager)new MigLayout("center", "", ""));
        JPanel imgPreviewPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.lblImagePreview.setHorizontalAlignment(0);
        imgPreviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 2, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        imgPreviewPanel.setPreferredSize(new Dimension(70, 50));
        imgPreviewPanel.add((Component)this.lblImagePreview, "w 24!,h 24!,aligny center");
        this.add((Component)imagePanel, "skip 1");
    }

    @Override
    public String getDisplayText() {
        if (((Course)this.getBean()).getId() == null) {
            return Messages.getString("CourseForm.4");
        }
        return Messages.getString("CourseForm.5");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Course course = (Course)this.getBean();
            CourseDAO courseDAO = CourseDAO.getInstance();
            courseDAO.saveOrUpdate(course);
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            return false;
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, Messages.getString("MessageDialog.0"), x);
            PosLog.error(this.getClass(), x);
            return false;
        }
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Course course = (Course)this.getBean();
        if (course == null) {
            return false;
        }
        String courseName = this.tfName.getText().trim();
        String shortName = this.tfShortName.getText().trim();
        int sortOrder = this.tfSortOrder.getInteger();
        if (StringUtils.isEmpty((String)shortName)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.10"));
            return false;
        }
        if (sortOrder <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.11"));
            return false;
        }
        if (this.existingCourses != null) {
            for (Course c : this.existingCourses) {
                if (c.getSortOrder() != sortOrder) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.12"));
                return false;
            }
        }
        GenericDAO.getInstance().checkIdOrNameExists(course.getId(), courseName, Course.class);
        course.setName(courseName);
        course.setShortName(shortName);
        course.setSortOrder(sortOrder);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof Course)) {
            return;
        }
        Course course = (Course)this.getBean();
        this.setData(course);
    }

    private void setData(Course course) {
        this.tfSortOrder.setText(String.valueOf(course.getSortOrder()));
        this.tfName.setText(course.getName());
        this.tfShortName.setText(course.getShortName());
        this.imageResource = ImageResourceDAO.getInstance().findById(course.getIconId());
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(16, 16));
            this.lblImagePreview.setText("");
        } else {
            this.lblImagePreview.setText(Messages.getString("CourseForm.14"));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setSelectBtnVisible(true);
        dialog.setTitle(Messages.getString("CourseForm.15"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(16, 16));
            this.lblImagePreview.setText("");
        } else {
            this.lblImagePreview.setText(Messages.getString("CourseForm.17"));
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    public List<Course> getExistingCourses() {
        return this.existingCourses;
    }

    public void setExistingCourses(List<Course> courses) {
        this.existingCourses = new ArrayList<Course>();
        Course course = (Course)this.getBean();
        int nextSortOrder = 1;
        for (Course c : courses) {
            if (course.getId() != null && c.getId().equals(course.getId())) continue;
            if (c.getSortOrder() > nextSortOrder) {
                nextSortOrder = c.getSortOrder();
            }
            this.existingCourses.add(c);
        }
        if (this.tfSortOrder.getInteger() == 0) {
            this.tfSortOrder.setText(String.valueOf(nextSortOrder + 1));
        }
    }
}

