/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class MenuItemSelectionView
extends JPanel {
    private JComboBox cbGroup;
    private PosTable table;
    private MenuItemTableModel tableModel;
    private POSTextField tfName;
    private MenuItem parentMenuItem;
    private JButton btnNext;
    private JButton btnPrev;
    private MenuGroup selectedGroup;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton btnSearch;
    private JPanel searchPanel;
    private Map<String, MenuItem> addedMenuItemMap = new HashMap<String, MenuItem>();
    private JCheckBox chkShowSelected;
    private JCheckBox chkSelectAll;
    private JLabel lblGroup;
    private boolean inventoryItemOnly;
    private boolean isShowVarParent = true;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private POSDialog dialog;
    private boolean isShowVariant = true;
    private boolean isShowComboItem = true;

    public MenuItemSelectionView(List<MenuItem> addedMenuItems, boolean inventoryItemOnly) {
        this(addedMenuItems, inventoryItemOnly, null);
    }

    public MenuItemSelectionView(List<MenuItem> addedMenuItems, boolean inventoryItemOnly, POSDialog dialog) {
        this.inventoryItemOnly = inventoryItemOnly;
        this.dialog = dialog;
        this.initComponents();
        this.tableModel.setCurrentRowIndex(0);
        this.cbGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuItemSelectionView.this.tableModel.setCurrentRowIndex(0);
                MenuItemSelectionView.this.setSelectedMenuGroup(MenuItemSelectionView.this.cbGroup.getSelectedItem());
            }
        });
        this.setSelectedItems(addedMenuItems);
        this.searchItem();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new MenuItemTableModel();
        this.tableModel.setColumnNames(new String[]{"-", Messages.getString("MenuItemSelectionView.1"), Messages.getString("MenuItemSelectionView.2")});
        this.tableModel.setPageSize(10);
        this.table = new PosTable();
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuItemSelectionView.this.doSelectedRowOnDubbleClick();
                } else {
                    MenuItemSelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)((Object)this.table));
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)((Object)this.table));
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox(Messages.getString("MenuItemSelectionView.7"));
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.updateView();
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        this.btnPrev = new JButton(Messages.getString("MenuItemSelectionView.8"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new JButton(Messages.getString("MenuItemSelectionView.11"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == MenuItemSelectionView.this.btnPrev) {
                        MenuItemSelectionView.this.scrollUp();
                    } else if (source == MenuItemSelectionView.this.btnNext) {
                        MenuItemSelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void updateView() {
        if (this.chkShowSelected.isSelected()) {
            this.tableModel.setRows(new ArrayList<MenuItem>(this.addedMenuItemMap.values()));
            this.chkShowSelected.setText(Messages.getString("MenuItemSelectionView.13") + "(" + this.addedMenuItemMap.values().size() + ")");
            this.lblNumberOfItem.setText("");
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.cbGroup.setEnabled(false);
            this.table.repaint();
        } else {
            if (this.cbGroup.getSelectedItem() != null) {
                this.searchItem();
            }
            this.cbGroup.setEnabled(true);
        }
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.lblName = new JLabel(POSConstants.NAME + "/" + Messages.getString("MenuItemSelectionView.16"));
        this.tfName = new POSTextField(15);
        this.btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "growx");
        this.chkSelectAll = new JCheckBox(Messages.getString("MenuItemSelectionView.18"));
        this.chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.selectGroupItems();
            }
        });
        this.cbGroup = new OverflowCombobox();
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add(Messages.getString("MenuItemSelectionView.19"));
        List<MenuGroup> menuGroupList = MenuGroupDAO.getInstance().findAll();
        groups.addAll(menuGroupList);
        ComboBoxModel model = new ComboBoxModel(groups);
        this.cbGroup.setModel(model);
        this.cbGroup.setSelectedItem(Messages.getString("MenuItemSelectionView.19"));
        this.cbGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.searchPanel.add(this.btnSearch);
        this.lblGroup = new JLabel(Messages.getString("MenuItemSelectionView.21"));
        this.searchPanel.add((Component)this.lblGroup, "split 2,right");
        this.searchPanel.add((Component)this.cbGroup, "wrap,width 150!");
        this.searchPanel.add((Component)this.chkSelectAll, "left, split 2");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    private void searchItem() {
        this.searchItem(null);
    }

    public void searchItem(String searchText) {
        try {
            this.selectedGroup = this.cbGroup.getSelectedItem() instanceof MenuGroup ? (MenuGroup)this.cbGroup.getSelectedItem() : null;
            this.tableModel.setPageSize(50);
            this.tableModel.setCurrentRowIndex(0);
            searchText = StringUtils.isEmpty((String)searchText) ? this.tfName.getText() : searchText;
            this.tfName.setText(searchText);
            MenuItemDAO.getInstance().findByBarcodeOrName(this.tableModel, this.isInventoryItemOnly(), this.selectedGroup, searchText, this.isShowVarParent, null, false, this.isShowVariant, this.isShowComboItem, null);
            this.updateButton();
            this.tableModel.fireTableDataChanged();
            this.table.repaint();
            this.chkShowSelected.setSelected(false);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void selectGroupItems() {
        try {
            List menuItems = this.tableModel.getRows();
            if (menuItems == null) {
                return;
            }
            for (MenuItem item : menuItems) {
                if (this.parentMenuItem != null && this.parentMenuItem.getId() != null && this.parentMenuItem.getId().equals(item.getId())) continue;
                if (this.chkSelectAll.isSelected()) {
                    if (!this.addedMenuItemMap.containsKey(item.getId())) {
                        this.addedMenuItemMap.put(item.getId(), item);
                    }
                } else {
                    this.addedMenuItemMap.remove(item.getId());
                }
                this.chkShowSelected.setText(Messages.getString("MenuItemSelectionView.25") + "(" + this.addedMenuItemMap.values().size() + ")");
                this.table.repaint();
            }
            this.table.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MenuItemSelectionView.27"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.chkSelectAll.setSelected(false);
        this.chkShowSelected.setText(Messages.getString("MenuItemSelectionView.28") + "(" + this.addedMenuItemMap.values().size() + ")");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionView.this.doAddItem();
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(70);
        columnWidth.add(250);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuItem menuItem = (MenuItem)this.tableModel.getRowData(index);
            MenuItemDAO.getInstance().initialize(menuItem);
            BeanEditor editor = null;
            editor = menuItem.isPizzaType() != false ? new PizzaItemForm(menuItem) : new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor);
            dialog.openWithScale(1000, 700);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    private void doSelectedRowOnDubbleClick() {
        try {
            if (this.dialog != null) {
                if (this.table.getSelectedRow() < 0) {
                    return;
                }
                this.dialog.setCanceled(false);
                this.dialog.dispose();
            }
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    public List<MenuItem> getSelectedMenuItemList() {
        return new ArrayList<MenuItem>(this.addedMenuItemMap.values());
    }

    public void setSelectedItems(List<MenuItem> menuItems) {
        if (menuItems != null) {
            for (MenuItem item : menuItems) {
                this.addedMenuItemMap.put(item.getId(), item);
            }
        }
    }

    public void setParentMenuItem(MenuItem selectedMenuItem, boolean editMode) {
        this.parentMenuItem = selectedMenuItem;
        if (editMode) {
            this.chkShowSelected.setSelected(true);
            this.updateView();
        } else {
            this.searchItem();
        }
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        MenuItemDAO.getInstance().findByBarcodeOrName(this.tableModel, this.isInventoryItemOnly(), this.selectedGroup, this.tfName.getText(), this.isShowVarParent, null, false, this.isShowVariant, this.isShowComboItem, null);
        this.updateButton();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        MenuItemDAO.getInstance().findByBarcodeOrName(this.tableModel, this.isInventoryItemOnly(), this.selectedGroup, this.tfName.getText(), this.isShowVarParent, null, false, this.isShowVariant, this.isShowComboItem, null);
        this.updateButton();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    public void setSelectedMenuGroup(Object selectedItem) {
        this.selectedGroup = selectedItem instanceof MenuGroup ? (MenuGroup)selectedItem : null;
        this.searchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        MenuItem item = (MenuItem)this.tableModel.getRowData(selectedRow);
        if (this.parentMenuItem != null && this.parentMenuItem.getId() != null && this.parentMenuItem.getId().equals(item.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemSelectionView.33"));
            return;
        }
        if (this.addedMenuItemMap.containsKey(item.getId())) {
            this.addedMenuItemMap.remove(item.getId());
        } else {
            this.addedMenuItemMap.put(item.getId(), item);
        }
        this.chkShowSelected.setText(Messages.getString("MenuItemSelectionView.34") + "(" + this.addedMenuItemMap.values().size() + ")");
        this.table.repaint();
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSelectionMode(int selectionMode) {
        this.chkShowSelected.setVisible(selectionMode == 1);
        this.chkSelectAll.setVisible(selectionMode == 1);
        this.table.getSelectionModel().setSelectionMode(selectionMode);
        if (selectionMode == 0) {
            this.setCheckboxColumnVisibility(false);
        } else {
            this.setCheckboxColumnVisibility(true);
        }
    }

    private void setCheckboxColumnVisibility(boolean visible) {
        DefaultTableColumnModelExt tcm = (DefaultTableColumnModelExt)this.table.getColumnModel();
        List columns = tcm.getColumns(true);
        TableColumnExt checkBoxColumn = (TableColumnExt)columns.get(0);
        checkBoxColumn.setVisible(visible);
    }

    public void setSelectedGroup(MenuGroup menuGroup) {
        if (this.selectedGroup != null && this.selectedGroup.getId().equals(menuGroup.getId())) {
            return;
        }
        this.selectedGroup = menuGroup;
        this.cbGroup.setSelectedItem(menuGroup);
        this.searchItem();
    }

    public void setEnableSearch(boolean enableSearch) {
        this.tfName.setVisible(enableSearch);
        this.lblName.setVisible(enableSearch);
        this.btnSearch.setVisible(enableSearch);
    }

    public boolean isInventoryItemOnly() {
        return this.inventoryItemOnly;
    }

    public void setInventoryItemOnly(boolean inventoryItemOnly) {
        this.inventoryItemOnly = inventoryItemOnly;
    }

    public MenuItemTableModel getModel() {
        return this.tableModel;
    }

    private void doAddItem() {
        try {
            MenuItem menuItem = new MenuItem();
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem foodItem = (MenuItem)editor.getBean();
            this.tableModel.addItem(foodItem);
            this.tableModel.setNumRows(this.tableModel.getNumRows() + 1);
            this.updateButton();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    public void setShowVariantParent(boolean isShowVarParent) {
        this.isShowVarParent = isShowVarParent;
    }

    public void setShowVariant(boolean isShowVariant) {
        this.isShowVariant = isShowVariant;
    }

    public void setShowComboItem(boolean isShowComboItem) {
        this.isShowComboItem = isShowComboItem;
    }

    public class MenuItemTableModel
    extends PaginatedTableModel<MenuItem> {
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItem menuItem = (MenuItem)this.getRowData(rowIndex);
            MenuItem storedItem = (MenuItem)MenuItemSelectionView.this.addedMenuItemMap.get(menuItem.getId());
            switch (columnIndex) {
                case 0: {
                    return storedItem != null;
                }
                case 1: {
                    return menuItem.getDisplayName();
                }
                case 2: {
                    return menuItem.getPrice();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            throw new InternalError();
        }
    }
}

