/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MenuPageForm
extends BeanEditor {
    private FixedLengthTextField tfName;
    private IntegerTextField tfSortOrder;
    private IntegerTextField tfNumberOfColumns;
    private IntegerTextField tfNumberOfRows;
    private IntegerTextField tfButtonWidth;
    private IntegerTextField tfButtonHeight;
    private JCheckBox cbFlexibleButtonSize;
    private boolean isInfo;

    public MenuPageForm() {
        this(new MenuPage(), false);
    }

    public MenuPageForm(MenuPage menuPage, boolean isInfo) {
        this.isInfo = isInfo;
        this.initComponents();
        this.setBean(menuPage);
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout());
        this.tfName = new FixedLengthTextField();
        this.tfSortOrder = new IntegerTextField(10);
        this.tfNumberOfColumns = new IntegerTextField(10);
        this.tfNumberOfRows = new IntegerTextField(10);
        this.tfButtonWidth = new IntegerTextField(6);
        this.tfButtonHeight = new IntegerTextField(6);
        this.tfNumberOfColumns.setText("4");
        this.tfNumberOfRows.setText("4");
        JLabel lblName = new JLabel(POSConstants.NAME);
        contentPanel.add(lblName);
        contentPanel.add((Component)this.tfName, "wrap");
        JLabel lblSortOrder = new JLabel(POSConstants.SORT_ORDER);
        contentPanel.add(lblSortOrder);
        contentPanel.add((Component)this.tfSortOrder, "grow,wrap");
        contentPanel.add(new JLabel(Messages.getString("MenuPageForm.4")));
        contentPanel.add((Component)this.tfNumberOfColumns, "grow,wrap");
        contentPanel.add(new JLabel(Messages.getString("MenuPageForm.6")));
        contentPanel.add((Component)this.tfNumberOfRows, "grow");
        contentPanel.add((Component)new JLabel(Messages.getString("MenuPageForm.8")), "newline");
        contentPanel.add((Component)this.tfButtonWidth, "grow");
        contentPanel.add((Component)new JLabel(Messages.getString("MenuPageForm.11")), "newline");
        contentPanel.add((Component)this.tfButtonHeight, "grow");
        this.cbFlexibleButtonSize = new JCheckBox(Messages.getString("MenuPageForm.14"));
        contentPanel.add((Component)this.cbFlexibleButtonSize, "skip 1,newline,grow");
        if (this.isInfo) {
            contentPanel.remove(lblName);
            contentPanel.remove(this.tfName);
            contentPanel.remove(lblSortOrder);
            contentPanel.remove(this.tfSortOrder);
            this.tfButtonHeight.setText("100");
            this.tfButtonWidth.setText("100");
        }
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            return this.updateModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected void updateView() {
        MenuPage menuPage = (MenuPage)this.getBean();
        if (menuPage.getId() == null) {
            return;
        }
        this.tfName.setText(menuPage.getName());
        this.tfSortOrder.setText(String.valueOf(menuPage.getSortOrder()));
        this.tfNumberOfColumns.setText(String.valueOf(menuPage.getCols()));
        this.tfNumberOfRows.setText(String.valueOf(menuPage.getRows()));
        this.cbFlexibleButtonSize.setSelected(menuPage.isFlixibleButtonSize());
        this.tfButtonWidth.setText(String.valueOf(menuPage.getButtonWidth()));
        this.tfButtonHeight.setText(String.valueOf(menuPage.getButtonHeight()));
    }

    @Override
    protected boolean updateModel() {
        MenuPage menuPage = (MenuPage)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name) && !this.isInfo) {
            POSMessageDialog.showError(this, POSConstants.NAME_REQUIRED);
            return false;
        }
        int numberOfCol = this.tfNumberOfColumns.getInteger();
        if (numberOfCol < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ColSizeGreaterThanZero"));
            return false;
        }
        if (numberOfCol > 50) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ColSizeLessThanHundred"));
            return false;
        }
        int numberOfRows = this.tfNumberOfRows.getInteger();
        if (numberOfRows < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("RowsSizeGreaterThanZero"));
            return false;
        }
        if (numberOfRows > 50) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("RowsSizeLessThanHundred"));
            return false;
        }
        List<MenuPageItem> pageItems = menuPage.getPageItems();
        if (pageItems != null) {
            for (MenuPageItem menuPageItem : pageItems) {
                if (StringUtils.isBlank((String)menuPageItem.getMenuItemId())) continue;
                if (menuPageItem.getCol() >= numberOfCol) {
                    String message = String.format("If you set number of columns to %s some items will go out of range. Please change number of columns or move items.", numberOfCol);
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                    return false;
                }
                if (menuPageItem.getRow() < numberOfRows) continue;
                String message = String.format("If you set number of rows to %s some items will go out of range. Please change number of rows or move items.", numberOfRows);
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return false;
            }
        }
        int buttonWidth = this.tfButtonWidth.getInteger();
        boolean isSelectedFlexibleButtonSize = this.cbFlexibleButtonSize.isSelected();
        if (buttonWidth < 30 && !isSelectedFlexibleButtonSize) {
            POSMessageDialog.showError(this, Messages.getString("MenuPageForm.18"));
            return false;
        }
        if (buttonWidth > 300 && !isSelectedFlexibleButtonSize) {
            POSMessageDialog.showError(this, Messages.getString("ButtonWidthLessThan300"));
            return false;
        }
        int buttonHeight = this.tfButtonHeight.getInteger();
        if (buttonHeight < 30 && !isSelectedFlexibleButtonSize) {
            POSMessageDialog.showError(this, Messages.getString("MenuPageForm.19"));
            return false;
        }
        if (buttonHeight > 300 && !isSelectedFlexibleButtonSize) {
            POSMessageDialog.showError(this, Messages.getString("ButtonHeightLessThan300"));
            return false;
        }
        if (!this.isInfo) {
            menuPage.setName(name.trim());
            menuPage.setSortOrder(this.tfSortOrder.getInteger());
        } else {
            menuPage.setName(Messages.getString("MenuPageForm.0"));
        }
        menuPage.setCols(numberOfCol);
        menuPage.setRows(numberOfRows);
        menuPage.setFlixibleButtonSize(isSelectedFlexibleButtonSize);
        menuPage.setButtonWidth(buttonWidth);
        menuPage.setButtonHeight(buttonHeight);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuPage menuPage = (MenuPage)this.getBean();
        if (menuPage.getId() == null) {
            return Messages.getString("MenuPageForm.21");
        }
        return Messages.getString("MenuPageForm.22");
    }
}

