/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MultipleCustomerSelectionView
extends JPanel {
    private JXTable table;
    private BeanTableModel<Customer> tableModel;
    private JTextField tfName;
    private Customer parentCustomer;
    private JButton btnNext;
    private JButton btnPrev;
    private CustomerGroup selectedGroup;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton searchBttn;
    private JPanel searchPanel;
    private Map<String, Customer> addedCustomerMap = new HashMap<String, Customer>();
    private JCheckBox chkShowSelected;
    private JCheckBox chkSelectAll;
    private boolean singleSelectionEnable;

    public MultipleCustomerSelectionView(List<Customer> customerList) {
        this.init();
        this.tableModel.setCurrentRowIndex(0);
        this.setCustomer(customerList);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(Customer.class);
        this.tableModel.addColumn("", "selected");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.setPageSize(200);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(20));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MultipleCustomerSelectionView.this.selectItem();
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox(Messages.getString("MultipleCustomerSelectionView.0"));
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultipleCustomerSelectionView.this.chkShowSelected.isSelected()) {
                    MultipleCustomerSelectionView.this.tableModel.setRows(new ArrayList(MultipleCustomerSelectionView.this.addedCustomerMap.values()));
                    MultipleCustomerSelectionView.this.updateCustomerSelection();
                    MultipleCustomerSelectionView.this.doUpdateTextOfChkShowSelected();
                    MultipleCustomerSelectionView.this.lblNumberOfItem.setText("");
                    MultipleCustomerSelectionView.this.btnPrev.setEnabled(false);
                    MultipleCustomerSelectionView.this.btnNext.setEnabled(false);
                    MultipleCustomerSelectionView.this.table.repaint();
                } else {
                    MultipleCustomerSelectionView.this.searchItem();
                }
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        int iconSize = PosUIManager.getSize(16);
        this.btnPrev = new JButton();
        this.btnPrev.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new JButton();
        this.btnNext.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == MultipleCustomerSelectionView.this.btnPrev) {
                        MultipleCustomerSelectionView.this.scrollUp();
                    } else if (source == MultipleCustomerSelectionView.this.btnNext) {
                        MultipleCustomerSelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[][]"));
        this.lblName = new JLabel(POSConstants.NAME);
        this.tfName = new JTextField();
        this.searchBttn = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "grow");
        JButton btnSearch = new JButton(Messages.getString("Search"));
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCustomerSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.searchItem();
            }
        });
        this.searchPanel.add((Component)btnSearch, "wrap");
        this.chkSelectAll = new JCheckBox(Messages.getString("MultipleCustomerSelectionView.19"));
        this.chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCustomerSelectionView.this.selectGroupItems();
            }
        });
        this.searchPanel.add((Component)this.chkSelectAll, "left");
        this.searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCustomerSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCustomerSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    private void searchItem() {
        this.tableModel.setNumRows(CustomerDAO.getInstance().getRowCount(this.tfName.getText()));
        CustomerDAO.getInstance().loadCustomers(this.tfName.getText(), this.tableModel);
        this.doSetEnableCheckAll();
        this.updateButton();
        this.updateCustomerSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void selectGroupItems() {
        List<Customer> customers = this.tableModel.getRows();
        if (customers != null && customers.size() > 0) {
            for (Customer customer : customers) {
                if (this.parentCustomer != null && this.parentCustomer.getId() != null && this.parentCustomer.getId().equals(customer.getId())) continue;
                customer.setSelected(this.chkSelectAll.isSelected());
                if (customer.isSelected().booleanValue()) {
                    this.addedCustomerMap.put(customer.getId(), customer);
                    continue;
                }
                this.addedCustomerMap.remove(customer.getId());
            }
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MultipleCustomerSelectionView.21"));
            this.chkSelectAll.setSelected(false);
        }
        this.doUpdateTextOfChkShowSelected();
        this.table.repaint();
    }

    private void doUpdateTextOfChkShowSelected() {
        this.chkShowSelected.setText(Messages.getString("MultipleCustomerSelectionView.3") + "(" + this.addedCustomerMap.values().size() + ")");
    }

    private void updateCustomerSelection() {
        List<Customer> customers = this.tableModel.getRows();
        if (customers == null) {
            return;
        }
        Iterator<Customer> iterator = customers.iterator();
        while (iterator.hasNext()) {
            Customer customer;
            Customer existingCustomer = this.addedCustomerMap.get((customer = iterator.next()).getId());
            customer.setSelected(existingCustomer != null);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MultipleCustomerSelectionView.22"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.doUpdateTextOfChkShowSelected();
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCustomerSelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CustomerForm editor = new CustomerForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Customer foodItem = (Customer)editor.getBean();
                    MultipleCustomerSelectionView.this.tableModel.addRow(foodItem);
                    MultipleCustomerSelectionView.this.tableModel.setNumRows(MultipleCustomerSelectionView.this.tableModel.getNumRows() + 1);
                    MultipleCustomerSelectionView.this.updateButton();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(70);
        columnWidth.add(250);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Customer customer = this.tableModel.getRow(index);
            this.tableModel.setRow(index, customer);
            CustomerForm editor = new CustomerForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Customer> getSelectedCustomerList() {
        return new ArrayList<Customer>(this.addedCustomerMap.values());
    }

    public void setCustomer(List<Customer> customers) {
        if (customers != null) {
            for (Customer item : customers) {
                this.addedCustomerMap.put(item.getId(), item);
            }
        }
        this.searchItem();
    }

    public void setParentCustomer(Customer selectedCustomer) {
        this.parentCustomer = selectedCustomer;
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        this.searchItem();
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        this.searchItem();
    }

    public void setSelectedCustomerGroup(Object selectedItem) {
        this.selectedGroup = selectedItem instanceof CustomerGroup ? (CustomerGroup)selectedItem : null;
        this.searchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        if (this.singleSelectionEnable) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        Customer customer = this.tableModel.getRow(selectedRow);
        if (this.parentCustomer != null && this.parentCustomer.getId() != null && this.parentCustomer.getId().equals(customer.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MultipleCustomerSelectionView.28"));
            return;
        }
        customer.setSelected(customer.isSelected() == false);
        if (customer.isSelected().booleanValue()) {
            this.addedCustomerMap.put(customer.getId(), customer);
        } else {
            this.addedCustomerMap.remove(customer.getId());
        }
        this.doUpdateTextOfChkShowSelected();
        this.table.repaint();
    }

    private void doSetEnableCheckAll() {
    }

    public BeanTableModel<Customer> getModel() {
        return this.tableModel;
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSingleSelectionEnable(boolean enable) {
        this.singleSelectionEnable = enable;
        if (enable) {
            this.chkShowSelected.setVisible(false);
            this.chkSelectAll.setVisible(false);
            this.lblNumberOfItem.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnPrev.setVisible(false);
            TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
            columnModel.getColumnExt(0).setVisible(false);
            this.searchItem();
        }
    }

    public void setSelectedGroup(CustomerGroup customerGroup) {
        if (this.selectedGroup != null && this.selectedGroup.getId().equals(customerGroup.getId())) {
            return;
        }
        this.selectedGroup = customerGroup;
        this.searchItem();
    }
}

