/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.order.SeatOrganizeTableModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class SeatTransferDataHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor;
    private int[] indices;
    private int addIndex = -1;
    private int addCount;
    private JComponent source;
    private Object[] transferedObjects;
    private Cursor cursor = DragSource.DefaultMoveNoDrop;

    protected SeatTransferDataHandler() {
        this.localObjectFlavor = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", Messages.getString("TableDataTransferHandler.0"));
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.source = c;
        JTable table = (JTable)c;
        ListTableModel model = (ListTableModel)table.getModel();
        ArrayList list = new ArrayList();
        for (int i : this.indices = table.getSelectedRows()) {
            list.add(model.getRowData(i));
        }
        this.transferedObjects = list.toArray();
        return new DataHandler((Object)this.transferedObjects, this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        JTable table = (JTable)info.getComponent();
        boolean isDroppable = info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        table.setCursor(isDroppable ? DragSource.DefaultMoveDrop : this.cursor);
        return isDroppable;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!this.canImport(info)) {
            return false;
        }
        TransferHandler.DropLocation tdl = info.getDropLocation();
        if (!(tdl instanceof JTable.DropLocation)) {
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)tdl;
        JTable target = (JTable)info.getComponent();
        SeatOrganizeTableModel model = (SeatOrganizeTableModel)target.getModel();
        int index = dl.getRow();
        int max = model.getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        this.addIndex = index;
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Object[] values = (Object[])info.getTransferable().getTransferData(this.localObjectFlavor);
            if (Objects.equals(this.source, target)) {
                this.addCount = values.length;
            }
            for (int i = 0; i < values.length; ++i) {
                int idx = index++;
                model.insertRow(idx, values[i]);
                target.getSelectionModel().addSelectionInterval(idx, idx);
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        this.cleanup(c, action == 2);
    }

    private void cleanup(JComponent c, boolean remove) {
        if (remove && this.indices != null) {
            int i;
            c.setCursor(Cursor.getPredefinedCursor(0));
            SeatOrganizeTableModel model = (SeatOrganizeTableModel)((JTable)c).getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.indices.length; ++i) {
                    if (this.indices[i] < this.addIndex) continue;
                    int n = i;
                    this.indices[n] = this.indices[n] + this.addCount;
                }
            }
            for (i = this.indices.length - 1; i >= 0; --i) {
                model.delete(this.indices[i]);
            }
        }
        this.indices = null;
        this.addCount = 0;
        this.addIndex = -1;
    }

    public BufferedImage createImage(Component panel, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.print(g);
        return bi;
    }
}

