/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.NewBarTabAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.ShowTransactionsAuthorizationsAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.actions.TicketKitchenSentAction;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.BarTabSelectionView;
import com.floreantpos.ui.tableselection.DefaultShopTableButton;
import com.floreantpos.ui.tableselection.TableSelectionListener;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.jidesoft.swing.JideScrollPane;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DefaultTableSelectionView
extends TableSelectionView
implements ActionListener,
DataChangeListener,
TableSelectionListener,
IMqttMessageListener {
    private JPanel buttonsPanel;
    private static PosButton btnCancelDialog;
    private PosButton btnDone = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton btnCancel = new PosButton(POSConstants.CANCEL);
    private PosButton btnAuthorize = new PosButton(Messages.getString("DefaultTableSelectionView.5"));
    private PosBlinkButton btnRefresh;
    private ButtonGroup btnGroups = new ButtonGroup();
    private POSToggleButton btnGroup = new POSToggleButton(POSConstants.GROUP);
    private POSToggleButton btnHoldFire = new POSToggleButton(Messages.getString("DefaultTableSelectionView.0"));
    private POSToggleButton btnGuestCheck = new POSToggleButton(Messages.getString("DefaultTableSelectionView.1"));
    private POSToggleButton btnSplitCheck = new POSToggleButton(Messages.getString("DefaultTableSelectionView.3"));
    private POSToggleButton btnSettle = new POSToggleButton(Messages.getString("DefaultTableSelectionView.4"));
    private POSToggleButton btnReorder = new POSToggleButton("Reorder items");
    private PosButton btnGroupSettle = new PosButton(Messages.getString("DefaultTableSelectionView.7"));
    private POSToggleButton btnRelease = new POSToggleButton(Messages.getString("TableSelectionListener.2"));
    private POSToggleButton selectedActionButton;
    private Ticket selectedTicket;
    private Map<Integer, DefaultShopTableButton> tableButtonMap = new HashMap<Integer, DefaultShopTableButton>();
    private List<Integer> addedTableList = new ArrayList<Integer>();
    private List<Integer> releasesTableList = new ArrayList<Integer>();
    private BarTabSelectionView barTabSelectionView;
    private JPanel tableSelectionPanel;
    private PosButton btnNewBarTab;
    private JTabbedPane tabbedPane;
    private static DefaultTableSelectionView instance;

    public static DefaultTableSelectionView getInstance() {
        if (instance == null) {
            return new DefaultTableSelectionView();
        }
        return instance;
    }

    public DefaultTableSelectionView() {
        this.initComponents();
        this.initActions();
        this.subscribeToNotificationService();
    }

    private void initActions() {
        this.btnGroup.putClientProperty("buttonAction", TableSelectionListener.GROUP);
        this.btnRelease.putClientProperty("buttonAction", TableSelectionListener.RELEASE);
        this.btnSettle.putClientProperty("ticketAction", new SettleTicketAction(this));
        this.btnSplitCheck.putClientProperty("ticketAction", new SplitTicketAction(this));
        this.btnGuestCheck.putClientProperty("ticketAction", new ShowOrderInfoAction(this));
        this.btnHoldFire.putClientProperty("ticketAction", new TicketKitchenSentAction(this));
        this.btnReorder.putClientProperty("ticketAction", new ItemReorderAction(this));
        this.btnGroup.addActionListener(this);
        this.btnDone.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnHoldFire.addActionListener(this);
        this.btnGuestCheck.addActionListener(this);
        this.btnSplitCheck.addActionListener(this);
        this.btnSettle.addActionListener(this);
        this.btnReorder.addActionListener(this);
        this.btnRelease.addActionListener(this);
        this.btnDone.setVisible(false);
        this.btnCancel.setVisible(false);
    }

    private void subscribeToNotificationService() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroMqttClient.getInstance().subscribeToStore("MQTT-COMMAND", 0, (IMqttMessageListener)DefaultTableSelectionView.this);
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e.getMessage());
                }
            }
        }).start();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, POSConstants.TABLES, 2, 0);
        this.tableSelectionPanel = new JPanel(new BorderLayout(5, 5));
        this.tableSelectionPanel.setBorder(new CompoundBorder(titledBorder1, new EmptyBorder(2, 2, 2, 2)));
        this.buttonsPanel = new JPanel(new WrapLayout());
        JideScrollPane scrollPane = new JideScrollPane((Component)this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(60, 0));
        this.tableSelectionPanel.add((Component)scrollPane, "Center");
        this.barTabSelectionView = new BarTabSelectionView(this);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.createButtonActionPanel(), "East");
    }

    private JPanel createButtonActionPanel() {
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(null, "-", 2, 0);
        JPanel rightPanel = new JPanel(new BorderLayout(20, 20));
        rightPanel.setPreferredSize(PosUIManager.getSize(125, 0));
        rightPanel.setBorder(new CompoundBorder(titledBorder2, new EmptyBorder(2, 2, 6, 2)));
        JPanel actionBtnPanel = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "sg fill, grow", ""));
        this.btnGroup.setIcon(new ImageIcon(this.getClass().getResource("/images/plus.png")));
        this.btnNewBarTab = new PosButton(Messages.getString("DefaultTableSelectionView.10"));
        this.btnNewBarTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<ShopTable> selectedTables = DefaultTableSelectionView.this.getSelectedTables();
                new NewBarTabAction(DefaultTableSelectionView.this.orderType, selectedTables, Application.getPosWindow()).actionPerformed(e);
            }
        });
        this.btnGroups.add(this.btnGroup);
        this.btnGroups.add(this.btnHoldFire);
        this.btnGroups.add(this.btnGuestCheck);
        this.btnGroups.add(this.btnSplitCheck);
        this.btnGroups.add(this.btnSettle);
        this.btnGroups.add(this.btnReorder);
        this.btnGroups.add(this.btnRelease);
        actionBtnPanel.add((Component)this.btnGroup, "grow");
        actionBtnPanel.add((Component)this.btnNewBarTab, "grow");
        actionBtnPanel.add((Component)this.btnHoldFire, "grow");
        actionBtnPanel.add((Component)this.btnGuestCheck, "grow");
        actionBtnPanel.add((Component)this.btnSplitCheck, "grow");
        actionBtnPanel.add((Component)this.btnSettle, "grow");
        actionBtnPanel.add((Component)this.btnGroupSettle, "grow");
        actionBtnPanel.add((Component)this.btnReorder, "grow");
        actionBtnPanel.add((Component)this.btnAuthorize, "grow");
        actionBtnPanel.add((Component)this.btnRelease, "grow");
        actionBtnPanel.add((Component)this.btnDone, "grow");
        actionBtnPanel.add((Component)this.btnCancel, "grow");
        rightPanel.add(actionBtnPanel);
        JPanel southbuttonPanel = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "grow", ""));
        this.btnRefresh = new PosBlinkButton(POSConstants.REFRESH);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableSelectionView.this.refresh();
            }
        });
        this.btnAuthorize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ShowTransactionsAuthorizationsAction().execute();
            }
        });
        this.btnGroupSettle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new GroupSettleTicketAction(Application.getCurrentUser()).actionPerformed(null);
                DefaultTableSelectionView.this.rendererTables();
            }
        });
        southbuttonPanel.add((Component)this.btnRefresh, "grow");
        btnCancelDialog = new PosButton(POSConstants.CLOSE);
        btnCancelDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTableSelectionView.this.closeDialog(true);
            }
        });
        southbuttonPanel.add((Component)btnCancelDialog, "grow");
        rightPanel.add((Component)southbuttonPanel, "South");
        return rightPanel;
    }

    @Override
    public synchronized void rendererTables() {
        this.clearSelection();
        this.tableButtonMap.clear();
        this.buttonsPanel.removeAll();
        List<ShopTable> tables = ShopTableDAO.getInstance().findAllEnableTable();
        for (ShopTable shopTable : tables) {
            DefaultShopTableButton tableButton = this.tableButtonMap.get(shopTable.getId());
            if (tableButton == null) {
                tableButton = new DefaultShopTableButton(shopTable);
                tableButton.setTableSelectionListener(this);
                tableButton.updateView();
                this.tableButtonMap.put(shopTable.getId(), tableButton);
                this.buttonsPanel.add(tableButton);
                continue;
            }
            tableButton.setShopTable(shopTable);
            tableButton.updateView();
        }
        this.barTabSelectionView.updateView(this.orderType);
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    @Override
    public List<ShopTable> getSelectedTables() {
        ArrayList<ShopTable> tables = new ArrayList<ShopTable>();
        for (Integer shopTableId : this.addedTableList) {
            DefaultShopTableButton defaultShopTableButton = this.tableButtonMap.get(shopTableId);
            tables.add(defaultShopTableButton.getShopTable());
        }
        return tables;
    }

    @Override
    public void clearSelection() {
        Component tabComponentAt;
        this.addedTableList.clear();
        this.releasesTableList.clear();
        this.btnGroups.clearSelection();
        this.btnGroup.setVisible(true);
        this.btnHoldFire.setVisible(true);
        this.btnGuestCheck.setVisible(true);
        this.btnSplitCheck.setVisible(true);
        this.btnSettle.setVisible(true);
        this.btnGroupSettle.setVisible(true);
        this.btnAuthorize.setVisible(true);
        this.btnDone.setVisible(false);
        this.btnCancel.setVisible(false);
        this.selectedActionButton = null;
        if (this.getOrderType() != null) {
            if (this.getOrderType().isEnableReorder().booleanValue()) {
                this.btnReorder.setVisible(true);
            } else {
                this.btnReorder.setVisible(false);
            }
        }
        if ((tabComponentAt = this.tabbedPane.getSelectedComponent()) == this.barTabSelectionView) {
            this.btnGroup.setVisible(false);
            this.btnHoldFire.setVisible(false);
            this.btnGuestCheck.setVisible(this.isHomeViewMode());
            this.btnSplitCheck.setVisible(false);
            this.btnSettle.setVisible(this.isHomeViewMode());
            this.btnGroupSettle.setVisible(false);
            this.btnAuthorize.setVisible(true);
            this.btnRefresh.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object instanceof POSToggleButton) {
            this.selectedActionButton = (POSToggleButton)object;
        }
        if (object == this.btnGroup) {
            if (this.isCreateNewTicket()) {
                this.addedTableList.clear();
            }
            this.btnHoldFire.setVisible(false);
            this.btnGuestCheck.setVisible(false);
            this.btnSplitCheck.setVisible(false);
            this.btnSettle.setVisible(false);
            this.btnGroupSettle.setVisible(false);
            this.btnReorder.setVisible(false);
            this.btnAuthorize.setVisible(false);
            this.btnRelease.setVisible(false);
            this.btnDone.setVisible(true);
            this.btnCancel.setVisible(true);
        } else if (object == this.btnDone) {
            if (this.btnGroup.isSelected()) {
                this.doGroupAction();
            }
        } else if (object == this.btnCancel) {
            this.clearSelection();
            this.rendererTables();
            this.updateButtonsVisibility();
        }
    }

    private void doCreateNewTicket() {
        try {
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.isEmpty()) {
                this.clearSelection();
                return;
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), selectedTables, null);
            this.clearSelection();
        }
        catch (TicketAlreadyExistsException e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private boolean editTicket(Integer tableNumber) {
        this.closeDialog(false);
        Ticket ticketToEdit = this.tableButtonMap.get(tableNumber).getTicket();
        TicketDAO.getInstance().loadFullTicket(ticketToEdit);
        OrderView.getInstance().setCurrentTicket(ticketToEdit);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    private void doGroupAction() {
        if (this.getSelectedTables().isEmpty()) {
            POSMessageDialog.showError(Messages.getString("DefaultTableSelectionView.12"));
            return;
        }
        if (this.isCreateNewTicket()) {
            this.doCreateNewTicket();
        }
        this.closeDialog(false);
    }

    private void doReleaseTables() {
        Iterator<Integer> iterator = this.releasesTableList.iterator();
        while (iterator.hasNext()) {
            Integer removedTableId = iterator.next();
            DefaultShopTableButton button = this.tableButtonMap.get(removedTableId);
            ShopTable shopTable = button.getShopTable();
            if (this.addedTableList.contains(shopTable.getId())) {
                this.addedTableList.remove(shopTable.getId());
            }
            iterator.remove();
            button.setTicket(null);
        }
        this.clearSelection();
    }

    @Override
    public void setTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        this.ticket = ticket;
        List<ShopTable> tables = ShopTableDAO.getInstance().getTables(ticket);
        if (tables == null) {
            return;
        }
        this.addedTableList.clear();
        for (ShopTable shopTable : tables) {
            DefaultShopTableButton defaultShopTableButton = this.tableButtonMap.get(shopTable.getId());
            this.addedTableList.add(defaultShopTableButton.getShopTable().getId());
            defaultShopTableButton.updateView();
        }
    }

    @Override
    public void updateButtonsVisibility() {
        boolean homeViewMode = this.isHomeViewMode();
        btnCancelDialog.setVisible(!homeViewMode);
        this.btnHoldFire.setVisible(homeViewMode);
        this.btnGuestCheck.setVisible(homeViewMode);
        this.btnSplitCheck.setVisible(homeViewMode);
        this.btnSettle.setVisible(homeViewMode);
        this.btnGroupSettle.setVisible(homeViewMode);
        this.btnAuthorize.setVisible(homeViewMode);
        this.btnRelease.setVisible(homeViewMode);
    }

    @Override
    public void tableSelected(ShopTable table) {
        if (table == null) {
            return;
        }
        ShopTableStatus shopTableStatus = table.getShopTableStatus();
        DefaultShopTableButton button = this.tableButtonMap.get(table.getId());
        if (shopTableStatus.hasMultipleTickets() && !this.isTicketTransferMode()) {
            this.showSplitTickets(new TicketEditAction(), button.getTicket(), shopTableStatus);
        } else if (table.getTicketId() != null && !this.isTicketTransferMode()) {
            this.editTicket(table.getId());
        } else {
            if (!this.isCreateNewTicket() && !this.btnGroup.isSelected() && this.addedTableList.size() >= 1) {
                this.releasesTableList.addAll(this.addedTableList);
                this.doReleaseTables();
            }
            this.addedTableList.add(table.getId());
            if (this.isCreateNewTicket()) {
                this.closeDialog(false);
                this.doCreateNewTicket();
            }
        }
        this.closeDialog(false);
    }

    @Override
    public AbstractButton getTableActionButton() {
        return this.selectedActionButton;
    }

    @Override
    public List getAddedTableList() {
        return this.addedTableList;
    }

    @Override
    public List getReleasesTableList() {
        return this.releasesTableList;
    }

    @Override
    public void dataAdded(Object object) {
        this.updateView(object);
    }

    private void updateView(Object object) {
        if (object == null) {
            return;
        }
        Ticket updatedTicket = (Ticket)object;
        List<Integer> tableNumbers = updatedTicket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            DefaultShopTableButton button = this.tableButtonMap.get(tableNumber);
            if (updatedTicket.isClosed().booleanValue()) {
                button.setTicket(null);
                continue;
            }
            button.setTicket(updatedTicket);
        }
    }

    @Override
    public void dataChanged(Object object) {
        this.updateView(object);
    }

    @Override
    public void dataRemoved(Object object) {
        this.updateView(object);
    }

    @Override
    public Object getSelectedData() {
        return this.selectedTicket;
    }

    @Override
    public void dataSetUpdated() {
        this.rendererTables();
    }

    @Override
    public void tableActionSelected(ShopTable shopTable, AbstractAction action, Ticket ticket) {
        this.selectedTicket = ticket;
        ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
        DefaultShopTableButton button = this.tableButtonMap.get(shopTable.getId());
        if (shopTableStatus.hasMultipleTickets()) {
            this.showSplitTickets(action, button.getTicket(), shopTableStatus);
        } else {
            if (this.isCreateNewTicket()) {
                action.actionPerformed(null);
                this.closeDialog(false);
            }
            this.clearSelection();
            ticket = TicketService.getTicket(ticket.getId());
        }
    }

    private void showSplitTickets(AbstractAction selectedAction, Ticket selectedTicket, ShopTableStatus shopTaleStatus) {
        ArrayList<Ticket> splitTickets = new ArrayList<Ticket>();
        String action = "";
        if (selectedAction instanceof SendToKitchenAction) {
            action = POSConstants.SEND_TO_KITCHEN;
        } else if (selectedAction instanceof ShowOrderInfoAction) {
            action = POSConstants.ORDER_INFO;
        } else if (selectedAction instanceof SettleTicketAction) {
            action = POSConstants.SETTLE;
        } else if (selectedAction instanceof SplitTicketAction) {
            action = POSConstants.SPLIT_TICKET;
        } else if (selectedAction instanceof ItemReorderAction) {
            action = POSConstants.REORDER_TICKET_BUTTON_TEXT;
        } else if (selectedAction instanceof TicketKitchenSentAction) {
            action = POSConstants.SEND_TO_KITCHEN;
        } else {
            action = POSConstants.EDIT;
            splitTickets.add(null);
        }
        for (String ticketId : shopTaleStatus.getListOfTicketNumbers()) {
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(ticketId);
            if (ticket == null) continue;
            splitTickets.add(ticket);
        }
        if (splitTickets.size() == 1 && selectedAction instanceof ItemReorderAction) {
            ItemReorderAction itemReorderAction = new ItemReorderAction((Ticket)splitTickets.get(0));
            itemReorderAction.execute();
            this.clearSelection();
        } else {
            SplitedTicketSelectionDialog posDialog = new SplitedTicketSelectionDialog(splitTickets);
            posDialog.setDefaultCloseOperation(2);
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.isEmpty()) {
                DefaultShopTableButton shopTableButton = this.tableButtonMap.get(shopTaleStatus.getId());
                selectedTables.add(shopTableButton.getShopTable());
            }
            posDialog.setSelectedTables(selectedTables);
            posDialog.setOrderType(this.getOrderType());
            posDialog.setSelectedAction(action);
            posDialog.setSize(PosUIManager.getSize(800, 600));
            posDialog.open();
            this.rendererTables();
            if (posDialog.isCanceled()) {
                return;
            }
        }
        if (action.equals(POSConstants.EDIT)) {
            this.closeDialog(false);
        }
    }

    @Override
    public Ticket getTicket(Integer tableId) {
        return this.tableButtonMap.get(tableId).getTicket();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket updatedTicket = (Ticket)object;
        List<Integer> tableNumbers = updatedTicket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        for (Integer removedTableId : tableNumbers) {
            DefaultShopTableButton button = this.tableButtonMap.get(removedTableId);
            button.setTicket(null);
        }
    }

    @Override
    public void setOrderType(OrderType orderType) {
        super.setOrderType(orderType);
        if (orderType == null) {
            return;
        }
        this.tabbedPane.removeAll();
        this.btnNewBarTab.setVisible(orderType.isBarTab());
        if (orderType.isShowTableSelection().booleanValue()) {
            this.tabbedPane.addTab(Messages.getString("DefaultTableSelectionView.9"), this.tableSelectionPanel);
        }
        if (orderType.isBarTab().booleanValue()) {
            this.tabbedPane.addTab(Messages.getString("DefaultTableSelectionView.11"), this.barTabSelectionView);
        }
    }

    @Override
    public void refresh() {
        this.rendererTables();
        Component tabComponentAt = this.tabbedPane.getSelectedComponent();
        if (tabComponentAt == this.barTabSelectionView) {
            this.btnGroup.setVisible(false);
            this.btnHoldFire.setVisible(false);
            this.btnGuestCheck.setVisible(true);
            this.btnSplitCheck.setVisible(false);
            this.btnSettle.setVisible(true);
            this.btnGroupSettle.setVisible(false);
            this.btnAuthorize.setVisible(true);
        }
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        String command = new String(mqttMessage.getPayload());
        if ("1".equals(command) || "2".equals(command)) {
            this.btnRefresh.setBlinking(true);
        }
    }

    @Override
    public boolean shouldSettle() {
        return this.btnSettle.isSelected();
    }

    @Override
    public boolean shouldGuestCheck() {
        return this.btnGuestCheck.isSelected();
    }

    static {
        instance = null;
    }
}

