/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.order.OrderView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class TicketViewerTableModel
extends AbstractTableModel {
    private final JTable table;
    protected Ticket ticket;
    protected final HashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
    private boolean priceIncludesTax = false;
    private TicketViewerTableChangeListener listener;
    protected String[] columnNames = new String[]{Messages.getString("TicketViewerTableModel.0"), Messages.getString("TicketViewerTableModel.3")};
    private boolean forReciptPrint;
    private boolean printCookingInstructions;
    private boolean editable;
    private boolean organizeTable;

    public TicketViewerTableModel(JTable table) {
        this(table, null);
    }

    public TicketViewerTableModel(JTable table, Ticket ticket) {
        this.table = table;
        this.setTicket(ticket);
    }

    public int getItemCount() {
        return this.tableRows.size();
    }

    @Override
    public int getRowCount() {
        int size = this.tableRows.size();
        return size;
    }

    public int getActualRowCount() {
        return this.tableRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ITicketItem ticketItem = this.tableRows.get(String.valueOf(rowIndex));
        if (ticketItem == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                TicketItem item;
                String iconDisplay = "";
                String name = "";
                if (ticketItem instanceof TicketItem && !(item = (TicketItem)ticketItem).isTreatAsSeat().booleanValue() && item.getCourseName() != null) {
                    iconDisplay = "[" + item.getCourseName() + "]  ";
                }
                name = iconDisplay + ticketItem.getNameDisplay();
                return name;
            }
            case 1: {
                return ticketItem.getSubTotalAmountDisplay();
            }
        }
        return null;
    }

    protected void calculateRows() {
        TicketItemRowCreator.calculateTicketRows(this.ticket, this.tableRows, true);
    }

    public int addTicketItem(TicketItem ticketItemToAdd) {
        if (ticketItemToAdd.isHasModifiers().booleanValue() || ticketItemToAdd.isPizzaType().booleanValue()) {
            return this.addTicketItemToTicket(ticketItemToAdd);
        }
        Object[] values = this.tableRows.values().toArray();
        if (values == null || values.length == 0) {
            Double existingQty = ticketItemToAdd.getQuantity();
            return this.addTicketItemToTicket(ticketItemToAdd);
        }
        Object object = values[values.length - 1];
        if (object instanceof TicketItem) {
            TicketItem item = (TicketItem)object;
            String menuItemId = ticketItemToAdd.getMenuItemId();
            if (StringUtils.isEmpty((String)menuItemId) || menuItemId.equals("0")) {
                return this.addTicketItemToTicket(ticketItemToAdd);
            }
            if (!OrderView.getInstance().isReturnMode() && this.shouldIncreaseQtyOfPrevItem(ticketItemToAdd, item, menuItemId)) {
                Double existingQty = item.getQuantity();
                if (ticketItemToAdd.isFractionalUnit().booleanValue()) {
                    item.setFractionalUnit(true);
                    item.setQuantity(existingQty + ticketItemToAdd.getQuantity());
                    existingQty = item.getQuantity();
                } else {
                    item.setQuantity(existingQty + ticketItemToAdd.getQuantity());
                }
                this.fireTableRowsUpdated(values.length - 1, values.length - 1);
                return values.length - 1;
            }
        }
        Double existingQty = ticketItemToAdd.getQuantity();
        return this.addTicketItemToTicket(ticketItemToAdd);
    }

    private boolean shouldIncreaseQtyOfPrevItem(TicketItem ticketItemToAdd, TicketItem item, String menuItemId) {
        return menuItemId.equals(item.getMenuItemId()) && item.getQuantity() > 0.0 && item.isComboItem() == false && item.isPrintedToKitchen() == false && !item.isInventoryAdjusted() && item.getUnitPrice().equals(ticketItemToAdd.getUnitPrice()) && !item.isGiftCard();
    }

    private int addTicketItemToTicket(TicketItem ticketItem) {
        int oldRowCount = this.tableRows.size();
        this.ticket.addToticketItems(ticketItem);
        this.calculateRows();
        int newRowCount = this.tableRows.size();
        this.fireTableRowsInserted(oldRowCount, newRowCount);
        return newRowCount - 1;
    }

    public int addTicketDiscount(TicketDiscount ticketDiscount) {
        int oldRowCount = this.tableRows.size();
        this.ticket.addTodiscounts(ticketDiscount);
        this.calculateRows();
        int newRowCount = this.tableRows.size();
        this.fireTableRowsInserted(oldRowCount, newRowCount);
        return newRowCount - 1;
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            ticketItems.add(ticketItem);
            this.calculateRows();
            this.fireTableDataChanged();
        } else {
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            boolean exists = false;
            for (TicketItem item : ticketItems) {
                if (!item.getName().equals(ticketItem.getName())) continue;
                double itemCount = item.getQuantity();
                item.setQuantity(itemCount += ticketItem.getQuantity().doubleValue());
                exists = true;
                this.table.repaint();
                return;
            }
            if (!exists) {
                this.ticket.addToticketItems(ticketItem);
                this.calculateRows();
                this.fireTableDataChanged();
            }
        }
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return false;
        }
        List<TicketItem> ticketItems = this.ticket.getTicketItems();
        for (TicketItem item : ticketItems) {
            if (!item.getName().equals(ticketItem.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeModifier(TicketItem parent, TicketItemModifier modifierToDelete) {
        List<TicketItemModifier> ticketItemModifiers = parent.getTicketItemModifiers();
        Iterator<TicketItemModifier> iter = ticketItemModifiers.iterator();
        while (iter.hasNext()) {
            TicketItemModifier modifier = iter.next();
            if (modifier.getItemId() != modifierToDelete.getItemId()) continue;
            iter.remove();
            if (modifier.isPrintedToKitchen().booleanValue()) {
                this.ticket.addDeletedItems(modifier);
            }
            this.calculateRows();
            this.fireTableDataChanged();
            return;
        }
    }

    public Object delete(int index) {
        if (index < 0 || index >= this.tableRows.size()) {
            return null;
        }
        ITicketItem object = this.tableRows.get(String.valueOf(index));
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            int rowNum = ticketItem.getTableRowNum();
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            Iterator<TicketItem> iter = ticketItems.iterator();
            while (iter.hasNext()) {
                TicketItem item = iter.next();
                if (item.getTableRowNum() != rowNum) continue;
                iter.remove();
                if (item.isPrintedToKitchen().booleanValue() || item.getInventoryAdjustQty() > 0.0) {
                    this.ticket.addDeletedItems(item);
                }
                break;
            }
        } else if (object instanceof TicketItemModifier) {
            TicketItemModifier itemModifier = (TicketItemModifier)object;
            TicketItem ticketItem = itemModifier.getTicketItem();
            List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
            if (ticketItemModifiers != null) {
                Iterator<TicketItemModifier> iterator = ticketItemModifiers.iterator();
                while (iterator.hasNext()) {
                    TicketItemModifier element = iterator.next();
                    if (itemModifier.getTableRowNum() != element.getTableRowNum()) continue;
                    iterator.remove();
                    if (!element.isPrintedToKitchen().booleanValue()) continue;
                    this.ticket.addDeletedItems(element);
                }
            }
        } else if (object instanceof TicketItemCookingInstruction) {
            TicketItemCookingInstruction cookingInstruction = (TicketItemCookingInstruction)object;
            int tableRowNum = cookingInstruction.getTableRowNum();
            TicketItem ticketItem = null;
            while (tableRowNum > 0) {
                ITicketItem object2;
                if (!((object2 = this.tableRows.get(String.valueOf(--tableRowNum))) instanceof TicketItem)) continue;
                ticketItem = (TicketItem)object2;
                break;
            }
            if (ticketItem != null) {
                ticketItem.removeCookingInstruction(cookingInstruction);
            }
        } else if (object instanceof TicketItemDiscount) {
            TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)object;
            int tableRowNum = ticketItemDiscount.getTableRowNum();
            TicketItem ticketItem = null;
            while (tableRowNum > 0) {
                ITicketItem object2;
                if (!((object2 = this.tableRows.get(String.valueOf(--tableRowNum))) instanceof TicketItem)) continue;
                ticketItem = (TicketItem)object2;
                break;
            }
            if (ticketItem != null) {
                ticketItem.removeTicketItemDiscount(ticketItemDiscount);
                if (this.listener != null) {
                    this.listener.ticketDataChanged();
                }
            }
        }
        this.calculateRows();
        this.fireTableRowsDeleted(index, index);
        return object;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.editable && columnIndex == 0) {
            return this.get(rowIndex) instanceof TicketItemDiscount || this.organizeTable;
        }
        return false;
    }

    public void removeAll() {
        if (this.tableRows.size() <= 0) {
            return;
        }
        this.ticket.getTicketItems().clear();
        this.tableRows.clear();
        this.fireTableDataChanged();
    }

    public Object get(int index) {
        if (index < 0 || index >= this.tableRows.size()) {
            return null;
        }
        return this.tableRows.get(String.valueOf(index));
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        if (ticket != null && ticket.getOrderType() != null) {
            this.organizeTable = ticket.getOrderType().isEnableCourse();
        }
        this.update();
    }

    public void update() {
        this.calculateRows();
        this.fireTableDataChanged();
    }

    public boolean isForReciptPrint() {
        return this.forReciptPrint;
    }

    public void setForReciptPrint(boolean forReciptPrint) {
        this.forReciptPrint = forReciptPrint;
    }

    public boolean isPrintCookingInstructions() {
        return this.printCookingInstructions;
    }

    public void setPrintCookingInstructions(boolean printCookingInstructions) {
        this.printCookingInstructions = printCookingInstructions;
    }

    public boolean isPriceIncludesTax() {
        return this.priceIncludesTax;
    }

    public void setPriceIncludesTax(boolean priceIncludesTax) {
        this.priceIncludesTax = priceIncludesTax;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void addTicketDataChangeListener(TicketViewerTableChangeListener listener) {
        this.listener = listener;
    }

    public boolean isOrganizeTable() {
        return this.organizeTable;
    }
}

