/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket.returnui;

import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketItemPanel
extends JPanel {
    private TicketItem ticketItem;
    private JLabel lblName;
    private DoubleTextField tfQty;
    private POSToggleButton chkWillReturn;
    private PosButton incrementQuantitybtn;
    private PosButton decrementQuantitybtn;

    public TicketItemPanel(TicketItem ticketItem) {
        this.ticketItem = ticketItem;
        if (ticketItem.isReturned()) {
            this.setBackground(Color.GRAY);
        } else if (!ticketItem.isPaid()) {
            return;
        }
        this.lblName = new JLabel("<html>" + ticketItem.getNameDisplay() + "</html>");
        this.tfQty = new DoubleTextField(6);
        this.tfQty.setHorizontalAlignment(11);
        this.tfQty.setText(String.valueOf(ticketItem.getQuantity()));
        this.chkWillReturn = new POSToggleButton("Return");
        this.incrementQuantitybtn = new PosButton("+");
        this.incrementQuantitybtn.setFont(new Font("Arial", 0, 30));
        this.incrementQuantitybtn.setFocusable(false);
        this.incrementQuantitybtn.setPreferredSize(PosUIManager.getSize(40, 40));
        this.decrementQuantitybtn = new PosButton("-");
        this.decrementQuantitybtn.setPreferredSize(PosUIManager.getSize(40, 40));
        this.decrementQuantitybtn.setFont(new Font("Arial", 1, 30));
        this.decrementQuantitybtn.setFocusable(false);
        this.incrementQuantitybtn.addActionListener(e -> this.increment());
        this.decrementQuantitybtn.addActionListener(e -> this.decrement());
        this.setLayout((LayoutManager)new MigLayout("fill, ins 0"));
        this.add((Component)this.lblName, "grow, w " + PosUIManager.getSize(200) + "!");
        this.add((Component)this.decrementQuantitybtn, "grow");
        this.add((Component)this.tfQty, "growx, grow, w " + PosUIManager.getSize(80) + "!");
        this.add((Component)this.incrementQuantitybtn, "grow");
        this.add((Component)this.chkWillReturn, "grow");
        this.add((Component)new JSeparator(0), "newline, grow, span");
        this.disableButtonForReturnItem(!ticketItem.isReturned());
    }

    private void disableButtonForReturnItem(boolean returned) {
        this.incrementQuantitybtn.setEnabled(returned);
        this.decrementQuantitybtn.setEnabled(returned);
        this.chkWillReturn.setEnabled(returned);
    }

    private void increment() {
        double total;
        String text = this.tfQty.getText();
        if (StringUtils.isNotEmpty((String)text) && ((total = Double.parseDouble(text)) == Math.floor(total) || !Double.isInfinite(total))) {
            this.tfQty.setText("" + NumberUtil.trimDecilamIfNotNeeded(total += 1.0));
        }
    }

    public double getReturnQuantity() {
        return this.tfQty.getDouble();
    }

    public boolean isReturnSelected() {
        if (this.chkWillReturn == null) {
            return false;
        }
        return this.chkWillReturn.isSelected();
    }

    public TicketItem getTicketItem() {
        return this.ticketItem;
    }

    private void decrement() {
        double total;
        String text = this.tfQty.getText();
        if (StringUtils.isNotEmpty((String)text) && ((total = Double.parseDouble(text)) == Math.floor(total) || !Double.isInfinite(total)) && (total -= 1.0) >= 0.0) {
            this.tfQty.setText("" + NumberUtil.trimDecilamIfNotNeeded(total));
        }
    }
}

