/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket.returnui;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.returnui.TicketItemPanel;
import com.floreantpos.ui.views.voidticket.VoidTicketItemDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class TicketPanel
extends JPanel {
    private Ticket ticket;
    private JPanel itemsPanel;
    private boolean itemSelected;

    public TicketPanel(Ticket ticket) {
        this.ticket = ticket;
        this.setLayout((LayoutManager)new MigLayout("wrap 1, ins 5, fillx"));
        JPanel header = new JPanel((LayoutManager)new MigLayout("ins 0"));
        header.add((Component)new JLabel("Item"), "grow, w " + PosUIManager.getSize(200) + "!");
        header.add((Component)new JLabel("Quantity", 0), "grow, w " + PosUIManager.getSize(200) + "!");
        header.add((Component)new JSeparator(0), "newline, grow, span 2, w " + PosUIManager.getSize(430) + "!");
        this.add(header);
        this.itemsPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ins 0"));
        PosScrollPane scrollPane = new PosScrollPane(this.itemsPanel);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "grow");
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 2020);
        calendar.set(2, 3);
        calendar.set(5, 15);
        List<TicketItem> ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            if (ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue()) continue;
            if (!ticketItem.isPaid() && ticket.getDueAmount() <= 0.0) {
                ticketItem.setPaid(true);
            }
            TicketItemPanel ticketItemPanel = new TicketItemPanel(ticketItem);
            this.itemsPanel.add(ticketItemPanel);
        }
    }

    public Ticket performReturn() {
        Component[] components = this.itemsPanel.getComponents();
        ArrayList<TicketItem> toBeReturnedItems = new ArrayList<TicketItem>();
        this.itemSelected = false;
        for (Component component : components) {
            TicketItemPanel ticketItemPanel;
            if (!(component instanceof TicketItemPanel) || !(ticketItemPanel = (TicketItemPanel)component).isReturnSelected()) continue;
            TicketItem ticketItem = ticketItemPanel.getTicketItem();
            double returnQuantity = ticketItemPanel.getReturnQuantity();
            TicketItem returnItem = VoidTicketItemDialog.returnItem(this.ticket, ticketItem, returnQuantity, "Return", false);
            toBeReturnedItems.add(returnItem);
        }
        this.itemSelected = toBeReturnedItems.size() > 0;
        for (TicketItem ticketItem : toBeReturnedItems) {
            this.ticket.addToticketItems(ticketItem);
        }
        return this.ticket;
    }

    public boolean isItemSelected() {
        return this.itemSelected;
    }
}

