/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.SystemProperties;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.ServerSummaryReportAction;
import com.floreantpos.actions.ShowSfSyncDialogAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.EmployeeInOutHistoryDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.ClockedInUserListDialog;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ServerOpenTicketListDialog;
import com.floreantpos.ui.dialog.TipsDeclarationDialog;
import com.floreantpos.ui.forms.GeneratePasswordDialog;
import com.floreantpos.ui.util.PrintUtil;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.AuthorizableTicketBrowser;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class ClockInOutDialog
extends POSDialog
implements IMqttMessageListener {
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss aaa");
    private Timer clockTimer = new Timer(1000, new ClockTimerHandler());
    private PosButton btnChangePassword;
    private JLabel lblPicture;
    private JLabel lblUserName;
    private JLabel lblUserType;
    private JLabel lblCurrentTimeInfo;
    private JLabel lblTime;
    private JLabel lblRestaurantName;
    private JLabel lblUser;
    private JLabel lblTerminal;
    private JLabel lblOpenStoreStatus;
    private PosButton btnOpenStore;
    private PosButton btnStoreStatus;
    private PosButton btnCardBatchClose;
    private PosButton btnClockIn;
    private PosButton btnClockOut;
    private PosButton btnDriverIn;
    private PosButton btnNoSale = new PosButton(Messages.getString("ManagerDialog.1"));
    private PosButton btnCancel;
    private PosButton btnStaffBankStatus;
    private PosButton btnShowClockedInUsers;
    private PosButton btnAssignDrawer;
    private PosButton btnServerSummary;
    private PosButton btnTerminalStatus;
    private PosButton btnStartStaffBank;
    private PosButton btnOpenTickets;
    private JPanel loginRoleSelectionPanel;
    private PosButton btnTipsManagement;
    private PosButton btnDeclareTips;
    private PosButton btnAuthorize = new PosButton(POSConstants.AUTHORIZE_BUTTON_TEXT);
    private PosButton btnSfSync;
    private User currentUser;
    private boolean loginMode;
    private static ClockInOutDialog instance;
    private JLabel lblCurrentShift;
    private JLabel lblUserClockedStatus;
    private PosButton btnExit;
    private JPanel cashDrawerButtonPanel;
    private JTextArea txtMessage;

    public ClockInOutDialog() {
        super(Application.getPosWindow());
        this.setLayout(new BorderLayout(5, 5));
        int width = PosUIManager.getSize(250);
        Dimension size = Application.getPosWindow().getSize();
        String wrap = "";
        if (size.width < 1390) {
            wrap = ",wrap";
            width = 190;
        }
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 10 20 10 20,hidemode 3", "[][grow][]", ""));
        JPanel leftPictureAndInfoPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,filly,ins 0", "", "[grow][]"));
        JPanel userProfilePanel = new JPanel((LayoutManager)new MigLayout("wrap 1,center"));
        this.lblPicture = new JLabel("");
        this.lblPicture.setBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.1f), 5));
        this.lblUserName = new JLabel("");
        this.lblUserType = new JLabel("");
        Font f = this.lblUserName.getFont().deriveFont(1);
        this.lblUserName.setFont(f);
        this.lblUserType.setFont(f);
        this.btnChangePassword = new PosButton(Messages.getString("ClockInOutDialog.6"));
        this.btnChangePassword.addActionListener(e -> this.doChangePassword());
        userProfilePanel.add((Component)this.lblPicture, "center");
        userProfilePanel.add((Component)this.lblUserName, "center");
        userProfilePanel.add((Component)this.lblUserType, "center");
        JPanel leftProfilePanel = new JPanel(new BorderLayout());
        leftProfilePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("ClockInOutDialog.10"), 2, 2));
        JPanel changePassPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        changePassPanel.add((Component)this.btnChangePassword, "growx, gapleft 6,gapright 6,gapbottom 2");
        leftProfilePanel.add((Component)userProfilePanel, "Center");
        leftProfilePanel.add((Component)changePassPanel, "South");
        JPanel messagePanel = new JPanel(new BorderLayout());
        leftPictureAndInfoPanel.add((Component)leftProfilePanel, "aligny top,w " + width + "!,grow");
        this.txtMessage = new JTextArea(4, 4);
        this.txtMessage.setEditable(false);
        this.txtMessage.setBackground(Color.WHITE);
        this.txtMessage.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.txtMessage);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("ClockInOutDialog.15"), 2, 2), BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        messagePanel.add(scrollPane);
        contentPanel.add((Component)leftPictureAndInfoPanel, "growy");
        JPanel clockInOutActionPanel = new JPanel(new BorderLayout());
        clockInOutActionPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.lblCurrentTimeInfo = new JLabel();
        this.btnOpenStore = new PosButton("<html><center><h3>" + Messages.getString("OPENSTORE") + " & </h3>" + Messages.getString("ClockInOutAction.5") + "</center></html>");
        this.btnStoreStatus = new PosButton(Messages.getString("ClockInOutDialog.22"));
        this.btnCardBatchClose = new PosButton(Messages.getString("ClockInOutDialog.23"));
        this.btnOpenTickets = new PosButton(Messages.getString("ClockInOutDialog.24"));
        this.btnClockIn = new PosButton(Messages.getString("ClockInOutAction.5"));
        this.btnClockOut = new PosButton(Messages.getString("ClockInOutAction.6"));
        this.btnDriverIn = new PosButton(Messages.getString("ClockInOutDialog.27"));
        this.btnExit = new PosButton(Messages.getString("EXIT"));
        this.lblTime = new JLabel("");
        StringBuilder sb = new StringBuilder();
        sb.append(timeFormat.format(Calendar.getInstance().getTime()));
        this.lblTime.setText(sb.toString());
        this.lblTime.setHorizontalAlignment(0);
        JPanel centerPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)centerPanel, "grow");
        JPanel attendancePanel = new JPanel((LayoutManager)new MigLayout("wrap 1,hidemode 3,fill", "", "[][grow][][][]"));
        attendancePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("ClockInOutDialog.33"), 2, 2));
        Dimension btnSize = PosUIManager.getSize(130, 120);
        this.btnClockIn.setPreferredSize(btnSize);
        this.btnClockOut.setPreferredSize(btnSize);
        this.btnDriverIn.setPreferredSize(btnSize);
        this.btnOpenStore.setPreferredSize(btnSize);
        this.btnClockIn.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnClockOut.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnOpenStore.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnClockIn.setVerticalTextPosition(3);
        this.btnClockIn.setHorizontalTextPosition(0);
        this.btnOpenStore.setHorizontalTextPosition(0);
        this.btnOpenStore.setVerticalTextPosition(3);
        this.btnClockOut.setVerticalTextPosition(3);
        this.btnClockOut.setHorizontalTextPosition(0);
        Font font = new Font(this.btnClockIn.getFont().getName(), 1, 20);
        this.btnClockIn.setFont(font);
        this.btnClockOut.setFont(font);
        this.btnDriverIn.setFont(font);
        this.btnOpenStore.setFont(font);
        this.lblOpenStoreStatus = new JLabel(Messages.getString("ClockInOutDialog.40"));
        this.lblOpenStoreStatus.setFont(font);
        this.lblOpenStoreStatus.setForeground(Color.GRAY);
        this.lblCurrentShift = new JLabel(Messages.getString("ClockInOutDialog.41"));
        this.lblCurrentTimeInfo.setHorizontalAlignment(4);
        this.lblUserClockedStatus = new JLabel();
        this.lblUserClockedStatus.setHorizontalAlignment(0);
        JPanel shiftInfoPanel = new JPanel(new BorderLayout());
        shiftInfoPanel.add((Component)this.lblCurrentShift, "West");
        shiftInfoPanel.add((Component)this.lblUserClockedStatus, "South");
        shiftInfoPanel.add((Component)this.lblCurrentTimeInfo, "East");
        attendancePanel.add((Component)shiftInfoPanel, "growx");
        attendancePanel.add((Component)this.lblOpenStoreStatus, "center");
        attendancePanel.add((Component)this.btnOpenStore, "center");
        attendancePanel.add((Component)this.btnClockIn, "center");
        attendancePanel.add((Component)this.btnClockOut, "center");
        this.loginRoleSelectionPanel = new JPanel(new WrapLayout(0));
        clockInOutActionPanel.add((Component)this.loginRoleSelectionPanel, "North");
        clockInOutActionPanel.add(attendancePanel);
        this.btnAssignDrawer = new PosButton(Messages.getString("ClockInOutDialog.49"));
        this.btnServerSummary = new PosButton(Messages.getString("ClockInOutDialog.50"));
        this.btnTerminalStatus = new PosButton(Messages.getString("ClockInOutDialog.51"));
        this.btnShowClockedInUsers = new PosButton(Messages.getString("ClockInOutDialog.52"));
        this.btnStaffBankStatus = new PosButton(Messages.getString("ClockInOutDialog.53"));
        this.btnStartStaffBank = new PosButton(Messages.getString("START_STAFF_BANK"));
        this.btnTipsManagement = new PosButton(POSConstants.SERVER_TIPS);
        this.btnDeclareTips = new PosButton(Messages.getString("DeclareTips"));
        this.btnSfSync = new PosButton("Salesforce Sync");
        this.btnTipsManagement.addActionListener(e -> this.doManageGratuity());
        this.btnDeclareTips.addActionListener(e -> this.doDeclareTips());
        this.btnAuthorize.addActionListener(e -> this.doAuthorizeTickets());
        this.btnNoSale.addActionListener(e -> DrawerUtil.kickDrawer());
        this.btnOpenTickets.addActionListener(e -> this.doOpenTickets());
        this.btnSfSync.setAction(new ShowSfSyncDialogAction());
        JPanel buttonUserActionPanel = new JPanel((LayoutManager)new MigLayout("center,ins 5 5 5 5,hidemode 3,fillx", "", ""));
        this.btnCancel = new PosButton(Messages.getString("EXIT"));
        this.btnCancel.setHorizontalTextPosition(2);
        JPanel panel1 = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        this.cashDrawerButtonPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        panel1.add((Component)this.btnNoSale, "growx");
        panel1.add((Component)this.btnStoreStatus, "growx");
        panel1.add((Component)this.btnCardBatchClose, "grow");
        panel1.add((Component)this.btnOpenTickets, "growx");
        panel1.add((Component)this.btnAuthorize, "growx");
        panel1.add((Component)this.btnShowClockedInUsers, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnTipsManagement, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnDeclareTips, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnAssignDrawer, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnServerSummary, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnTerminalStatus, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnStaffBankStatus, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnStartStaffBank, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnSfSync, "growx");
        buttonUserActionPanel.add((Component)panel1, "growx" + wrap);
        buttonUserActionPanel.add((Component)this.cashDrawerButtonPanel, "newline,growx");
        buttonUserActionPanel.add((Component)this.btnCancel, "newline,span 9,center,growx");
        centerPanel.add((Component)buttonUserActionPanel, "South");
        centerPanel.add((Component)clockInOutActionPanel, "Center");
        contentPanel.add((Component)messagePanel, "aligny top,w " + width + "!,grow");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(BorderFactory.createLineBorder(this.getBackground(), 3));
        headerPanel.setBackground(Color.white);
        JLabel logoLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        JSeparator sep = new JSeparator();
        sep.setBackground(Color.white);
        headerPanel.add((Component)logoLabel, "West");
        headerPanel.add((Component)sep, "South");
        this.add((Component)headerPanel, "North");
        this.add(contentPanel);
        this.createFooterStatusPanel();
        this.initializeActions();
        this.showFooterTimer();
        this.clockTimer.start();
    }

    private void showHideForeteesActions() {
        this.btnCardBatchClose.setVisible(!SystemProperties.isForeTees());
        this.btnSfSync.setVisible(SystemProperties.isForeTees() && this.currentUser.isAdministrator());
    }

    private void doDeclareTips() {
        try {
            StoreSession currentSession = DataProvider.get().getStoreSession();
            List<DeclaredTips> declaredTips = DeclaredTipsDAO.getInstance().findBy(currentSession, this.currentUser);
            TipsDeclarationDialog dialog = new TipsDeclarationDialog(this.currentUser, currentSession, declaredTips);
            dialog.setTitle(POSConstants.DECLARE_TIPS);
            dialog.setSize(PosUIManager.getSize(630, 550));
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doAuthorizeTickets() {
        try {
            AuthorizableTicketBrowser dialog = new AuthorizableTicketBrowser(Application.getPosWindow(), this.currentUser, null);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(this);
            dialog.openFullScreen();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doManageGratuity() {
        try {
            if (!this.currentUser.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK) && !this.currentUser.hasPermission(UserPermission.PERFORM_MANAGER_TASK)) {
                POSMessageDialog.showMessage(this, Messages.getString("ClockInOutDialog.86"));
                return;
            }
            GratuityDialog dialog = new GratuityDialog((Window)this, this.currentUser);
            dialog.setCaption(Messages.getString("TipsManagement"));
            dialog.setOkButtonText(Messages.getString("PAY"));
            dialog.setSize(PosUIManager.getSize(780, 550));
            if (dialog.isCanceled()) {
                dialog.open();
            }
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return;
        }
    }

    protected void doShowClockedInUsers() {
        try {
            ClockedInUserListDialog userListDialog = new ClockedInUserListDialog(this.currentUser);
            userListDialog.pack();
            userListDialog.open();
            if (userListDialog.isDataUpdated()) {
                this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
                this.updateClockInOutButton(this.currentUser);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void initializeActions() {
        this.btnOpenStore.addActionListener(e -> this.doOpenStore());
        this.btnStoreStatus.addActionListener(e -> this.showDrawerAndStaffBankReportList());
        this.btnCardBatchClose.addActionListener(e -> this.doCloseCardBatch());
        this.btnServerSummary.addActionListener(e -> this.doOpenServerSummaryReport());
        this.btnClockIn.addActionListener(e -> this.performClockIn());
        this.btnClockOut.addActionListener(e -> this.performClockOut());
        this.btnDriverIn.addActionListener(e -> this.performDriverIn(this.currentUser));
        this.btnExit.addActionListener(e -> RootView.getInstance().showView(LoginView.getInstance()));
        this.btnAssignDrawer.addActionListener(e -> this.performAssignDrawer());
        this.btnTerminalStatus.addActionListener(e -> this.showTerminalStatus());
        this.btnShowClockedInUsers.addActionListener(e -> this.doShowClockedInUsers());
        this.btnStaffBankStatus.addActionListener(e -> this.showStaffBankStatus());
        this.btnStartStaffBank.addActionListener(e -> this.startStaffBank());
        this.btnCancel.addActionListener(e -> this.doCancel());
    }

    private void createFooterStatusPanel() {
        JPanel statusBarContainer = new JPanel(new BorderLayout());
        statusBarContainer.add((Component)new JSeparator(0), "North");
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5", "[]20px[]20px[]", "[]"));
        infoPanel.setOpaque(true);
        this.lblRestaurantName = new JLabel();
        Font f = this.lblRestaurantName.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.lblTerminal = new JLabel(Messages.getString("ClockInOutDialog.98") + TerminalConfig.getTerminalId());
        this.lblUser = new JLabel();
        this.lblTime = new JLabel("");
        this.lblTime.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblRestaurantName.setFont(f);
        this.lblUser.setFont(f);
        this.lblTerminal.setFont(f);
        this.lblTime.setFont(f);
        infoPanel.add(this.lblRestaurantName);
        infoPanel.add(this.lblTerminal);
        infoPanel.add(this.lblUser);
        statusBarContainer.add((Component)infoPanel, "West");
        statusBarContainer.add((Component)this.lblTime, "East");
        this.add((Component)statusBarContainer, "South");
        if (TerminalConfig.isKioskMode()) {
            statusBarContainer.setVisible(false);
        }
    }

    public void rendererFooterInfo() {
        User currentUser = Application.getCurrentUser();
        if (currentUser != null) {
            this.lblUser.setText("");
        } else {
            this.lblUser.setText("");
        }
        this.lblRestaurantName.setText(DataProvider.get().getStore().getName());
    }

    public static ClockInOutDialog getInstance(User user, boolean loginMode) {
        if (instance == null) {
            instance = new ClockInOutDialog();
        }
        instance.updateView(user, loginMode);
        instance.rendererUserRole();
        return instance;
    }

    private void updateView(User selectedUser, boolean isLoginMode) {
        try {
            this.currentUser = selectedUser;
            if (Application.getCurrentUser() == null) {
                Application.getInstance().setCurrentUser(this.currentUser);
            }
            this.loginMode = isLoginMode;
            if (selectedUser == null) {
                return;
            }
            this.lblUserName.setText(selectedUser.getFullName());
            Shift currentShift = ShiftUtil.getCurrentShift();
            String currentShiftName = "<html><center><b>" + Messages.getString("ClockInOutDialog.41") + "</b><br>";
            if (currentShift != null) {
                currentShiftName = currentShiftName + currentShift.getName();
            }
            currentShiftName = currentShiftName + "</center></html>";
            this.lblCurrentShift.setText(currentShiftName);
            String userOtherInfo = "<html><center>" + selectedUser.getType().getName();
            userOtherInfo = userOtherInfo + Messages.getString("ClockInOutDialog.101") + (selectedUser.isStaffBank() != false ? Messages.getString("ClockInOutDialog.102") : Messages.getString("ClockInOutDialog.103"));
            if (selectedUser.isStaffBank().booleanValue()) {
                userOtherInfo = userOtherInfo + Messages.getString("ClockInOutDialog.104") + (selectedUser.isAutoStartStaffBank() != false ? Messages.getString("ClockInOutDialog.102") : Messages.getString("ClockInOutDialog.103"));
            }
            userOtherInfo = userOtherInfo + "</center></html>";
            this.lblUserType.setText(userOtherInfo);
            ImageIcon memberImage = selectedUser.getImage();
            if (memberImage != null) {
                this.lblPicture.setIcon(memberImage);
            } else {
                this.setDefaultUserPicture();
            }
            Store store = DataProvider.get().getStore();
            if (store.getBooleanProperty("hide_server_summary_button.in_user_view", false)) {
                this.btnServerSummary.setVisible(false);
            } else {
                this.btnServerSummary.setVisible(true);
            }
            this.updateClockInOutButton(selectedUser);
            this.rendererFooterInfo();
            this.showHideForeteesActions();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void rendererUserRole() {
        this.loginRoleSelectionPanel.removeAll();
        this.loginRoleSelectionPanel.setBorder(null);
        if (this.currentUser.isClockedIn().booleanValue() || !this.currentUser.hasLinkedUser()) {
            this.loginRoleSelectionPanel.setVisible(false);
            return;
        }
        List<User> linkedUserList = this.currentUser.getRoles();
        this.loginRoleSelectionPanel.setVisible(true);
        EmptyBorder emptyBorder = new EmptyBorder(2, 5, 5, 5);
        this.loginRoleSelectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("ClockInOutDialog.108"), 2, 2), emptyBorder));
        ButtonGroup roleButtonGroup = new ButtonGroup();
        for (User roleUser : linkedUserList) {
            POSToggleButton btnRole = new POSToggleButton(roleUser.getType().getName());
            btnRole.addActionListener(e -> this.peroformRole(e));
            btnRole.putClientProperty("roleUser", roleUser);
            this.loginRoleSelectionPanel.add((Component)btnRole, "growx");
            roleButtonGroup.add(btnRole);
            if (roleUser.getType().getName().equals(this.currentUser.getType().getName())) {
                btnRole.setSelected(true);
            }
            btnRole.setEnabled(this.currentUser.isClockedIn() == false);
        }
    }

    private void updateClockInOutButton(User user) {
        boolean storeOpen = StoreUtil.isStoreOpen();
        this.btnClockOut.setVisible(storeOpen && user.isClockedIn() != false);
        this.btnClockIn.setVisible(storeOpen && user.isClockedIn() == false);
        this.btnDriverIn.setVisible(false);
        Date date = new Date();
        String currentDate = DateUtil.formatDateWithTimeAndSec(date);
        if (user.isClockedIn().booleanValue()) {
            this.lblUserClockedStatus.setText(Messages.getString("ClockInOutDialog.113") + user.getType().getName());
            if (user.getLastClockInTime() != null) {
                this.lblCurrentTimeInfo.setText("<html><center><b>" + Messages.getString("ClockInTime") + "</b></center>" + DateUtil.formatDateWithTimeAndSec(user.getLastClockInTime()) + "</html>");
            }
        } else {
            this.lblUserClockedStatus.setText(Messages.getString("ClockInOutDialog.116"));
            this.lblCurrentTimeInfo.setText("<html><center>" + currentDate + "</center></html>");
        }
        if (user.isDriver().booleanValue() && storeOpen && user.isClockedIn().booleanValue() && !user.isAvailableForDelivery().booleanValue()) {
            this.btnDriverIn.setVisible(true);
        }
        this.updateButtonStatus();
    }

    private void setDefaultUserPicture() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/images/generic-profile-pic-v2.png");
            byte[] picture2 = IOUtils.toByteArray((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            this.lblPicture.setIcon(new ImageIcon(new ImageIcon(picture2).getImage().getScaledInstance(150, 160, 4)));
        }
        catch (IOException e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void showDrawerAndStaffBankReportList() {
        try {
            DrawerAndStaffBankReportDialog dialog = new DrawerAndStaffBankReportDialog(this.currentUser);
            dialog.setInfo(Messages.getString("ClockInOutDialog.119"));
            dialog.open();
            this.updateButtonStatus();
            if (StoreUtil.isStoreOpen()) {
                return;
            }
            User currentUser = Application.getCurrentUser();
            if (currentUser == null || currentUser.getId().equals(currentUser.getId())) {
                Application.getInstance().setCurrentUser(null);
                Application.getPosWindow().rendererUserInfo();
                RootView.getInstance().showView("LOGIN_VIEW");
                this.dispose();
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, ex.getMessage(), ex);
        }
    }

    private void showStaffBankStatus() {
        try {
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.currentUser, this.currentUser.getActiveDrawerPullReport());
            dialog.setTitle(Messages.getString("ClockInOutDialog.120"));
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.openFullScreen();
            this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.txtMessage.setText("");
        if (aFlag) {
            this.startTimer();
            try {
                OroMqttClient.getInstance().subscribeToStore("noti-message", 0, (IMqttMessageListener)this);
            }
            catch (Exception exception) {}
        } else {
            this.stopTimer();
            try {
                OroMqttClient.getInstance().unsubscribe("noti-message");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setVisible(aFlag);
    }

    private void startTimer() {
        this.clockTimer.start();
    }

    private void stopTimer() {
        this.clockTimer.stop();
    }

    private void showFooterTimer() {
        this.lblTime.setText(timeFormat.format(Calendar.getInstance().getTime()));
    }

    private void performClockOut() {
        try {
            if (TicketDAO.getInstance().hasOpenTickets(this.currentUser)) {
                ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(this.currentUser, this.currentUser, true);
                dialog.setTitle(Messages.getString("ClockInOutDialog.121"));
                dialog.setSize(PosUIManager.getSize(830, 550));
                dialog.open();
                if (dialog.isCanceled()) {
                    if (!this.currentUser.isAllowClockOutWithOpenTickets() && dialog.hasOpenTickets()) {
                        POSMessageDialog.showError(Messages.getString("ClockInOutDialog.0"));
                    }
                    return;
                }
            }
            if (POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("ClockInOutDialog.122"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            CashDrawer activeDrawerPullReport = this.currentUser.getActiveDrawerPullReport();
            if (activeDrawerPullReport != null && activeDrawerPullReport.getDrawerType() == DrawerType.STAFF_BANK && activeDrawerPullReport.isOpen()) {
                POSMessageDialog.showMessage(this, Messages.getString("ClockInOutDialog.124"));
                return;
            }
            this.doClockedOutUser(this.currentUser);
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void performClockIn(User clockInuser) {
        try {
            if (clockInuser == null) {
                return;
            }
            if (!StoreUtil.isStoreOpen()) {
                StoreUtil.openStore(this.currentUser);
            }
            if (clockInuser.isClockedIn() != null && clockInuser.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(this, clockInuser.getFirstName() + " " + clockInuser.getLastName() + Messages.getString("ClockInOutAction.13"));
                return;
            }
            if (clockInuser.isAutoStartStaffBank().booleanValue()) {
                this.doClockedInUser(true);
            } else if (clockInuser.isStaffBank().booleanValue()) {
                final POSDialog dialog = new POSDialog((Dialog)this, true);
                dialog.setTitle(Messages.getString("ClockInOutAction.4"));
                PosButton btnStartStaffBank = new PosButton(Messages.getString("START_STAFF_BANK"));
                btnStartStaffBank.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClockInOutDialog.this.doClockedInUser(true);
                        dialog.dispose();
                    }
                });
                PosButton btnClose = new PosButton(Messages.getString("CashDropDialog.6"));
                btnClose.setPreferredSize(new Dimension(150, 120));
                btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClockInOutDialog.this.doClockedInUser(false);
                        dialog.dispose();
                    }
                });
                JPanel contentPane = (JPanel)dialog.getContentPane();
                contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
                contentPane.setLayout(new GridLayout(1, 0, 10, 10));
                contentPane.add(btnStartStaffBank);
                contentPane.add(btnClose);
                dialog.pack();
                dialog.open();
            } else {
                this.doClockedInUser(false);
            }
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doClockedInUser(boolean startStaffBank) {
        try {
            Shift currentShift = ShiftUtil.getCurrentShift();
            Calendar currentTime = Calendar.getInstance();
            this.currentUser.doClockIn(Application.getInstance().getTerminal(), currentShift, currentTime);
            String userName = this.currentUser.getFirstName() + " " + this.currentUser.getLastName() + " ";
            String msg = userName + Messages.getString("ClockInOutAction.16");
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                PrintUtil.printClockInOutReport(this.currentUser, this);
            }
            if (startStaffBank) {
                this.performStartStaffBank(this.currentUser);
            }
            this.rendererUserRole();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doClockedOutUser(User user) throws Exception {
        try {
            User currentUser;
            if (user == null) {
                return;
            }
            boolean clockedIn = UserDAO.getInstance().isClockedIn(user);
            if (!clockedIn) {
                throw new PosException(Messages.getString("ClockInOutDialog.125"));
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                Date lastClockInTime = user.getLastClockInTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockInTime);
                attendenceHistory.setClockInTime(lastClockInTime);
                attendenceHistory.setClockInHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, shift, calendar);
            String msg = user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10");
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                PrintUtil.printClockInOutReport(user, this);
            }
            if ((currentUser = Application.getCurrentUser()) != null && currentUser.getId().equals(user.getId())) {
                Application.getInstance().setCurrentUser(null);
                Application.getPosWindow().rendererUserInfo();
                RootView.getInstance().showView(LoginView.getInstance());
            }
            this.rendererUserRole();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void performDriverOut(User user) {
        try {
            if (user == null) {
                return;
            }
            Shift currentShift = ShiftUtil.getCurrentShift();
            Terminal terminal = Application.getInstance().getTerminal();
            Calendar currentTime = Calendar.getInstance();
            user.setAvailableForDelivery(false);
            user.setLastClockOutTime(currentTime.getTime());
            LogFactory.getLog(Application.class).info((Object)("terminal id befor saving clockIn=" + terminal.getId()));
            EmployeeInOutHistory attendenceHistory = new EmployeeInOutHistory();
            attendenceHistory.setOutTime(currentTime.getTime());
            attendenceHistory.setOutHour((short)currentTime.get(11));
            attendenceHistory.setClockOut(true);
            attendenceHistory.setUser(user);
            attendenceHistory.setTerminal(terminal);
            attendenceHistory.setShift(currentShift);
            UserDAO.getInstance().saveDriverOut(user, attendenceHistory, currentShift, currentTime);
            String message = String.format(Messages.getString("DriverOut"), user.getFirstName(), user.getLastName());
            POSMessageDialog.showMessage(message);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void performDriverIn(User user) {
        try {
            if (user == null) {
                return;
            }
            if (!StoreUtil.isStoreOpen()) {
                StoreUtil.openStore(this.currentUser);
            }
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(this, Messages.getString("ClockInOutAction.2"));
                return;
            }
            EmployeeInOutHistoryDAO attendenceHistoryDAO = new EmployeeInOutHistoryDAO();
            EmployeeInOutHistory attendenceHistory = attendenceHistoryDAO.findDriverHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new EmployeeInOutHistory();
                Date lastClockOutTime = user.getLastClockOutTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockOutTime);
                attendenceHistory.setOutTime(lastClockOutTime);
                attendenceHistory.setOutHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(true);
            attendenceHistory.setClockOut(false);
            attendenceHistory.setInTime(calendar.getTime());
            attendenceHistory.setInHour((short)calendar.get(11));
            UserDAO.getInstance().saveDriverIn(user, attendenceHistory, shift, calendar);
            String message = String.format(Messages.getString("DriverIn"), user.getFirstName(), user.getLastName());
            POSMessageDialog.showMessage(message);
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public boolean isLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(boolean loginMode) {
        this.loginMode = loginMode;
    }

    public void performStartStaffBank(User bankUser) {
        try {
            UserDAO.getInstance().startStaffBank(bankUser);
            POSMessageDialog.showMessage(Messages.getString("ClockInOutDialog.126"));
            this.updateClockInOutButton(this.currentUser);
            Application.getInstance().refreshCurrentUser();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void updateButtonStatus() {
        Terminal currentTerminal = Application.getInstance().getTerminal();
        boolean hasStoreAccess = this.currentUser.hasPermission(UserPermission.OPEN_CLOSE_STORE);
        boolean storeOpen = StoreUtil.isStoreOpen();
        boolean userClockedIn = this.currentUser.isClockedIn();
        this.btnStoreStatus.setVisible(storeOpen && hasStoreAccess && userClockedIn);
        this.btnCardBatchClose.setVisible(storeOpen && hasStoreAccess && userClockedIn);
        this.btnOpenStore.setVisible(!storeOpen && hasStoreAccess);
        if (storeOpen) {
            String storeOpenTime = "";
            StoreSession currentStoreSession = DataProvider.get().getStoreSession();
            if (currentStoreSession != null) {
                storeOpenTime = DateUtil.formatDateWithTimeAndSec(currentStoreSession.getOpenTime());
            }
            this.lblOpenStoreStatus.setText(Messages.getString("ClockInOutDialog.3") + " " + storeOpenTime);
        } else {
            this.lblOpenStoreStatus.setText(Messages.getString("ClockInOutDialog.4"));
        }
        this.btnOpenTickets.setVisible(storeOpen && userClockedIn);
        this.btnShowClockedInUsers.setVisible(storeOpen);
        this.btnTipsManagement.setVisible(storeOpen && userClockedIn && this.currentUser.isManager());
        this.btnDeclareTips.setVisible(storeOpen && userClockedIn);
        this.btnAuthorize.setVisible(storeOpen && userClockedIn && (this.currentUser.hasPermission(UserPermission.AUTHORIZE_TICKETS) || this.currentUser.hasPermission(UserPermission.AUTHORIZE_OWN_TICKETS)));
        this.btnStartStaffBank.setVisible(userClockedIn && this.currentUser.isStaffBank() != false && this.currentUser.isStaffBankStarted() == false);
        this.btnStaffBankStatus.setVisible(userClockedIn && this.currentUser.isStaffBankStarted() != false);
        this.btnSfSync.setVisible(SystemProperties.isForeTees() && this.currentUser.isAdministrator());
        if ((this.currentUser.isAdministrator() || this.currentUser.isManager()) && userClockedIn && currentTerminal.isHasCashDrawer().booleanValue()) {
            if (currentTerminal.isCashDrawerAssigned()) {
                this.btnAssignDrawer.setVisible(false);
                this.btnTerminalStatus.setVisible(true);
            } else {
                this.btnAssignDrawer.setVisible(true);
                this.btnTerminalStatus.setVisible(false);
            }
        } else {
            this.btnAssignDrawer.setVisible(false);
            this.btnTerminalStatus.setVisible(false);
        }
        this.cashDrawerButtonPanel.setVisible(this.btnTipsManagement.isVisible() || this.btnDeclareTips.isVisible() || this.btnAssignDrawer.isVisible() || this.btnTerminalStatus.isVisible() || this.btnStartStaffBank.isVisible() || this.btnStaffBankStatus.isVisible());
    }

    private void doChangePassword() {
        try {
            GeneratePasswordDialog changePasswordDialog;
            String message = Messages.getString("ClockInOutDialog.128");
            Window focusedWindow = POSUtil.getFocusedWindow();
            if (PasswordEntryDialog.verifyPassword(this.currentUser, focusedWindow, message, message)) {
                changePasswordDialog = new GeneratePasswordDialog();
                changePasswordDialog.setSize(530, 340);
                changePasswordDialog.open();
                if (changePasswordDialog.isCanceled()) {
                    POSMessageDialog.showMessage(this, Messages.getString("ClockInOutDialog.129"));
                    return;
                }
            } else {
                return;
            }
            String newPassword = changePasswordDialog.getGenPassword();
            this.currentUser.setPassword(AESencrp.encrypt((String)newPassword));
            UserDAO.getInstance().update(this.currentUser);
            POSMessageDialog.showMessage(this, Messages.getString("ClockInOutDialog.130"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void dispose() {
        this.stopTimer();
        super.dispose();
    }

    private void doCloseCardBatch() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ClockInOutDialog.132"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        try {
            Integer id = DataProvider.get().getCurrentTerminal().getId();
            List<String> gateways = PosTransactionDAO.getInstance().getDistinctCardMmerchantGateway(null, id);
            if (gateways.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("NoBatchClosed"));
                return;
            }
            gateways.forEach(gateway -> {
                PaymentGatewayPlugin plugin = CardConfig.getPaymentGatewayByName(gateway);
                if (plugin != null) {
                    plugin.getProcessor().closeBatch(DataProvider.get().getCurrentTerminal(), this.currentUser);
                }
            });
            POSMessageDialog.showMessage(Messages.getString("ClockInOutDialog.134"));
        }
        catch (Exception e0) {
            POSMessageDialog.showError(this, Messages.getString("MessageDialog.0") + e0.getMessage(), e0);
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.txtMessage.append("\n" + new String(message.getPayload()));
    }

    private void doOpenTickets() {
        try {
            if (this.currentUser.hasPermission(UserPermission.EDIT_OTHER_USERS_TICKETS)) {
                ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(this.currentUser, null, false);
                dialog.setTitle(Messages.getString("ClockInOutDialog.56"));
                dialog.setSize(PosUIManager.getSize(830, 550));
                dialog.open();
            } else {
                ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(this.currentUser, this.currentUser, true);
                dialog.setTitle(Messages.getString("ClockInOutDialog.56"));
                dialog.setSize(PosUIManager.getSize(830, 550));
                dialog.open();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doOpenStore() {
        try {
            String question = Messages.getString("ClockInOutDialog.1");
            int option = POSMessageDialog.showYesNoQuestionDialog(this, question, POSConstants.CONFIRM);
            if (option != 0) {
                return;
            }
            StoreUtil.openStore(this.currentUser);
            POSMessageDialog.showMessage(this, Messages.getString("ClockInOutDialog.2"));
            this.performClockIn(this.currentUser);
            this.updateButtonStatus();
        }
        catch (StoreAlreadyOpenException e2) {
            POSMessageDialog.showError(this, e2.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    private void doOpenServerSummaryReport() {
        try {
            ServerSummaryReportAction action = new ServerSummaryReportAction(this.currentUser);
            action.execute();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, e1.getMessage(), e1);
        }
    }

    private void performClockIn() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ClockInOutDialog.89"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        this.performClockIn(this.currentUser);
    }

    private void performAssignDrawer() {
        try {
            if (!this.currentUser.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("ClockInOutDialog.91"));
                return;
            }
            DrawerAssignmentAction drawerAction = new DrawerAssignmentAction(Application.getInstance().getTerminal(), this.currentUser);
            drawerAction.execute();
            this.updateButtonStatus();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, e1.getMessage(), e1);
        }
    }

    private void showTerminalStatus() {
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            CashDrawerReportDialog statusDialog = new CashDrawerReportDialog(terminal.getAssignedUser(), terminal.getCurrentCashDrawer());
            statusDialog.setTitle(Messages.getString("ClockInOutDialog.92"));
            statusDialog.refreshReport();
            statusDialog.setDefaultCloseOperation(2);
            statusDialog.openFullScreen();
            Application.getInstance().refreshAndGetTerminal();
            this.updateButtonStatus();
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, ex.getMessage(), ex);
        }
    }

    private void startStaffBank() {
        try {
            if (!this.currentUser.isClockedIn().booleanValue()) {
                POSMessageDialog.showError(Messages.getString("ClockInOutDialog.93"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("ClockInOutDialog.94"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return;
            }
            this.performStartStaffBank(this.currentUser);
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, e1.getMessage(), e1);
        }
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    private void peroformRole(ActionEvent e) {
        try {
            POSToggleButton btnRoleUser = (POSToggleButton)e.getSource();
            this.currentUser = (User)btnRoleUser.getClientProperty("roleUser");
            this.updateView(this.currentUser, this.loginMode);
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClockInOutDialog.this.showFooterTimer();
        }
    }
}

