/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardDeActiveView
extends POSDialog {
    private JTextField txtCardNumber;
    private GiftCard giftCard;
    private GiftCardProcessor giftCardProcessor;

    public GiftCardDeActiveView(GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.init();
    }

    public GiftCardDeActiveView(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Card Deactivate");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("CardNumber"));
        this.txtCardNumber = new JTextField(20);
        centerPanel.add((Component)lblNumberOfCard, "cell 0 0, alignx right");
        centerPanel.add((Component)this.txtCardNumber, "cell 1 0");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("DONE"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardDeActiveView.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)buttonPanel, "South");
    }

    public void doGenerate() {
        String cardNo = this.txtCardNumber.getText();
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardNotFound"));
            return;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return;
        }
        int value = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DeactivateCard"), Messages.getString("Deactivation"));
        if (value == 0) {
            if (!this.giftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.16"));
                return;
            }
            this.giftCard.setActive(false);
            this.giftCard.setDeActivationDate(new Date());
            this.giftCardProcessor.deactivate(this.giftCard);
            POSMessageDialog.showMessage(this, Messages.getString("CardDeactivatedSuccessfully"));
            this.dispose();
        }
    }
}

